/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.gameserver.engines.DocumentParser;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.options.EnchantOptions;
import com.l2jserver.gameserver.util.Util;
import java.util.logging.Level;
import jp.sf.l2j.arrayMaps.SortedIntObjectArrayMap;
import jp.sf.l2j.troja.FastIntObjectMap;
import org.w3c.dom.Node;

public class EnchantItemOptionsData
extends DocumentParser {
    private final FastIntObjectMap<SortedIntObjectArrayMap<EnchantOptions>> _data = new FastIntObjectMap();

    protected EnchantItemOptionsData() {
        this.load();
    }

    @Override
    public synchronized void load() {
        this._data.clear();
        this.parseDatapackFile("data/enchantItemOptions.xml");
    }

    @Override
    protected void parseDocument() {
        Node att = null;
        int counter = 0;
        for (Node n = this.getCurrentDocument().getFirstChild(); n != null; n = n.getNextSibling()) {
            if (!"list".equalsIgnoreCase(n.getNodeName())) continue;
            for (Node d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
                if (!"item".equalsIgnoreCase(d.getNodeName())) continue;
                int itemId = this.parseInt(d.getAttributes(), "id");
                SortedIntObjectArrayMap options = (SortedIntObjectArrayMap)this._data.get(itemId);
                if (options == null) {
                    options = new SortedIntObjectArrayMap((Object[])new EnchantOptions[0]);
                    this._data.put(itemId, (Object)options);
                }
                for (Node cd = d.getFirstChild(); cd != null; cd = cd.getNextSibling()) {
                    if (!"options".equalsIgnoreCase(cd.getNodeName())) continue;
                    EnchantOptions op = new EnchantOptions(this.parseInt(cd.getAttributes(), "level"));
                    options.append(op.getLevel(), (Object)op);
                    for (byte i = 0; i < 3; i = (byte)((byte)(i + 1))) {
                        att = cd.getAttributes().getNamedItem("option" + (i + 1));
                        if (att == null || !Util.isDigit(att.getNodeValue())) continue;
                        op.setOption(i, this.parseInt(att));
                    }
                    ++counter;
                }
            }
        }
        this._log.log(Level.INFO, this.getClass().getSimpleName() + ": Loaded: " + this._data.size() + " Items and " + counter + " Options.");
    }

    public EnchantOptions getOptions(int itemId, int enchantLevel) {
        SortedIntObjectArrayMap options = (SortedIntObjectArrayMap)this._data.get(itemId);
        if (options == null) {
            return null;
        }
        return (EnchantOptions)options.get(enchantLevel);
    }

    public EnchantOptions getOptions(L2ItemInstance item) {
        return item != null ? this.getOptions(item.getId(), item.getEnchantLevel()) : null;
    }

    public static final EnchantItemOptionsData getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final EnchantItemOptionsData _instance = new EnchantItemOptionsData();

        private SingletonHolder() {
        }
    }
}

