/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.gameserver.engines.DocumentParser;
import java.util.Arrays;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class ExperienceTable
extends DocumentParser {
    private long[] _expTable;
    private byte MAX_LEVEL;
    private byte MAX_PET_LEVEL;

    protected ExperienceTable() {
        this.load();
    }

    @Override
    public void load() {
        this._expTable = new long[0];
        this.parseDatapackFile("data/stats/experience.xml");
        this._log.info(this.getClass().getSimpleName() + ": Loaded " + this._expTable.length + " levels.");
        this._log.info(this.getClass().getSimpleName() + ": Max Player Level is: " + (this.MAX_LEVEL - 1));
        this._log.info(this.getClass().getSimpleName() + ": Max Pet Level is: " + (this.MAX_PET_LEVEL - 1));
    }

    @Override
    protected void parseDocument() {
        Node table = this.getCurrentDocument().getFirstChild();
        NamedNodeMap tableAttr = table.getAttributes();
        this.MAX_LEVEL = (byte)(Byte.parseByte(tableAttr.getNamedItem("maxLevel").getNodeValue()) + 1);
        this.MAX_PET_LEVEL = (byte)(Byte.parseByte(tableAttr.getNamedItem("maxPetLevel").getNodeValue()) + 1);
        for (Node n = table.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (!"experience".equals(n.getNodeName())) continue;
            NamedNodeMap attrs = n.getAttributes();
            int level = this.parseInteger(attrs, "level");
            long tolevel = this.parseLong(attrs, "tolevel");
            if (this._expTable.length <= level) {
                this._expTable = Arrays.copyOf(this._expTable, level + 1);
            }
            this._expTable[level] = tolevel;
        }
    }

    public long getExpForLevel(int level) {
        return this._expTable[level];
    }

    public byte getMaxLevel() {
        return this.MAX_LEVEL;
    }

    public byte getMaxPetLevel() {
        return this.MAX_PET_LEVEL;
    }

    public static ExperienceTable getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final ExperienceTable _instance = new ExperienceTable();

        private SingletonHolder() {
        }
    }
}

