/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.SkillTreesData;
import com.l2jserver.gameserver.engines.DocumentEngine;
import com.l2jserver.gameserver.model.skills.Skill;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TIntByteHashMap;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import jp.sf.l2j.troja.FastIntObjectMap;

public final class SkillData {
    private static Logger _log = Logger.getLogger(SkillData.class.getName());
    private FastIntObjectMap<Skill> _skills;
    private TIntByteHashMap _skillMaxLevel;
    private int[] _enchantable;
    public static final int PRIME = 1021;

    protected SkillData() {
        this.load();
    }

    public void reload() {
        this.load();
        SkillTreesData.getInstance().load();
    }

    private void load() {
        FastIntObjectMap skills = new FastIntObjectMap();
        TIntByteHashMap skillMaxLevel = new TIntByteHashMap();
        TIntArrayList enchantable = new TIntArrayList();
        DocumentEngine.getInstance().loadAllSkills((FastIntObjectMap<Skill>)skills);
        for (Skill skill : skills.values()) {
            int skillId = skill.getId();
            int skillLvl = skill.getLevel();
            if (skillLvl > 99) {
                if (enchantable.contains(skillId)) continue;
                enchantable.add(skillId);
                continue;
            }
            byte maxLvl = skillMaxLevel.get(skillId);
            if (skillLvl <= maxLvl) continue;
            skillMaxLevel.put(skillId, (byte)skillLvl);
        }
        skillMaxLevel.trimToSize();
        enchantable.sort();
        this._skills = skills;
        this._skillMaxLevel = skillMaxLevel;
        this._enchantable = enchantable.toArray();
    }

    public static int getSkillHashCode(Skill skill) {
        return SkillData.getSkillHashCode(skill.getId(), skill.getLevel());
    }

    public static int getSkillHashCode(int skillId, int skillLevel) {
        return skillId * 1021 + skillLevel;
    }

    public static int getSkillId(int skillHashCode) {
        return skillHashCode / 1021;
    }

    public static int getSkillLevel(int skillHashCode) {
        return skillHashCode % 1021;
    }

    public static Skill getSkill(int skillHashCode) {
        return (Skill)SkillData.getInstance()._skills.get(skillHashCode);
    }

    @Deprecated
    public final Skill getInfo(int skillHashCode) {
        return (Skill)this._skills.get(skillHashCode);
    }

    @Deprecated
    public final Skill getInfo(int skillId, int level) {
        return this.getSkill(skillId, level);
    }

    public Skill getSkill(int skillId, int level) {
        Skill result = (Skill)this._skills.get(SkillData.getSkillHashCode(skillId, level));
        if (result != null) {
            return result;
        }
        int maxLvl = this.getMaxLevel(skillId);
        if (maxLvl > 0 && level > maxLvl) {
            if (Config.DEBUG) {
                _log.log(Level.WARNING, this.getClass().getSimpleName() + ": call to unexisting skill level id: " + skillId + " requested level: " + level + " max level: " + maxLvl, new Throwable());
            }
            return (Skill)this._skills.get(SkillData.getSkillHashCode(skillId, maxLvl));
        }
        _log.warning(this.getClass().getSimpleName() + ": No skill info found for skill id " + skillId + " and skill level " + level + ".");
        return null;
    }

    public int getMaxLevel(int skillId) {
        return this._skillMaxLevel.get(skillId);
    }

    public boolean isEnchantable(int skillId) {
        return Arrays.binarySearch(this._enchantable, skillId) >= 0;
    }

    public Skill[] getSiegeSkills(boolean addNoble, boolean hasCastle) {
        Skill[] temp = new Skill[2 + (addNoble ? 1 : 0) + (hasCastle ? 2 : 0)];
        int i = 0;
        temp[i++] = (Skill)this._skills.get(SkillData.getSkillHashCode(246, 1));
        temp[i++] = (Skill)this._skills.get(SkillData.getSkillHashCode(247, 1));
        if (addNoble) {
            temp[i++] = (Skill)this._skills.get(SkillData.getSkillHashCode(326, 1));
        }
        if (hasCastle) {
            temp[i++] = (Skill)this._skills.get(SkillData.getSkillHashCode(844, 1));
            temp[i++] = (Skill)this._skills.get(SkillData.getSkillHashCode(845, 1));
        }
        return temp;
    }

    public static SkillData getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final SkillData _instance = new SkillData();

        private SingletonHolder() {
        }
    }
}

