/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.handler;

import com.l2jserver.gameserver.handler.IHandler;
import com.l2jserver.gameserver.model.effects.AbstractEffect;
import com.l2jserver.gameserver.scripting.L2ScriptEngineManager;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public final class EffectHandler
implements IHandler<Class<? extends AbstractEffect>, String> {
    private final Map<String, Class<? extends AbstractEffect>> _handlers = new HashMap<String, Class<? extends AbstractEffect>>();

    protected EffectHandler() {
    }

    @Override
    public void registerHandler(Class<? extends AbstractEffect> handler) {
        this._handlers.put(handler.getSimpleName(), handler);
    }

    @Override
    public synchronized void removeHandler(Class<? extends AbstractEffect> handler) {
        this._handlers.remove(handler.getSimpleName());
    }

    @Override
    public Class<? extends AbstractEffect> getHandler(String name) {
        return this._handlers.get(name);
    }

    @Override
    public int size() {
        return this._handlers.size();
    }

    public void executeScript() {
        try {
            File file = new File(L2ScriptEngineManager.SCRIPT_FOLDER, "handlers/EffectMasterHandler.java");
            L2ScriptEngineManager.getInstance().executeScript(file);
        }
        catch (Exception e) {
            throw new Error("Problems while running EffectMansterHandler", e);
        }
    }

    public static EffectHandler getInstance() {
        return SingletonHolder._instance;
    }

    private static final class SingletonHolder {
        protected static final EffectHandler _instance = new EffectHandler();

        private SingletonHolder() {
        }
    }
}

