/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.handlers.admincommandhandlers;

import com.l2jserver.gameserver.GameTimeController;
import com.l2jserver.gameserver.Shutdown;
import com.l2jserver.gameserver.handler.IAdminCommandHandler;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public class AdminShutdown
implements IAdminCommandHandler {
    private static final String[] ADMIN_COMMANDS = new String[]{"admin_server_shutdown", "admin_server_restart", "admin_server_abort"};

    @Override
    public boolean useAdminCommand(String command, L2PcInstance activeChar) {
        if (command.startsWith("admin_server_shutdown")) {
            try {
                int val = Integer.parseInt(command.substring(22));
                this.serverShutdown(activeChar, val, false);
            }
            catch (NumberFormatException | StringIndexOutOfBoundsException e) {
                activeChar.sendMessage("Usage: //server_shutdown <seconds>");
                this.sendHtmlForm(activeChar);
            }
        } else if (command.startsWith("admin_server_restart")) {
            try {
                int val = Integer.parseInt(command.substring(21));
                this.serverShutdown(activeChar, val, true);
            }
            catch (NumberFormatException | StringIndexOutOfBoundsException e) {
                activeChar.sendMessage("Usage: //server_restart <seconds>");
                this.sendHtmlForm(activeChar);
            }
        } else if (command.startsWith("admin_server_abort")) {
            this.serverAbort(activeChar);
        }
        return true;
    }

    @Override
    public String[] getAdminCommandList() {
        return ADMIN_COMMANDS;
    }

    private void sendHtmlForm(L2PcInstance activeChar) {
        NpcHtmlMessage adminReply = new NpcHtmlMessage();
        int t = GameTimeController.getInstance().getGameTime();
        int h = t / 60;
        int m = t % 60;
        SimpleDateFormat format = new SimpleDateFormat("h:mm a");
        Calendar cal = Calendar.getInstance();
        cal.set(11, h);
        cal.set(12, m);
        adminReply.setFile(activeChar.getHtmlPrefix(), "data/html/admin/shutdown.htm");
        adminReply.replace((CharSequence)"%count%", L2World.getInstance().getAllPlayersCount());
        adminReply.replace((CharSequence)"%used%", String.format("%,3d", Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()));
        adminReply.replace((CharSequence)"%time%", format.format(cal.getTime()));
        activeChar.sendPacket(adminReply);
    }

    private void serverShutdown(L2PcInstance activeChar, int seconds, boolean restart) {
        Shutdown.getInstance().startShutdown(activeChar, seconds, restart);
    }

    private void serverAbort(L2PcInstance activeChar) {
        Shutdown.getInstance().abort(activeChar);
    }
}

