/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.gameserver.Announcements;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.ai.L2ControllableMobAI;
import com.l2jserver.gameserver.datatables.NpcData;
import com.l2jserver.gameserver.model.MobGroup;
import com.l2jserver.gameserver.model.MobGroupTable;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.util.Rnd;
import java.util.concurrent.ScheduledFuture;
import java.util.logging.Logger;

public class BvBManager {
    protected static Logger _log = Logger.getLogger(BvBManager.class.getName());
    private static BvBManager _instance = new BvBManager();
    static final int[] _spawnLocation1 = new int[]{148733, 46721, -3438, 0};
    static final int[] _spawnLocation2 = new int[]{150058, 46721, -3412, 32768};
    static final int[] _bossIds = new int[]{29020, 29028, 29046, 29047};
    MobGroup _group1;
    MobGroup _group2;
    int _group1Id;
    int _group2Id;
    ScheduledFuture<?> _TimeUpTask;
    ScheduledFuture<?> _CheckWinnerTask;

    public static BvBManager getInstance() {
        if (_instance == null) {
            _instance = new BvBManager();
        }
        return _instance;
    }

    public void start() {
        if (this._group1 != null && this._group2 != null) {
            return;
        }
        if (this._group1 == null) {
            this._group1Id = MobGroupTable.getInstance().getGroupCount() + 1;
            L2NpcTemplate template1 = NpcData.getInstance().getTemplate(_bossIds[Rnd.get(_bossIds.length)]);
            this._group1 = new MobGroup(this._group1Id, template1, 1);
            MobGroupTable.getInstance().addGroup(this._group1Id, this._group1);
            this._group1.spawnGroup(_spawnLocation1[0], _spawnLocation1[1], _spawnLocation1[2]);
            this._group1.getMobs().get(0).setHeading(_spawnLocation1[3]);
            Announcements.getInstance().announceToAll(this._group1.getMobs().get(0).getName() + " \u304c\u51fa\u73fe\u3057\u307e\u3057\u305f\u3002");
        }
        if (this._group2 == null) {
            this._group2Id = MobGroupTable.getInstance().getGroupCount() + 1;
            L2NpcTemplate template2 = NpcData.getInstance().getTemplate(_bossIds[Rnd.get(_bossIds.length)]);
            this._group2 = new MobGroup(this._group2Id, template2, 1);
            MobGroupTable.getInstance().addGroup(this._group2Id, this._group2);
            this._group2.spawnGroup(_spawnLocation2[0], _spawnLocation2[1], _spawnLocation2[2]);
            this._group2.getMobs().get(0).setHeading(_spawnLocation2[3]);
            Announcements.getInstance().announceToAll(this._group2.getMobs().get(0).getName() + " \u304c\u51fa\u73fe\u3057\u307e\u3057\u305f\u3002");
        }
        if (this._TimeUpTask == null) {
            this._TimeUpTask = ThreadPoolManager.getInstance().scheduleGeneral(new TimeUp(), 0x6DDD00L);
        }
        if (this._CheckWinnerTask == null) {
            this._CheckWinnerTask = ThreadPoolManager.getInstance().scheduleGeneral(new CheckWinner(), 10000L);
        }
        Announcements.getInstance().announceToAll(this._group1.getMobs().get(0).getName() + " \u3068 " + this._group2.getMobs().get(0).getName() + " \u304c\u6226\u3044\u307e\u3059\u3002");
    }

    public void end() {
        if (this._group1 != null) {
            this._group1.unspawnGroup();
            MobGroupTable.getInstance().removeGroup(this._group1Id);
            this._group1 = null;
        }
        if (this._group2 != null) {
            this._group2.unspawnGroup();
            MobGroupTable.getInstance().removeGroup(this._group2Id);
            this._group2 = null;
        }
        if (this._TimeUpTask != null) {
            this._TimeUpTask.cancel(true);
            this._TimeUpTask = null;
        }
        if (this._CheckWinnerTask != null) {
            this._CheckWinnerTask.cancel(true);
            this._CheckWinnerTask = null;
        }
    }

    class CheckWinner
    implements Runnable {
        CheckWinner() {
        }

        @Override
        public void run() {
            assert (BvBManager.this._group1 != null && BvBManager.this._group2 != null);
            if (BvBManager.this._group1.getMobs().get(0).isDead()) {
                BvBManager.this._group1.unspawnGroup();
                MobGroupTable.getInstance().removeGroup(BvBManager.this._group1Id);
                BvBManager.this._group1 = null;
            }
            if (BvBManager.this._group2.getMobs().get(0).isDead()) {
                BvBManager.this._group2.unspawnGroup();
                MobGroupTable.getInstance().removeGroup(BvBManager.this._group2Id);
                BvBManager.this._group2 = null;
            }
            BvBManager.this._CheckWinnerTask = null;
            if (BvBManager.this._group1 != null && BvBManager.this._group2 != null) {
                L2ControllableMobAI ai1 = (L2ControllableMobAI)BvBManager.this._group1.getMobs().get(0).getAI();
                ai1.setAlternateAI(3);
                ai1.forceAttack(BvBManager.this._group2.getMobs().get(0));
                L2ControllableMobAI ai2 = (L2ControllableMobAI)BvBManager.this._group2.getMobs().get(0).getAI();
                ai2.setAlternateAI(3);
                ai2.forceAttack(BvBManager.this._group1.getMobs().get(0));
                BvBManager.this._CheckWinnerTask = ThreadPoolManager.getInstance().scheduleGeneral(new CheckWinner(), 5000L);
            } else if (BvBManager.this._group1 != null) {
                Announcements.getInstance().announceToAll(BvBManager.this._group1.getMobs().get(0).getName() + " \u304c\u52dd\u5229\u3057\u307e\u3057\u305f\u3002");
                L2ControllableMobAI ai1 = (L2ControllableMobAI)BvBManager.this._group1.getMobs().get(0).getAI();
                ai1.move(_spawnLocation1[0], _spawnLocation1[1], _spawnLocation1[2]);
            } else if (BvBManager.this._group2 != null) {
                Announcements.getInstance().announceToAll(BvBManager.this._group2.getMobs().get(0).getName() + " \u304c\u52dd\u5229\u3057\u307e\u3057\u305f\u3002");
                L2ControllableMobAI ai2 = (L2ControllableMobAI)BvBManager.this._group1.getMobs().get(0).getAI();
                ai2.move(_spawnLocation2[0], _spawnLocation2[1], _spawnLocation2[2]);
            } else {
                BvBManager.this.end();
            }
        }
    }

    class TimeUp
    implements Runnable {
        TimeUp() {
        }

        @Override
        public void run() {
            Announcements.getInstance().announceToAll("\u6642\u9593\u5207\u308c\u5f15\u304d\u5206\u3051\u3067\u3059\u3002");
            BvBManager.this.end();
        }
    }
}

