/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.datatables.NpcData;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.gameserver.model.entity.Fort;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastList;
import javolution.util.FastMap;

public final class FortSiegeGuardManager {
    private static final Logger _log = Logger.getLogger(FortSiegeGuardManager.class.getName());
    private final Fort _fort;
    private final FastMap<Integer, FastList<L2Spawn>> _siegeGuards = new FastMap();
    private FastList<L2Spawn> _siegeGuardsSpawns;

    public FortSiegeGuardManager(Fort fort) {
        this._fort = fort;
    }

    public void spawnSiegeGuard() {
        try {
            FastList monsterList = (FastList)this.getSiegeGuardSpawn().get((Object)this.getFort().getResidenceId());
            if (monsterList != null) {
                for (L2Spawn spawnDat : monsterList) {
                    spawnDat.doSpawn();
                    if (spawnDat.getRespawnDelay() == 0) {
                        spawnDat.stopRespawn();
                        continue;
                    }
                    spawnDat.startRespawn();
                }
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Error spawning siege guards for fort " + this.getFort().getName() + ":" + e.getMessage(), e);
        }
    }

    public void unspawnSiegeGuard() {
        try {
            FastList monsterList = (FastList)this.getSiegeGuardSpawn().get((Object)this.getFort().getResidenceId());
            if (monsterList != null) {
                for (L2Spawn spawnDat : monsterList) {
                    spawnDat.stopRespawn();
                    if (spawnDat.getLastSpawn() == null) continue;
                    spawnDat.getLastSpawn().doDie(spawnDat.getLastSpawn());
                }
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Error unspawning siege guards for fort " + this.getFort().getName() + ":" + e.getMessage(), e);
        }
    }

    void loadSiegeGuard() {
        this._siegeGuards.clear();
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement ps = con.prepareStatement("SELECT * FROM fort_siege_guards Where fortId = ? ");){
            ps.setInt(1, this.getFort().getResidenceId());
            try (ResultSet rs = ps.executeQuery();){
                this._siegeGuardsSpawns = new FastList();
                while (rs.next()) {
                    int fortId = rs.getInt("fortId");
                    L2NpcTemplate template1 = NpcData.getInstance().getTemplate(rs.getInt("npcId"));
                    if (template1 != null) {
                        L2Spawn spawn1 = new L2Spawn(template1);
                        spawn1.setAmount(1);
                        spawn1.setX(rs.getInt("x"));
                        spawn1.setY(rs.getInt("y"));
                        spawn1.setZ(rs.getInt("z"));
                        spawn1.setHeading(rs.getInt("heading"));
                        spawn1.setRespawnDelay(rs.getInt("respawnDelay"));
                        spawn1.setLocationId(0);
                        this._siegeGuardsSpawns.add((Object)spawn1);
                    } else {
                        _log.warning("Missing npc data in npc table for id: " + rs.getInt("npcId"));
                    }
                    this._siegeGuards.put((Object)fortId, this._siegeGuardsSpawns);
                }
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Error loading siege guard for fort " + this.getFort().getName() + ": " + e.getMessage(), e);
        }
    }

    public final Fort getFort() {
        return this._fort;
    }

    public final FastMap<Integer, FastList<L2Spawn>> getSiegeGuardSpawn() {
        return this._siegeGuards;
    }
}

