/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.ItemsAutoDestroy;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.instancemanager.CursedWeaponsManager;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastList;

public final class ItemsOnGroundManager
implements Runnable {
    private static final Logger _log = Logger.getLogger(ItemsOnGroundManager.class.getName());
    private final FastList<L2ItemInstance> _items = new FastList().shared();

    protected ItemsOnGroundManager() {
        if (Config.SAVE_DROPPED_ITEM_INTERVAL > 0) {
            ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(this, Config.SAVE_DROPPED_ITEM_INTERVAL, Config.SAVE_DROPPED_ITEM_INTERVAL);
        }
        this.load();
    }

    private void load() {
        if (!Config.SAVE_DROPPED_ITEM && Config.CLEAR_DROPPED_ITEM_TABLE) {
            this.emptyTable();
        }
        if (!Config.SAVE_DROPPED_ITEM) {
            return;
        }
        if (Config.DESTROY_DROPPED_PLAYER_ITEM) {
            String str = null;
            if (!Config.DESTROY_EQUIPABLE_PLAYER_ITEM) {
                str = "UPDATE itemsonground SET drop_time = ? WHERE drop_time = -1 AND equipable = 0";
            } else if (Config.DESTROY_EQUIPABLE_PLAYER_ITEM) {
                str = "UPDATE itemsonground SET drop_time = ? WHERE drop_time = -1";
            }
            try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
                 PreparedStatement ps = con.prepareStatement(str);){
                ps.setLong(1, System.currentTimeMillis());
                ps.execute();
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, this.getClass().getSimpleName() + ": Error while updating table ItemsOnGround " + e.getMessage(), e);
            }
        }
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement ps = con.prepareStatement("SELECT object_id,item_id,count,enchant_level,x,y,z,drop_time,equipable FROM itemsonground");){
            int count = 0;
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    L2ItemInstance item = new L2ItemInstance(rs.getInt(1), rs.getInt(2));
                    L2World.getInstance().storeObject(item);
                    if (item.isStackable() && rs.getInt(3) > 1) {
                        item.setCount(rs.getInt(3));
                    }
                    if (rs.getInt(4) > 0) {
                        item.setEnchantLevel(rs.getInt(4));
                    }
                    item.setXYZ(rs.getInt(5), rs.getInt(6), rs.getInt(7));
                    item.setWorldRegion(L2World.getInstance().getRegion(item.getPosition()));
                    item.getWorldRegion().addVisibleObject(item);
                    long dropTime = rs.getLong(8);
                    item.setDropTime(dropTime);
                    item.setProtected(dropTime == -1L);
                    item.setIsVisible(true);
                    L2World.getInstance().addVisibleObject(item, item.getWorldRegion());
                    this._items.add((Object)item);
                    ++count;
                    if (Config.LIST_PROTECTED_ITEMS.contains(item.getId()) || dropTime <= -1L || (Config.AUTODESTROY_ITEM_AFTER <= 0 || item.getItem().hasExImmediateEffect()) && (Config.HERB_AUTO_DESTROY_TIME <= 0 || !item.getItem().hasExImmediateEffect())) continue;
                    ItemsAutoDestroy.getInstance().addItem(item);
                }
            }
            _log.info(this.getClass().getSimpleName() + ": Loaded " + count + " items.");
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, this.getClass().getSimpleName() + ": Error while loading ItemsOnGround " + e.getMessage(), e);
        }
        if (Config.EMPTY_DROPPED_ITEM_TABLE_AFTER_LOAD) {
            this.emptyTable();
        }
    }

    public void save(L2ItemInstance item) {
        if (!Config.SAVE_DROPPED_ITEM) {
            return;
        }
        if (item.getInstanceId() != 0) {
            return;
        }
        this._items.add((Object)item);
    }

    public void removeObject(L2ItemInstance item) {
        if (Config.SAVE_DROPPED_ITEM) {
            this._items.remove((Object)item);
        }
    }

    public void saveInDb() {
        this.run();
    }

    public void cleanUp() {
        this._items.clear();
    }

    public void emptyTable() {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             Statement s = con.createStatement();){
            s.executeUpdate("DELETE FROM itemsonground");
        }
        catch (Exception e1) {
            _log.log(Level.SEVERE, this.getClass().getSimpleName() + ": Error while cleaning table ItemsOnGround " + e1.getMessage(), e1);
        }
    }

    @Override
    public synchronized void run() {
        if (!Config.SAVE_DROPPED_ITEM) {
            return;
        }
        this.emptyTable();
        if (this._items.isEmpty()) {
            return;
        }
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement statement = con.prepareStatement("INSERT INTO itemsonground(object_id,item_id,count,enchant_level,x,y,z,drop_time,equipable) VALUES(?,?,?,?,?,?,?,?,?)");){
            for (L2ItemInstance item : this._items) {
                if (item == null || !item.isVisible() || CursedWeaponsManager.getInstance().isCursed(item.getId())) continue;
                try {
                    statement.setInt(1, item.getObjectId());
                    statement.setInt(2, item.getId());
                    statement.setLong(3, item.getCount());
                    statement.setInt(4, item.getEnchantLevel());
                    statement.setInt(5, item.getX());
                    statement.setInt(6, item.getY());
                    statement.setInt(7, item.getZ());
                    statement.setLong(8, item.isProtected() ? -1L : item.getDropTime());
                    statement.setLong(9, item.isEquipable() ? 1 : 0);
                    statement.execute();
                    statement.clearParameters();
                }
                catch (Exception e) {
                    _log.log(Level.SEVERE, this.getClass().getSimpleName() + ": Error while inserting into table ItemsOnGround: " + e.getMessage(), e);
                }
            }
        }
        catch (SQLException e) {
            _log.log(Level.SEVERE, this.getClass().getSimpleName() + ": SQL error while storing items on ground: " + e.getMessage(), e);
        }
    }

    public static final ItemsOnGroundManager getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final ItemsOnGroundManager _instance = new ItemsOnGroundManager();

        private SingletonHolder() {
        }
    }
}

