/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.model.holders.PunishmentHolder;
import com.l2jserver.gameserver.model.punishment.PunishmentAffect;
import com.l2jserver.gameserver.model.punishment.PunishmentTask;
import com.l2jserver.gameserver.model.punishment.PunishmentType;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class PunishmentManager {
    private static final Logger _log = Logger.getLogger(PunishmentManager.class.getName());
    private final Map<PunishmentAffect, PunishmentHolder> _tasks = new ConcurrentHashMap<PunishmentAffect, PunishmentHolder>();

    protected PunishmentManager() {
        this.load();
    }

    private void load() {
        for (PunishmentAffect affect : PunishmentAffect.values()) {
            this._tasks.put(affect, new PunishmentHolder());
        }
        int initiated = 0;
        int expired = 0;
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             Statement st = con.createStatement();
             ResultSet rset = st.executeQuery("SELECT * FROM punishments");){
            while (rset.next()) {
                int id = rset.getInt("id");
                String key = rset.getString("key");
                PunishmentAffect affect = PunishmentAffect.getByName(rset.getString("affect"));
                PunishmentType type = PunishmentType.getByName(rset.getString("type"));
                long expirationTime = rset.getLong("expiration");
                String reason = rset.getString("reason");
                String punishedBy = rset.getString("punishedBy");
                if (type == null || affect == null) continue;
                if (expirationTime > 0L && System.currentTimeMillis() > expirationTime) {
                    ++expired;
                    continue;
                }
                ++initiated;
                this._tasks.get((Object)affect).addPunishment(new PunishmentTask(id, key, affect, type, expirationTime, reason, punishedBy, true));
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, this.getClass().getSimpleName() + ": Error while loading punishments: ", e);
        }
        _log.log(Level.INFO, this.getClass().getSimpleName() + ": Loaded " + initiated + " active and " + expired + " expired punishments.");
    }

    public void startPunishment(PunishmentTask task) {
        this._tasks.get((Object)task.getAffect()).addPunishment(task);
    }

    public void stopPunishment(Object key, PunishmentAffect affect, PunishmentType type) {
        PunishmentTask task = this.getPunishment(key, affect, type);
        if (task != null) {
            this._tasks.get((Object)affect).stopPunishment(task);
        }
    }

    public boolean hasPunishment(Object key, PunishmentAffect affect, PunishmentType type) {
        PunishmentHolder holder = this._tasks.get((Object)affect);
        return holder.hasPunishment(String.valueOf(key), type);
    }

    public long getPunishmentExpiration(Object key, PunishmentAffect affect, PunishmentType type) {
        PunishmentTask p = this.getPunishment(key, affect, type);
        return p != null ? p.getExpirationTime() : 0L;
    }

    private PunishmentTask getPunishment(Object key, PunishmentAffect affect, PunishmentType type) {
        return this._tasks.get((Object)affect).getPunishment(String.valueOf(key), type);
    }

    public static final PunishmentManager getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final PunishmentManager _instance = new PunishmentManager();

        private SingletonHolder() {
        }
    }
}

