/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.holders.SkillHolder;
import com.l2jserver.gameserver.model.itemcontainer.PcInventory;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import java.util.ArrayList;
import java.util.List;

public final class L2ArmorSet {
    private int _chestId;
    private final List<Integer> _legs = new ArrayList<Integer>();
    private final List<Integer> _head = new ArrayList<Integer>();
    private final List<Integer> _gloves = new ArrayList<Integer>();
    private final List<Integer> _feet = new ArrayList<Integer>();
    private final List<Integer> _shield = new ArrayList<Integer>();
    private final List<SkillHolder> _skills = new ArrayList<SkillHolder>();
    private final List<SkillHolder> _shieldSkills = new ArrayList<SkillHolder>();
    private final List<SkillHolder> _enchant6Skill = new ArrayList<SkillHolder>();
    private int _con;
    private int _dex;
    private int _str;
    private int _men;
    private int _wit;
    private int _int;

    public void addChest(int id) {
        this._chestId = id;
    }

    public void addLegs(int id) {
        this._legs.add(id);
    }

    public void addHead(int id) {
        this._head.add(id);
    }

    public void addGloves(int id) {
        this._gloves.add(id);
    }

    public void addFeet(int id) {
        this._feet.add(id);
    }

    public void addShield(int id) {
        this._shield.add(id);
    }

    public void addSkill(SkillHolder holder) {
        this._skills.add(holder);
    }

    public void addShieldSkill(SkillHolder holder) {
        this._shieldSkills.add(holder);
    }

    public void addEnchant6Skill(SkillHolder holder) {
        this._enchant6Skill.add(holder);
    }

    public void addCon(int val) {
        this._con = val;
    }

    public void addDex(int val) {
        this._dex = val;
    }

    public void addStr(int val) {
        this._str = val;
    }

    public void addMen(int val) {
        this._men = val;
    }

    public void addWit(int val) {
        this._wit = val;
    }

    public void addInt(int val) {
        this._int = val;
    }

    public boolean containAll(L2PcInstance player) {
        PcInventory inv = player.getInventory();
        L2ItemInstance legsItem = inv.getPaperdollItem(11);
        L2ItemInstance headItem = inv.getPaperdollItem(1);
        L2ItemInstance glovesItem = inv.getPaperdollItem(10);
        L2ItemInstance feetItem = inv.getPaperdollItem(12);
        int legs = 0;
        int head = 0;
        int gloves = 0;
        int feet = 0;
        if (legsItem != null) {
            legs = legsItem.getId();
        }
        if (headItem != null) {
            head = headItem.getId();
        }
        if (glovesItem != null) {
            gloves = glovesItem.getId();
        }
        if (feetItem != null) {
            feet = feetItem.getId();
        }
        return this.containAll(this._chestId, legs, head, gloves, feet);
    }

    public boolean containAll(int chest, int legs, int head, int gloves, int feet) {
        if (this._chestId != 0 && this._chestId != chest) {
            return false;
        }
        if (!this._legs.isEmpty() && !this._legs.contains(legs)) {
            return false;
        }
        if (!this._head.isEmpty() && !this._head.contains(head)) {
            return false;
        }
        if (!this._gloves.isEmpty() && !this._gloves.contains(gloves)) {
            return false;
        }
        return this._feet.isEmpty() || this._feet.contains(feet);
    }

    public boolean containItem(int slot, int itemId) {
        switch (slot) {
            case 6: {
                return this._chestId == itemId;
            }
            case 11: {
                return this._legs.contains(itemId);
            }
            case 1: {
                return this._head.contains(itemId);
            }
            case 10: {
                return this._gloves.contains(itemId);
            }
            case 12: {
                return this._feet.contains(itemId);
            }
        }
        return false;
    }

    public int getChestId() {
        return this._chestId;
    }

    public List<SkillHolder> getSkills() {
        return this._skills;
    }

    public boolean containShield(L2PcInstance player) {
        PcInventory inv = player.getInventory();
        L2ItemInstance shieldItem = inv.getPaperdollItem(7);
        return shieldItem != null && this._shield.contains(shieldItem.getId());
    }

    public boolean containShield(int shield_id) {
        if (this._shield.isEmpty()) {
            return false;
        }
        return this._shield.contains(shield_id);
    }

    public List<SkillHolder> getShieldSkillId() {
        return this._shieldSkills;
    }

    public List<SkillHolder> getEnchant6skillId() {
        return this._enchant6Skill;
    }

    public boolean isEnchanted6(L2PcInstance player) {
        if (!this.containAll(player)) {
            return false;
        }
        PcInventory inv = player.getInventory();
        L2ItemInstance chestItem = inv.getPaperdollItem(6);
        L2ItemInstance legsItem = inv.getPaperdollItem(11);
        L2ItemInstance headItem = inv.getPaperdollItem(1);
        L2ItemInstance glovesItem = inv.getPaperdollItem(10);
        L2ItemInstance feetItem = inv.getPaperdollItem(12);
        if (chestItem == null || chestItem.getEnchantLevel() < 6) {
            return false;
        }
        if (!(this._legs.isEmpty() || legsItem != null && legsItem.getEnchantLevel() >= 6)) {
            return false;
        }
        if (!(this._gloves.isEmpty() || glovesItem != null && glovesItem.getEnchantLevel() >= 6)) {
            return false;
        }
        if (!(this._head.isEmpty() || headItem != null && headItem.getEnchantLevel() >= 6)) {
            return false;
        }
        return this._feet.isEmpty() || feetItem != null && feetItem.getEnchantLevel() >= 6;
    }

    public int getCON() {
        return this._con;
    }

    public int getDEX() {
        return this._dex;
    }

    public int getSTR() {
        return this._str;
    }

    public int getMEN() {
        return this._men;
    }

    public int getWIT() {
        return this._wit;
    }

    public int getINT() {
        return this._int;
    }
}

