/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import java.util.ArrayList;
import java.util.List;

public final class L2EnchantSkillGroup {
    private final int _id;
    private final List<EnchantSkillHolder> _enchantDetails = new ArrayList<EnchantSkillHolder>();

    public L2EnchantSkillGroup(int id) {
        this._id = id;
    }

    public void addEnchantDetail(EnchantSkillHolder detail) {
        this._enchantDetails.add(detail);
    }

    public int getId() {
        return this._id;
    }

    public List<EnchantSkillHolder> getEnchantGroupDetails() {
        return this._enchantDetails;
    }

    public static class EnchantSkillHolder {
        private final int _level;
        private final int _adenaCost;
        private final int _expCost;
        private final int _spCost;
        private final byte[] _rate;

        public EnchantSkillHolder(StatsSet set) {
            this._level = set.getInt("level");
            this._adenaCost = set.getInt("adena");
            this._expCost = set.getInt("exp");
            this._spCost = set.getInt("sp");
            this._rate = new byte[24];
            for (int i = 0; i < 24; ++i) {
                this._rate[i] = set.getByte("chance" + (76 + i), (byte)0);
            }
        }

        public int getLevel() {
            return this._level;
        }

        public int getSpCost() {
            return this._spCost;
        }

        public int getExpCost() {
            return this._expCost;
        }

        public int getAdenaCost() {
            return this._adenaCost;
        }

        public byte getRate(L2PcInstance ply) {
            if (ply.getLevel() < 76) {
                return 0;
            }
            return this._rate[ply.getLevel() - 76];
        }
    }
}

