/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.gameserver.datatables.EnchantSkillGroupsData;
import com.l2jserver.gameserver.model.L2EnchantSkillGroup;
import java.util.Set;
import java.util.TreeMap;

public final class L2EnchantSkillLearn {
    private final int _id;
    private final int _baseLvl;
    private final TreeMap<Integer, Integer> _enchantRoutes = new TreeMap();

    public L2EnchantSkillLearn(int id, int baseLvl) {
        this._id = id;
        this._baseLvl = baseLvl;
    }

    public void addNewEnchantRoute(int route, int group) {
        this._enchantRoutes.put(route, group);
    }

    public int getId() {
        return this._id;
    }

    public int getBaseLevel() {
        return this._baseLvl;
    }

    public static int getEnchantRoute(int level) {
        return (int)Math.floor(level / 100);
    }

    public static int getEnchantIndex(int level) {
        return level % 100 - 1;
    }

    public static int getEnchantType(int level) {
        return (level - 1) / 100 - 1;
    }

    public L2EnchantSkillGroup getFirstRouteGroup() {
        return EnchantSkillGroupsData.getInstance().getEnchantSkillGroupById(this._enchantRoutes.firstEntry().getValue());
    }

    public Set<Integer> getAllRoutes() {
        return this._enchantRoutes.keySet();
    }

    public int getMinSkillLevel(int level) {
        if (level % 100 == 1) {
            return this._baseLvl;
        }
        return level - 1;
    }

    public boolean isMaxEnchant(int level) {
        Integer enchantRoute;
        int enchantType = L2EnchantSkillLearn.getEnchantRoute(level);
        if (enchantType < 1 || (enchantRoute = this._enchantRoutes.get(enchantType)) == null) {
            return false;
        }
        L2EnchantSkillGroup group = EnchantSkillGroupsData.getInstance().getEnchantSkillGroupById(enchantRoute);
        int max = group.getEnchantGroupDetails().size() - 1;
        int index = L2EnchantSkillLearn.getEnchantIndex(level);
        return index >= max;
    }

    public L2EnchantSkillGroup.EnchantSkillHolder getEnchantSkillHolder(int level) {
        Integer enchantRoute;
        int enchantType = L2EnchantSkillLearn.getEnchantRoute(level);
        if (enchantType < 1 || (enchantRoute = this._enchantRoutes.get(enchantType)) == null) {
            return null;
        }
        L2EnchantSkillGroup group = EnchantSkillGroupsData.getInstance().getEnchantSkillGroupById(enchantRoute);
        int max = group.getEnchantGroupDetails().size() - 1;
        int index = L2EnchantSkillLearn.getEnchantIndex(level);
        if (index < 0) {
            index = 0;
        } else if (index > max) {
            index = max;
        }
        return group.getEnchantGroupDetails().get(index);
    }
}

