/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.datatables.SkillData;
import com.l2jserver.gameserver.instancemanager.HandysBlockCheckerManager;
import com.l2jserver.gameserver.model.ArenaParticipantsHolder;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2MonsterInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.gameserver.model.entity.BlockCheckerEngine;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.AbstractNpcInfo;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.ExCubeGameChangePoints;
import com.l2jserver.gameserver.network.serverpackets.ExCubeGameExtendedChangePoints;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.util.Rnd;

public class L2BlockInstance
extends L2MonsterInstance {
    private int _colorEffect;

    public L2BlockInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void changeColor(L2PcInstance attacker, ArenaParticipantsHolder holder, int team, int color) {
        L2BlockInstance l2BlockInstance = this;
        synchronized (l2BlockInstance) {
            if (this._colorEffect != color) {
                this._colorEffect = color;
                this.broadcastPacket(new AbstractNpcInfo.NpcInfo(this, attacker));
                this.increaseTeamPointsAndSend(attacker, team, holder.getEvent());
            }
            int random = Rnd.get(100);
            if ((random -= 15) < 0) {
                this.dropItem(13787, holder.getEvent(), attacker);
            } else if ((random -= 15) < 0) {
                this.dropItem(13788, holder.getEvent(), attacker);
            }
        }
    }

    public static void useSkill(L2Character activeChar, Skill skill, L2Object[] targets) {
        L2Object obj = targets[0];
        if (obj instanceof L2BlockInstance) {
            ((L2BlockInstance)obj).blockCheckerSkill(activeChar.getActingPlayer(), skill);
        }
    }

    public final void blockCheckerSkill(L2PcInstance caster, Skill skill) {
        int arena = caster.getBlockCheckerArena();
        if (arena == -1) {
            return;
        }
        ArenaParticipantsHolder holder = HandysBlockCheckerManager.getInstance().getHolder(arena);
        if (holder == null) {
            return;
        }
        if (this.isInvul()) {
            caster.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.ATTACK_WAS_BLOCKED));
            return;
        }
        switch (skill.getId()) {
            case 5852: 
            case 5853: {
                Skill debuf;
                int team = holder.getPlayerTeam(caster);
                if (team == 1 && this._colorEffect != 83) {
                    this.changeColor(caster, holder, team, 83);
                } else if (team == 0 && this._colorEffect != 0) {
                    this.changeColor(caster, holder, team, 0);
                }
                if (this.getKnownSkill(5848) != null) {
                    debuf = SkillData.getInstance().getSkill(5849, 1);
                    debuf.applyEffects(this, caster);
                    if (caster.isAffectedBySkill(debuf.getId())) {
                        this.removeSkill(5848, false);
                    }
                }
                if (this.getKnownSkill(5850) == null) break;
                debuf = SkillData.getInstance().getSkill(5851, 1);
                debuf.applyEffects(this, caster);
                if (!caster.isAffectedBySkill(debuf.getId())) break;
                this.removeSkill(5850, false);
                break;
            }
            case 2616: {
                skill.applyEffects(caster, this);
                break;
            }
            case 2617: {
                if (this.getKnownSkill(5848) != null || this.getKnownSkill(5850) != null) break;
                Skill s = SkillData.getInstance().getSkill(Rnd.nextBoolean() ? 5848 : 5850, 1);
                this.addSkill(s);
            }
        }
    }

    public void setRed() {
        this._colorEffect = 83;
    }

    public void setBlue() {
        this._colorEffect = 0;
    }

    @Override
    public int getColorEffect() {
        return this._colorEffect;
    }

    @Override
    public boolean isAutoAttackable(L2Character attacker) {
        if (attacker instanceof L2PcInstance) {
            return attacker.getActingPlayer() != null && attacker.getActingPlayer().getBlockCheckerArena() != -1;
        }
        return true;
    }

    @Override
    public boolean doDie(L2Character killer) {
        return false;
    }

    @Override
    public void onAction(L2PcInstance player, boolean interact) {
        if (!this.canTarget(player)) {
            return;
        }
        player.setLastFolkNPC(this);
        if (player.getTarget() != this) {
            player.setTarget(this);
            this.getAI();
        } else if (interact) {
            player.sendPacket(ActionFailed.STATIC_PACKET);
        }
    }

    private void increaseTeamPointsAndSend(L2PcInstance player, int team, BlockCheckerEngine eng) {
        eng.increasePlayerPoints(player, team);
        int timeLeft = (int)((eng.getStarterTime() - System.currentTimeMillis()) / 1000L);
        ExCubeGameChangePoints changePoints = new ExCubeGameChangePoints(timeLeft, eng.getBluePoints(), eng.getRedPoints());
        ExCubeGameExtendedChangePoints secretPoints = new ExCubeGameExtendedChangePoints(timeLeft, eng.getBluePoints(), eng.getRedPoints(), team, player, eng.getPlayerPoints(player, team));
        eng.getHolder().broadCastPacketToTeam(changePoints);
        eng.getHolder().broadCastPacketToTeam(secretPoints);
    }

    private void dropItem(int id, BlockCheckerEngine eng, L2PcInstance player) {
        L2ItemInstance drop = ItemTable.getInstance().createItem("Loot", id, 1L, player, this);
        int x = this.getX() + Rnd.get(50);
        int y = this.getY() + Rnd.get(50);
        int z = this.getZ();
        drop.dropMe(this, x, y, z);
        eng.addNewDrop(drop);
    }
}

