/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.Config;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.ai.CtrlEvent;
import com.l2jserver.gameserver.datatables.SkillData;
import com.l2jserver.gameserver.instancemanager.DuelManager;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Party;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Playable;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.tasks.cubics.CubicAction;
import com.l2jserver.gameserver.model.actor.tasks.cubics.CubicDisappear;
import com.l2jserver.gameserver.model.actor.tasks.cubics.CubicHeal;
import com.l2jserver.gameserver.model.effects.L2EffectType;
import com.l2jserver.gameserver.model.entity.TvTEvent;
import com.l2jserver.gameserver.model.entity.TvTEventTeam;
import com.l2jserver.gameserver.model.interfaces.IIdentifiable;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.model.stats.Formulas;
import com.l2jserver.gameserver.model.stats.Stats;
import com.l2jserver.gameserver.model.zone.ZoneId;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.util.Rnd;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class L2CubicInstance
implements IIdentifiable {
    private static final Logger _log = Logger.getLogger(L2CubicInstance.class.getName());
    public static final int STORM_CUBIC = 1;
    public static final int VAMPIRIC_CUBIC = 2;
    public static final int LIFE_CUBIC = 3;
    public static final int VIPER_CUBIC = 4;
    public static final int POLTERGEIST_CUBIC = 5;
    public static final int BINDING_CUBIC = 6;
    public static final int AQUA_CUBIC = 7;
    public static final int SPARK_CUBIC = 8;
    public static final int ATTRACT_CUBIC = 9;
    public static final int SMART_CUBIC_EVATEMPLAR = 10;
    public static final int SMART_CUBIC_SHILLIENTEMPLAR = 11;
    public static final int SMART_CUBIC_ARCANALORD = 12;
    public static final int SMART_CUBIC_ELEMENTALMASTER = 13;
    public static final int SMART_CUBIC_SPECTRALMASTER = 14;
    public static final int MAX_MAGIC_RANGE = 900;
    public static final int SKILL_CUBIC_HEAL = 4051;
    public static final int SKILL_CUBIC_CURE = 5579;
    private final L2PcInstance _owner;
    private L2Character _target;
    private final int _cubicId;
    private final int _cubicPower;
    private final int _cubicDuration;
    private final int _cubicDelay;
    private final int _cubicSkillChance;
    private final int _cubicMaxCount;
    private boolean _active;
    private final boolean _givenByOther;
    private final List<Skill> _skills = new ArrayList<Skill>();
    private Future<?> _disappearTask;
    private Future<?> _actionTask;

    public L2CubicInstance(L2PcInstance owner, int cubicId, int level, int cubicPower, int cubicDelay, int cubicSkillChance, int cubicMaxCount, int cubicDuration, boolean givenByOther) {
        this._owner = owner;
        this._cubicId = cubicId;
        this._cubicPower = cubicPower;
        this._cubicDuration = cubicDuration * 1000;
        this._cubicDelay = cubicDelay * 1000;
        this._cubicSkillChance = cubicSkillChance;
        this._cubicMaxCount = cubicMaxCount;
        this._active = false;
        this._givenByOther = givenByOther;
        switch (this._cubicId) {
            case 1: {
                this._skills.add(SkillData.getInstance().getSkill(4049, level));
                break;
            }
            case 2: {
                this._skills.add(SkillData.getInstance().getSkill(4050, level));
                break;
            }
            case 3: {
                this._skills.add(SkillData.getInstance().getSkill(4051, level));
                this.doAction();
                break;
            }
            case 4: {
                this._skills.add(SkillData.getInstance().getSkill(4052, level));
                break;
            }
            case 5: {
                this._skills.add(SkillData.getInstance().getSkill(4053, level));
                this._skills.add(SkillData.getInstance().getSkill(4054, level));
                this._skills.add(SkillData.getInstance().getSkill(4055, level));
                break;
            }
            case 6: {
                this._skills.add(SkillData.getInstance().getSkill(4164, level));
                break;
            }
            case 7: {
                this._skills.add(SkillData.getInstance().getSkill(4165, level));
                break;
            }
            case 8: {
                this._skills.add(SkillData.getInstance().getSkill(4166, level));
                break;
            }
            case 9: {
                this._skills.add(SkillData.getInstance().getSkill(5115, level));
                this._skills.add(SkillData.getInstance().getSkill(5116, level));
                break;
            }
            case 12: {
                this._skills.add(SkillData.getInstance().getSkill(4051, 7));
                this._skills.add(SkillData.getInstance().getSkill(4165, 9));
                break;
            }
            case 13: {
                this._skills.add(SkillData.getInstance().getSkill(4049, 8));
                this._skills.add(SkillData.getInstance().getSkill(4166, 9));
                break;
            }
            case 14: {
                this._skills.add(SkillData.getInstance().getSkill(4049, 8));
                this._skills.add(SkillData.getInstance().getSkill(4052, 6));
                break;
            }
            case 10: {
                this._skills.add(SkillData.getInstance().getSkill(4053, 8));
                this._skills.add(SkillData.getInstance().getSkill(4165, 9));
                break;
            }
            case 11: {
                this._skills.add(SkillData.getInstance().getSkill(4049, 8));
                this._skills.add(SkillData.getInstance().getSkill(5115, 4));
            }
        }
        this._disappearTask = ThreadPoolManager.getInstance().scheduleGeneral(new CubicDisappear(this), this._cubicDuration);
    }

    public synchronized void doAction() {
        if (this._active) {
            return;
        }
        this._active = true;
        switch (this._cubicId) {
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                this._actionTask = ThreadPoolManager.getInstance().scheduleEffectAtFixedRate(new CubicAction(this, this._cubicSkillChance), 0L, this._cubicDelay);
                break;
            }
            case 3: {
                this._actionTask = ThreadPoolManager.getInstance().scheduleEffectAtFixedRate(new CubicHeal(this), 0L, this._cubicDelay);
            }
        }
    }

    @Override
    public int getId() {
        return this._cubicId;
    }

    public L2PcInstance getOwner() {
        return this._owner;
    }

    public int getCubicPower() {
        return this._cubicPower;
    }

    public L2Character getTarget() {
        return this._target;
    }

    public void setTarget(L2Character target) {
        this._target = target;
    }

    public List<Skill> getSkills() {
        return this._skills;
    }

    public int getCubicMaxCount() {
        return this._cubicMaxCount;
    }

    public void stopAction() {
        this._target = null;
        if (this._actionTask != null) {
            this._actionTask.cancel(true);
            this._actionTask = null;
        }
        this._active = false;
    }

    public void cancelDisappear() {
        if (this._disappearTask != null) {
            this._disappearTask.cancel(true);
            this._disappearTask = null;
        }
    }

    public void getCubicTarget() {
        try {
            this._target = null;
            L2Object ownerTarget = this._owner.getTarget();
            if (ownerTarget == null) {
                return;
            }
            if (TvTEvent.isStarted() && TvTEvent.isPlayerParticipant(this._owner.getObjectId())) {
                L2PcInstance target;
                TvTEventTeam enemyTeam = TvTEvent.getParticipantEnemyTeam(this._owner.getObjectId());
                if (ownerTarget.getActingPlayer() != null && enemyTeam.containsPlayer((target = ownerTarget.getActingPlayer()).getObjectId()) && !target.isDead()) {
                    this._target = (L2Character)ownerTarget;
                }
                return;
            }
            if (this._owner.isInDuel()) {
                L2PcInstance PlayerA = DuelManager.getInstance().getDuel(this._owner.getDuelId()).getPlayerA();
                L2PcInstance PlayerB = DuelManager.getInstance().getDuel(this._owner.getDuelId()).getPlayerB();
                if (DuelManager.getInstance().getDuel(this._owner.getDuelId()).isPartyDuel()) {
                    L2Party partyA = PlayerA.getParty();
                    L2Party partyB = PlayerB.getParty();
                    L2Party partyEnemy = null;
                    if (partyA != null) {
                        if (partyA.getMembers().contains(this._owner)) {
                            if (partyB != null) {
                                partyEnemy = partyB;
                            } else {
                                this._target = PlayerB;
                            }
                        } else {
                            partyEnemy = partyA;
                        }
                    } else if (PlayerA == this._owner) {
                        if (partyB != null) {
                            partyEnemy = partyB;
                        } else {
                            this._target = PlayerB;
                        }
                    } else {
                        this._target = PlayerA;
                    }
                    if ((this._target == PlayerA || this._target == PlayerB) && this._target == ownerTarget) {
                        return;
                    }
                    if (partyEnemy != null) {
                        if (partyEnemy.getMembers().contains(ownerTarget)) {
                            this._target = (L2Character)ownerTarget;
                        }
                        return;
                    }
                }
                if (PlayerA != this._owner && ownerTarget == PlayerA) {
                    this._target = PlayerA;
                    return;
                }
                if (PlayerB != this._owner && ownerTarget == PlayerB) {
                    this._target = PlayerB;
                    return;
                }
                this._target = null;
                return;
            }
            if (this._owner.isInOlympiadMode()) {
                L2PcInstance targetPlayer;
                if (this._owner.isOlympiadStart() && ownerTarget instanceof L2Playable && (targetPlayer = ownerTarget.getActingPlayer()) != null && targetPlayer.getOlympiadGameId() == this._owner.getOlympiadGameId() && targetPlayer.getOlympiadSide() != this._owner.getOlympiadSide()) {
                    this._target = (L2Character)ownerTarget;
                }
                return;
            }
            if (ownerTarget instanceof L2Character && ownerTarget != this._owner.getSummon() && ownerTarget != this._owner) {
                if (ownerTarget instanceof L2Attackable) {
                    if (((L2Attackable)ownerTarget).getAggroList().get(this._owner) != null && !((L2Attackable)ownerTarget).isDead()) {
                        this._target = (L2Character)ownerTarget;
                        return;
                    }
                    if (this._owner.hasSummon() && ((L2Attackable)ownerTarget).getAggroList().get(this._owner.getSummon()) != null && !((L2Attackable)ownerTarget).isDead()) {
                        this._target = (L2Character)ownerTarget;
                        return;
                    }
                }
                L2PcInstance enemy = null;
                if (this._owner.getPvpFlag() > 0 && !this._owner.isInsideZone(ZoneId.PEACE) || this._owner.isInsideZone(ZoneId.PVP)) {
                    if (!((L2Character)ownerTarget).isDead()) {
                        enemy = ownerTarget.getActingPlayer();
                    }
                    if (enemy != null) {
                        boolean targetIt = true;
                        if (this._owner.getParty() != null) {
                            if (this._owner.getParty().getMembers().contains(enemy)) {
                                targetIt = false;
                            } else if (this._owner.getParty().getCommandChannel() != null && this._owner.getParty().getCommandChannel().getMembers().contains(enemy)) {
                                targetIt = false;
                            }
                        }
                        if (this._owner.getClan() != null && !this._owner.isInsideZone(ZoneId.PVP)) {
                            if (this._owner.getClan().isMember(enemy.getObjectId())) {
                                targetIt = false;
                            }
                            if (this._owner.getAllyId() > 0 && enemy.getAllyId() > 0 && this._owner.getAllyId() == enemy.getAllyId()) {
                                targetIt = false;
                            }
                        }
                        if (enemy.getPvpFlag() == 0 && !enemy.isInsideZone(ZoneId.PVP)) {
                            targetIt = false;
                        }
                        if (enemy.isInsideZone(ZoneId.PEACE)) {
                            targetIt = false;
                        }
                        if (this._owner.getSiegeState() > 0 && this._owner.getSiegeState() == enemy.getSiegeState()) {
                            targetIt = false;
                        }
                        if (!enemy.isVisible()) {
                            targetIt = false;
                        }
                        if (targetIt) {
                            this._target = enemy;
                            return;
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "", e);
        }
    }

    public void useCubicContinuous(Skill skill, L2Object[] targets) {
        for (L2Character target : (L2Character[])targets) {
            byte shld;
            boolean acted;
            if (target == null || target.isDead()) continue;
            if (skill.isBad() && !(acted = Formulas.calcCubicSkillSuccess(this, target, skill, shld = Formulas.calcShldUse(this.getOwner(), target, skill)))) {
                this.getOwner().sendPacket(SystemMessageId.ATTACK_FAILED);
                continue;
            }
            skill.applyEffects(this.getOwner(), this, target, false, false, true, 0);
            if (!target.isPlayer() || !target.getActingPlayer().isInDuel() || !skill.isBad() || this.getOwner().getDuelId() != target.getActingPlayer().getDuelId()) continue;
            DuelManager.getInstance().onBuff(target.getActingPlayer(), skill);
        }
    }

    public void useCubicMdam(L2CubicInstance activeCubic, Skill skill, L2Object[] targets) {
        for (L2Character target : (L2Character[])targets) {
            if (target == null) continue;
            if (target.isAlikeDead()) {
                if (!target.isPlayer()) continue;
                target.stopFakeDeath(true);
            }
            boolean mcrit = Formulas.calcMCrit(activeCubic.getOwner().getMCriticalHit(target, skill));
            byte shld = Formulas.calcShldUse(activeCubic.getOwner(), target, skill);
            int damage = (int)Formulas.calcMagicDam(activeCubic, target, skill, mcrit, shld);
            if (Config.DEBUG) {
                _log.info("L2SkillMdam: useCubicSkill() -> damage = " + damage);
            }
            if (damage <= 0) continue;
            if (!target.isRaid() && Formulas.calcAtkBreak(target, damage)) {
                target.breakAttack();
                target.breakCast();
            }
            if (target.getStat().calcStat(Stats.VENGEANCE_SKILL_MAGIC_DAMAGE, 0.0, target, skill) > (double)Rnd.get(100)) {
                damage = 0;
                continue;
            }
            activeCubic.getOwner().sendDamageMessage(target, damage, mcrit, false, false);
            target.reduceCurrentHp(damage, activeCubic.getOwner(), skill);
        }
    }

    public void useCubicDrain(L2CubicInstance activeCubic, Skill skill, L2Object[] targets) {
        if (Config.DEBUG) {
            _log.info("L2SkillDrain: useCubicSkill()");
        }
        for (L2Character target : (L2Character[])targets) {
            if (target.isAlikeDead()) continue;
            boolean mcrit = Formulas.calcMCrit(activeCubic.getOwner().getMCriticalHit(target, skill));
            byte shld = Formulas.calcShldUse(activeCubic.getOwner(), target, skill);
            int damage = (int)Formulas.calcMagicDam(activeCubic, target, skill, mcrit, shld);
            if (Config.DEBUG) {
                _log.info("L2SkillDrain: useCubicSkill() -> damage = " + damage);
            }
            double hpAdd = 0.4 * (double)damage;
            L2PcInstance owner = activeCubic.getOwner();
            double hp = owner.getCurrentHp() + hpAdd > (double)owner.getMaxHp() ? (double)owner.getMaxHp() : owner.getCurrentHp() + hpAdd;
            owner.setCurrentHp(hp);
            if (damage <= 0 || target.isDead()) continue;
            target.reduceCurrentHp(damage, activeCubic.getOwner(), skill);
            if (!target.isRaid() && Formulas.calcAtkBreak(target, damage)) {
                target.breakAttack();
                target.breakCast();
            }
            owner.sendDamageMessage(target, damage, mcrit, false, false);
        }
    }

    public void useCubicDisabler(Skill skill, L2Object[] targets) {
        if (Config.DEBUG) {
            _log.info("Disablers: useCubicSkill()");
        }
        for (L2Character target : (L2Character[])targets) {
            if (target == null || target.isDead()) continue;
            byte shld = Formulas.calcShldUse(this.getOwner(), target, skill);
            if (skill.hasEffectType(L2EffectType.STUN, L2EffectType.PARALYZE, L2EffectType.ROOT)) {
                if (Formulas.calcCubicSkillSuccess(this, target, skill, shld)) {
                    skill.applyEffects(this.getOwner(), this, target, false, false, true, 0);
                    if (target.isPlayer() && target.getActingPlayer().isInDuel() && skill.isBad() && this.getOwner().getDuelId() == target.getActingPlayer().getDuelId()) {
                        DuelManager.getInstance().onBuff(target.getActingPlayer(), skill);
                    }
                    if (Config.DEBUG) {
                        _log.info("Disablers: useCubicSkill() -> success");
                    }
                } else if (Config.DEBUG) {
                    _log.info("Disablers: useCubicSkill() -> failed");
                }
            }
            if (!skill.hasEffectType(L2EffectType.AGGRESSION)) continue;
            if (Formulas.calcCubicSkillSuccess(this, target, skill, shld)) {
                if (target.isAttackable()) {
                    target.getAI().notifyEvent(CtrlEvent.EVT_AGGRESSION, this.getOwner(), (int)(150.0 * skill.getPower() / (double)(target.getLevel() + 7)));
                }
                skill.applyEffects(this.getOwner(), this, target, false, false, true, 0);
                if (!Config.DEBUG) continue;
                _log.info("Disablers: useCubicSkill() -> success");
                continue;
            }
            if (!Config.DEBUG) continue;
            _log.info("Disablers: useCubicSkill() -> failed");
        }
    }

    public static boolean isInCubicRange(L2Character owner, L2Character target) {
        int z;
        int y;
        if (owner == null || target == null) {
            return false;
        }
        int range = 900;
        int x = owner.getX() - target.getX();
        return x * x + (y = owner.getY() - target.getY()) * y + (z = owner.getZ() - target.getZ()) * z <= range * range;
    }

    public void cubicTargetForHeal() {
        L2Character target = null;
        double percentleft = 100.0;
        L2Party party = this._owner.getParty();
        if (this._owner.isInDuel() && !DuelManager.getInstance().getDuel(this._owner.getDuelId()).isPartyDuel()) {
            party = null;
        }
        if (party != null && !this._owner.isInOlympiadMode()) {
            List<L2PcInstance> partyList = party.getMembers();
            for (L2Character l2Character : partyList) {
                if (!l2Character.isDead() && L2CubicInstance.isInCubicRange(this._owner, l2Character) && l2Character.getCurrentHp() < (double)l2Character.getMaxHp() && percentleft > l2Character.getCurrentHp() / (double)l2Character.getMaxHp()) {
                    percentleft = l2Character.getCurrentHp() / (double)l2Character.getMaxHp();
                    target = l2Character;
                }
                if (l2Character.getSummon() == null || l2Character.getSummon().isDead() || !L2CubicInstance.isInCubicRange(this._owner, l2Character.getSummon()) || !(l2Character.getSummon().getCurrentHp() < (double)l2Character.getSummon().getMaxHp()) || !(percentleft > l2Character.getSummon().getCurrentHp() / (double)l2Character.getSummon().getMaxHp())) continue;
                percentleft = l2Character.getSummon().getCurrentHp() / (double)l2Character.getSummon().getMaxHp();
                target = l2Character.getSummon();
            }
        } else {
            if (this._owner.getCurrentHp() < (double)this._owner.getMaxHp()) {
                percentleft = this._owner.getCurrentHp() / (double)this._owner.getMaxHp();
                target = this._owner;
            }
            if (this._owner.hasSummon() && !this._owner.getSummon().isDead() && this._owner.getSummon().getCurrentHp() < (double)this._owner.getSummon().getMaxHp() && percentleft > this._owner.getSummon().getCurrentHp() / (double)this._owner.getSummon().getMaxHp() && L2CubicInstance.isInCubicRange(this._owner, this._owner.getSummon())) {
                target = this._owner.getSummon();
            }
        }
        this._target = target;
    }

    public boolean givenByOther() {
        return this._givenByOther;
    }
}

