/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.SevenSigns;
import com.l2jserver.gameserver.datatables.TeleportLocationTable;
import com.l2jserver.gameserver.enums.InstanceType;
import com.l2jserver.gameserver.model.L2TeleportLocation;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import java.util.StringTokenizer;

public class L2DungeonGatekeeperInstance
extends L2Npc {
    public L2DungeonGatekeeperInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
        this.setInstanceType(InstanceType.L2DungeonGatekeeperInstance);
    }

    @Override
    public void onBypassFeedback(L2PcInstance player, String command) {
        player.sendPacket(ActionFailed.STATIC_PACKET);
        StringTokenizer st = new StringTokenizer(command, " ");
        String actualCommand = st.nextToken();
        String filename = "data/html/seven_signs/";
        int sealAvariceOwner = SevenSigns.getInstance().getSealOwner(1);
        int sealGnosisOwner = SevenSigns.getInstance().getSealOwner(2);
        int playerCabal = SevenSigns.getInstance().getPlayerCabal(player.getObjectId());
        boolean isSealValidationPeriod = SevenSigns.getInstance().isSealValidationPeriod();
        int compWinner = SevenSigns.getInstance().getCabalHighestScore();
        if (actualCommand.startsWith("necro")) {
            boolean canPort = true;
            if (isSealValidationPeriod) {
                if (compWinner == 2 && (playerCabal != 2 || sealAvariceOwner != 2)) {
                    player.sendPacket(SystemMessageId.CAN_BE_USED_BY_DAWN);
                    canPort = false;
                } else if (compWinner == 1 && (playerCabal != 1 || sealAvariceOwner != 1)) {
                    player.sendPacket(SystemMessageId.CAN_BE_USED_BY_DUSK);
                    canPort = false;
                } else if (compWinner == 0 && playerCabal != 0) {
                    canPort = true;
                } else if (playerCabal == 0) {
                    canPort = false;
                }
            } else if (playerCabal == 0) {
                canPort = false;
            }
            if (!canPort) {
                NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                filename = filename + "necro_no.htm";
                html.setFile(player.getHtmlPrefix(), filename);
                player.sendPacket(html);
            } else {
                this.doTeleport(player, Integer.parseInt(st.nextToken()));
                player.setIsIn7sDungeon(true);
            }
        } else if (actualCommand.startsWith("cata")) {
            boolean canPort = true;
            if (isSealValidationPeriod) {
                if (compWinner == 2 && (playerCabal != 2 || sealGnosisOwner != 2)) {
                    player.sendPacket(SystemMessageId.CAN_BE_USED_BY_DAWN);
                    canPort = false;
                } else if (compWinner == 1 && (playerCabal != 1 || sealGnosisOwner != 1)) {
                    player.sendPacket(SystemMessageId.CAN_BE_USED_BY_DUSK);
                    canPort = false;
                } else if (compWinner == 0 && playerCabal != 0) {
                    canPort = true;
                } else if (playerCabal == 0) {
                    canPort = false;
                }
            } else if (playerCabal == 0) {
                canPort = false;
            }
            if (!canPort) {
                NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                filename = filename + "cata_no.htm";
                html.setFile(player.getHtmlPrefix(), filename);
                player.sendPacket(html);
            } else {
                this.doTeleport(player, Integer.parseInt(st.nextToken()));
                player.setIsIn7sDungeon(true);
            }
        } else if (actualCommand.startsWith("exit")) {
            this.doTeleport(player, Integer.parseInt(st.nextToken()));
            player.setIsIn7sDungeon(false);
        } else if (actualCommand.startsWith("goto")) {
            this.doTeleport(player, Integer.parseInt(st.nextToken()));
        } else {
            super.onBypassFeedback(player, command);
        }
    }

    private void doTeleport(L2PcInstance player, int val) {
        L2TeleportLocation list = TeleportLocationTable.getInstance().getTemplate(val);
        if (list != null) {
            if (player.isAlikeDead()) {
                return;
            }
            player.teleToLocation(list.getLocX(), list.getLocY(), list.getLocZ(), true);
        } else {
            _log.warning("No teleport destination with id:" + val);
        }
        player.sendPacket(ActionFailed.STATIC_PACKET);
    }

    @Override
    public String getHtmlPath(int npcId, int val) {
        return this.getHtmlPath("data/html/teleporter/", npcId, val);
    }
}

