/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.enums.InstanceType;
import com.l2jserver.gameserver.enums.QuestEventType;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2GuardInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.tasks.attackable.OnKillNotifyTask;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.model.skills.Skill;
import java.util.List;

public final class L2QuestGuardInstance
extends L2GuardInstance {
    private boolean _isAutoAttackable = true;
    private boolean _isPassive = false;

    public L2QuestGuardInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
        this.setInstanceType(InstanceType.L2QuestGuardInstance);
    }

    @Override
    public void addDamage(L2Character attacker, int damage, Skill skill) {
        List<Quest> eventQuests;
        super.addDamage(attacker, damage, skill);
        if (attacker instanceof L2Attackable && (eventQuests = this.getTemplate().getEventQuests(QuestEventType.ON_ATTACK)) != null) {
            for (Quest quest : eventQuests) {
                quest.notifyAttack(this, null, damage, false, skill);
            }
        }
    }

    @Override
    public boolean doDie(L2Character killer) {
        List<Quest> eventQuests;
        if (!super.doDie(killer)) {
            return false;
        }
        if (killer instanceof L2Attackable && (eventQuests = this.getTemplate().getEventQuests(QuestEventType.ON_KILL)) != null) {
            for (Quest quest : eventQuests) {
                ThreadPoolManager.getInstance().scheduleEffect(new OnKillNotifyTask(this, quest, null, false), this._onKillDelay);
            }
        }
        return true;
    }

    @Override
    public void addDamageHate(L2Character attacker, int damage, int aggro) {
        if (!this._isPassive && !(attacker instanceof L2PcInstance)) {
            super.addDamageHate(attacker, damage, aggro);
        }
    }

    public void setPassive(boolean state) {
        this._isPassive = state;
    }

    @Override
    public boolean isAutoAttackable(L2Character attacker) {
        return this._isAutoAttackable && !(attacker instanceof L2PcInstance);
    }

    @Override
    public void setAutoAttackable(boolean state) {
        this._isAutoAttackable = state;
    }

    public boolean isPassive() {
        return this._isPassive;
    }
}

