/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.conditions;

import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.instancemanager.FortManager;
import com.l2jserver.gameserver.instancemanager.TerritoryWarManager;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.conditions.Condition;
import com.l2jserver.gameserver.model.entity.Castle;
import com.l2jserver.gameserver.model.entity.Fort;
import com.l2jserver.gameserver.model.stats.Env;

public final class ConditionSiegeZone
extends Condition {
    public static final int COND_NOT_ZONE = 1;
    public static final int COND_CAST_ATTACK = 2;
    public static final int COND_CAST_DEFEND = 4;
    public static final int COND_CAST_NEUTRAL = 8;
    public static final int COND_FORT_ATTACK = 16;
    public static final int COND_FORT_DEFEND = 32;
    public static final int COND_FORT_NEUTRAL = 64;
    public static final int COND_TW_CHANNEL = 128;
    public static final int COND_TW_PROGRESS = 256;
    private final int _value;
    private final boolean _self;

    public ConditionSiegeZone(int value, boolean self) {
        this._value = value;
        this._self = self;
    }

    @Override
    public boolean testImpl(Env env) {
        L2Character target = this._self ? env.getCharacter() : env.getTarget();
        Castle castle = CastleManager.getInstance().getCastle(target);
        Fort fort = FortManager.getInstance().getFort(target);
        if ((this._value & 0x100) != 0 && !TerritoryWarManager.getInstance().isTWInProgress()) {
            return false;
        }
        if ((this._value & 0x80) != 0 && !TerritoryWarManager.getInstance().isTWChannelOpen()) {
            return false;
        }
        if (castle == null && fort == null) {
            return (this._value & 1) != 0;
        }
        if (castle != null) {
            return ConditionSiegeZone.checkIfOk(target, castle, this._value);
        }
        return ConditionSiegeZone.checkIfOk(target, fort, this._value);
    }

    public static boolean checkIfOk(L2Character activeChar, Castle castle, int value) {
        if (activeChar == null || !(activeChar instanceof L2PcInstance)) {
            return false;
        }
        L2PcInstance player = (L2PcInstance)activeChar;
        if (castle == null || castle.getResidenceId() <= 0) {
            if ((value & 1) != 0) {
                return true;
            }
        } else if (!castle.getZone().isActive()) {
            if ((value & 1) != 0) {
                return true;
            }
        } else {
            if ((value & 2) != 0 && player.isRegisteredOnThisSiegeField(castle.getResidenceId()) && player.getSiegeState() == 1) {
                return true;
            }
            if ((value & 4) != 0 && player.isRegisteredOnThisSiegeField(castle.getResidenceId()) && player.getSiegeState() == 2) {
                return true;
            }
            if ((value & 8) != 0 && player.getSiegeState() == 0) {
                return true;
            }
        }
        return false;
    }

    public static boolean checkIfOk(L2Character activeChar, Fort fort, int value) {
        if (activeChar == null || !(activeChar instanceof L2PcInstance)) {
            return false;
        }
        L2PcInstance player = (L2PcInstance)activeChar;
        if (fort == null || fort.getResidenceId() <= 0) {
            if ((value & 1) != 0) {
                return true;
            }
        } else if (!fort.getZone().isActive()) {
            if ((value & 1) != 0) {
                return true;
            }
        } else {
            if ((value & 0x10) != 0 && player.isRegisteredOnThisSiegeField(fort.getResidenceId()) && player.getSiegeState() == 1) {
                return true;
            }
            if ((value & 0x20) != 0 && player.isRegisteredOnThisSiegeField(fort.getResidenceId()) && player.getSiegeState() == 2) {
                return true;
            }
            if ((value & 0x40) != 0 && player.getSiegeState() == 0) {
                return true;
            }
        }
        return false;
    }
}

