/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.conditions;

import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.conditions.Condition;
import com.l2jserver.gameserver.model.stats.Env;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;

public class ConditionTargetMyPartyExceptMe
extends Condition {
    private final boolean _val;

    public ConditionTargetMyPartyExceptMe(boolean val) {
        this._val = val;
    }

    @Override
    public boolean testImpl(Env env) {
        boolean isPartyMember = true;
        L2PcInstance player = env.getPlayer();
        L2Character target = env.getTarget();
        if (player == null || target == null || !target.isPlayer()) {
            isPartyMember = false;
        } else if (player == target) {
            player.sendPacket(SystemMessageId.CANNOT_USE_ON_YOURSELF);
            isPartyMember = false;
        } else if (!player.isInParty() || !player.getParty().equals(target.getParty())) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_CANNOT_BE_USED);
            sm.addSkillName(env.getSkill());
            player.sendPacket(sm);
            isPartyMember = false;
        }
        return this._val == isPartyMember;
    }
}

