/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.drops;

import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2RaidBossInstance;
import com.l2jserver.gameserver.model.drops.GeneralDropItem;
import com.l2jserver.gameserver.model.drops.IDropItem;
import com.l2jserver.gameserver.model.holders.ItemHolder;
import com.l2jserver.gameserver.util.UnmodifiableArrayList;
import com.l2jserver.util.Rnd;
import java.util.ArrayList;
import java.util.List;

public class GroupedGeneralDropItem
implements IDropItem {
    private final double _chance;
    private List<GeneralDropItem> _items;

    public GroupedGeneralDropItem(double chance) {
        this._chance = chance;
    }

    public double getChance() {
        return this._chance;
    }

    public double getChance(L2Character victim, L2Character killer) {
        return this.getChance();
    }

    public List<GeneralDropItem> getItems() {
        return this._items;
    }

    public void setItems(List<GeneralDropItem> items) {
        this._items = new UnmodifiableArrayList<GeneralDropItem>(items);
    }

    @Override
    public List<ItemHolder> calculateDrops(L2Character victim, L2Character killer) {
        double chanceModifier;
        int levelDifference = victim.getLevel() - killer.getLevel();
        if (victim instanceof L2RaidBossInstance) {
            chanceModifier = Math.max(0.0, Math.min(1.0, (double)levelDifference * 0.15 + 1.0));
        } else {
            double levelGapChanceToDrop;
            chanceModifier = 1.0;
            if (levelDifference >= -5) {
                levelGapChanceToDrop = 100.0;
            } else if (levelDifference >= -10) {
                levelGapChanceToDrop = levelDifference;
                levelGapChanceToDrop *= 18.0;
                levelGapChanceToDrop += 190.0;
            } else {
                levelGapChanceToDrop = 10.0;
            }
            if (levelGapChanceToDrop < Rnd.nextDouble() * 100.0) {
                return null;
            }
        }
        if (this.getChance(victim, killer) * chanceModifier > Rnd.nextDouble() * 100.0) {
            double random = Rnd.nextDouble() * 100.0;
            double totalChance = 0.0;
            for (GeneralDropItem item : this.getItems()) {
                if (!((totalChance += item.getChance()) > random)) continue;
                long amount = Rnd.get(item.getMin(victim, killer), item.getMax(victim, killer));
                ArrayList<ItemHolder> items = new ArrayList<ItemHolder>(1);
                items.add(new ItemHolder(item.getItemId(), amount));
                return items;
            }
        }
        return null;
    }
}

