/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.entity;

import com.l2jserver.Config;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.datatables.NpcData;
import com.l2jserver.gameserver.datatables.SkillData;
import com.l2jserver.gameserver.enums.Team;
import com.l2jserver.gameserver.instancemanager.HandysBlockCheckerManager;
import com.l2jserver.gameserver.model.ArenaParticipantsHolder;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.instance.L2BlockInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.gameserver.model.itemcontainer.PcInventory;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.model.zone.ZoneId;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.ExBasicActionList;
import com.l2jserver.gameserver.network.serverpackets.ExCubeGameChangePoints;
import com.l2jserver.gameserver.network.serverpackets.ExCubeGameCloseUI;
import com.l2jserver.gameserver.network.serverpackets.ExCubeGameEnd;
import com.l2jserver.gameserver.network.serverpackets.ExCubeGameExtendedChangePoints;
import com.l2jserver.gameserver.network.serverpackets.RelationChanged;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.util.Rnd;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastList;
import javolution.util.FastMap;

public final class BlockCheckerEngine {
    protected static final Logger _log = Logger.getLogger(BlockCheckerEngine.class.getName());
    protected ArenaParticipantsHolder _holder;
    protected FastMap<L2PcInstance, PlayerPoint> _redTeamPoints = new FastMap();
    protected FastMap<L2PcInstance, PlayerPoint> _blueTeamPoints = new FastMap();
    protected int _redPoints = 15;
    protected int _bluePoints = 15;
    protected int _arena = -1;
    protected FastList<L2Spawn> _spawns = new FastList();
    protected int _winnerTeam = -1;
    protected long _startedTime;
    protected static final int[][] _arenaCoordinates = new int[][]{{-58368, -62745, -57751, -62131, -58053, -62417}, {-58350, -63853, -57756, -63266, -58053, -63551}, {-57194, -63861, -56580, -63249, -56886, -63551}, {-57200, -62727, -56584, -62115, -56850, -62391}};
    private static final int _zCoord = -2405;
    protected FastList<L2ItemInstance> _drops = new FastList();
    public static final byte DEFAULT_ARENA = -1;
    protected boolean _isStarted = false;
    protected ScheduledFuture<?> _task;
    protected boolean _abnormalEnd = false;

    public BlockCheckerEngine(ArenaParticipantsHolder holder, int arena) {
        this._holder = holder;
        this._arena = arena;
    }

    public void updatePlayersOnStart(ArenaParticipantsHolder holder) {
        this._holder = holder;
    }

    public ArenaParticipantsHolder getHolder() {
        return this._holder;
    }

    public int getArena() {
        return this._arena;
    }

    public long getStarterTime() {
        return this._startedTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRedPoints() {
        BlockCheckerEngine blockCheckerEngine = this;
        synchronized (blockCheckerEngine) {
            return this._redPoints;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBluePoints() {
        BlockCheckerEngine blockCheckerEngine = this;
        synchronized (blockCheckerEngine) {
            return this._bluePoints;
        }
    }

    public int getPlayerPoints(L2PcInstance player, int team) {
        if (!this._redTeamPoints.containsKey((Object)player) && !this._blueTeamPoints.containsKey((Object)player)) {
            return 0;
        }
        if (team == 1) {
            return ((PlayerPoint)this._redTeamPoints.get((Object)player)).points;
        }
        return ((PlayerPoint)this._blueTeamPoints.get((Object)player)).points;
    }

    public synchronized void increasePlayerPoints(L2PcInstance player, int team) {
        if (player == null) {
            return;
        }
        if (team == 1) {
            ++((PlayerPoint)this._redTeamPoints.get((Object)player)).points;
            ++this._redPoints;
            --this._bluePoints;
        } else {
            ++((PlayerPoint)this._blueTeamPoints.get((Object)player)).points;
            ++this._bluePoints;
            --this._redPoints;
        }
    }

    public void addNewDrop(L2ItemInstance item) {
        if (item != null) {
            this._drops.add((Object)item);
        }
    }

    public boolean isStarted() {
        return this._isStarted;
    }

    protected void broadcastRelationChanged(L2PcInstance plr) {
        for (L2PcInstance p : this._holder.getAllPlayers()) {
            p.sendPacket(new RelationChanged(plr, plr.getRelation(p), plr.isAutoAttackable(p)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endEventAbnormally() {
        try {
            BlockCheckerEngine blockCheckerEngine = this;
            synchronized (blockCheckerEngine) {
                this._isStarted = false;
                if (this._task != null) {
                    this._task.cancel(true);
                }
                this._abnormalEnd = true;
                ThreadPoolManager.getInstance().executeTask(new EndEvent());
                if (Config.DEBUG) {
                    _log.config("Handys Block Checker Event at arena " + this._arena + " ended due lack of players!");
                }
            }
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Couldnt end Block Checker event at " + this._arena, e);
        }
    }

    protected class EndEvent
    implements Runnable {
        protected EndEvent() {
        }

        private void clearMe() {
            HandysBlockCheckerManager.getInstance().clearPaticipantQueueByArenaId(BlockCheckerEngine.this._arena);
            BlockCheckerEngine.this._holder.clearPlayers();
            BlockCheckerEngine.this._blueTeamPoints.clear();
            BlockCheckerEngine.this._redTeamPoints.clear();
            HandysBlockCheckerManager.getInstance().setArenaFree(BlockCheckerEngine.this._arena);
            for (L2Spawn spawn : BlockCheckerEngine.this._spawns) {
                spawn.stopRespawn();
                spawn.getLastSpawn().deleteMe();
            }
            BlockCheckerEngine.this._spawns.clear();
            for (L2ItemInstance item : BlockCheckerEngine.this._drops) {
                if (item == null || !item.isVisible() || item.getOwnerId() != 0) continue;
                item.decayMe();
                L2World.getInstance().removeObject(item);
            }
            BlockCheckerEngine.this._drops.clear();
        }

        private void rewardPlayers() {
            if (BlockCheckerEngine.this._redPoints > BlockCheckerEngine.this._bluePoints) {
                BlockCheckerEngine.this._winnerTeam = 1;
                this.rewardAsWinner(1);
                this.rewardAsLooser(0);
                BlockCheckerEngine.this._holder.broadCastPacketToTeam(SystemMessage.getSystemMessage(SystemMessageId.TEAM_C1_WON).addString("Red"));
            } else if (BlockCheckerEngine.this._bluePoints > BlockCheckerEngine.this._redPoints) {
                BlockCheckerEngine.this._winnerTeam = 0;
                this.rewardAsWinner(0);
                this.rewardAsLooser(1);
                BlockCheckerEngine.this._holder.broadCastPacketToTeam(SystemMessage.getSystemMessage(SystemMessageId.TEAM_C1_WON).addString("Blue"));
            } else {
                BlockCheckerEngine.this._winnerTeam = -1;
            }
        }

        private void rewardAsWinner(int team) {
            FastMap<L2PcInstance, PlayerPoint> tempPoints = team == 1 ? BlockCheckerEngine.this._redTeamPoints : BlockCheckerEngine.this._blueTeamPoints;
            for (Map.Entry points : tempPoints.entrySet()) {
                if (points.getKey() == null) continue;
                if (((PlayerPoint)points.getValue()).points >= 10) {
                    ((L2PcInstance)points.getKey()).addItem("Block Checker", 13067, 2L, (L2Object)points.getKey(), true);
                    continue;
                }
                tempPoints.remove(points.getKey());
            }
            int first = 0;
            int second = 0;
            L2PcInstance winner1 = null;
            L2PcInstance winner2 = null;
            for (Map.Entry entry : tempPoints.entrySet()) {
                L2PcInstance pc = (L2PcInstance)entry.getKey();
                int pcPoints = ((PlayerPoint)entry.getValue()).points;
                if (pcPoints > first) {
                    second = first;
                    winner2 = winner1;
                    first = pcPoints;
                    winner1 = pc;
                    continue;
                }
                if (pcPoints <= second) continue;
                second = pcPoints;
                winner2 = pc;
            }
            if (winner1 != null) {
                winner1.addItem("Block Checker", 13067, 8L, winner1, true);
            }
            if (winner2 != null) {
                winner2.addItem("Block Checker", 13067, 5L, winner2, true);
            }
        }

        private void rewardAsLooser(int team) {
            FastMap<L2PcInstance, PlayerPoint> tempPoints = team == 1 ? BlockCheckerEngine.this._redTeamPoints : BlockCheckerEngine.this._blueTeamPoints;
            for (Map.Entry entry : tempPoints.entrySet()) {
                L2PcInstance player = (L2PcInstance)entry.getKey();
                if (player == null || ((PlayerPoint)entry.getValue()).points < 10) continue;
                player.addItem("Block Checker", 13067, 2L, player, true);
            }
        }

        private void setPlayersBack() {
            ExCubeGameEnd end = new ExCubeGameEnd(BlockCheckerEngine.this._winnerTeam);
            for (L2PcInstance player : BlockCheckerEngine.this._holder.getAllPlayers()) {
                long count;
                if (player == null) continue;
                player.stopAllEffects();
                player.setTeam(Team.NONE);
                player.setBlockCheckerArena((byte)-1);
                PcInventory inv = player.getInventory();
                if (inv.getItemByItemId(13787) != null) {
                    count = inv.getInventoryItemCount(13787, 0);
                    inv.destroyItemByItemId("Handys Block Checker", 13787, count, player, player);
                }
                if (inv.getItemByItemId(13788) != null) {
                    count = inv.getInventoryItemCount(13788, 0);
                    inv.destroyItemByItemId("Handys Block Checker", 13788, count, player, player);
                }
                BlockCheckerEngine.this.broadcastRelationChanged(player);
                player.teleToLocation(-57478 + Rnd.get(-200, 200), -60367 + Rnd.get(-200, 200), -2370);
                player.setInsideZone(ZoneId.PVP, false);
                player.sendPacket(end);
                player.broadcastUserInfo();
            }
        }

        @Override
        public void run() {
            if (!BlockCheckerEngine.this._abnormalEnd) {
                this.rewardPlayers();
            }
            this.setPlayersBack();
            this.clearMe();
            BlockCheckerEngine.this._isStarted = false;
            BlockCheckerEngine.this._abnormalEnd = false;
        }
    }

    private class CarryingGirlUnspawn
    implements Runnable {
        private final L2Spawn _spawn;

        protected CarryingGirlUnspawn(L2Spawn spawn) {
            this._spawn = spawn;
        }

        @Override
        public void run() {
            if (this._spawn == null) {
                _log.warning("HBCE: Block Carrying Girl is null");
                return;
            }
            this._spawn.stopRespawn();
            this._spawn.getLastSpawn().deleteMe();
        }
    }

    private class SpawnRound
    implements Runnable {
        int _numOfBoxes;
        int _round;

        SpawnRound(int numberOfBoxes, int round) {
            this._numOfBoxes = numberOfBoxes;
            this._round = round;
        }

        @Override
        public void run() {
            if (!BlockCheckerEngine.this._isStarted) {
                return;
            }
            switch (this._round) {
                case 1: {
                    BlockCheckerEngine.this._task = ThreadPoolManager.getInstance().scheduleGeneral(new SpawnRound(20, 2), 60000L);
                    break;
                }
                case 2: {
                    BlockCheckerEngine.this._task = ThreadPoolManager.getInstance().scheduleGeneral(new SpawnRound(14, 3), 60000L);
                    break;
                }
                case 3: {
                    BlockCheckerEngine.this._task = ThreadPoolManager.getInstance().scheduleGeneral(new EndEvent(), 180000L);
                }
            }
            int random = 2;
            L2NpcTemplate template = NpcData.getInstance().getTemplate(18672);
            try {
                for (int i = 0; i < this._numOfBoxes; ++i) {
                    L2Spawn spawn = new L2Spawn(template);
                    spawn.setX(_arenaCoordinates[BlockCheckerEngine.this._arena][4] + Rnd.get(-400, 400));
                    spawn.setY(_arenaCoordinates[BlockCheckerEngine.this._arena][5] + Rnd.get(-400, 400));
                    spawn.setZ(-2405);
                    spawn.setAmount(1);
                    spawn.setHeading(1);
                    spawn.setRespawnDelay(1);
                    spawn.init();
                    L2BlockInstance block = (L2BlockInstance)spawn.getLastSpawn();
                    if (random % 2 == 0) {
                        block.setRed();
                    } else {
                        block.setBlue();
                    }
                    block.disableCoreAI(true);
                    BlockCheckerEngine.this._spawns.add((Object)spawn);
                    random = (byte)(random + 1);
                }
            }
            catch (Exception e) {
                _log.warning(this.getClass().getSimpleName() + ": " + e.getMessage());
            }
            if (this._round == 1 || this._round == 2) {
                L2NpcTemplate girl = NpcData.getInstance().getTemplate(18676);
                try {
                    L2Spawn girlSpawn = new L2Spawn(girl);
                    girlSpawn.setX(_arenaCoordinates[BlockCheckerEngine.this._arena][4] + Rnd.get(-400, 400));
                    girlSpawn.setY(_arenaCoordinates[BlockCheckerEngine.this._arena][5] + Rnd.get(-400, 400));
                    girlSpawn.setZ(-2405);
                    girlSpawn.setAmount(1);
                    girlSpawn.setHeading(1);
                    girlSpawn.setRespawnDelay(1);
                    girlSpawn.init();
                    ThreadPoolManager.getInstance().scheduleGeneral(new CarryingGirlUnspawn(girlSpawn), 9000L);
                }
                catch (Exception e) {
                    _log.warning("Couldnt Spawn Block Checker NPCs! Wrong instance type at npc table?");
                    _log.warning(this.getClass().getSimpleName() + ": " + e.getMessage());
                }
            }
            BlockCheckerEngine.this._redPoints += this._numOfBoxes / 2;
            BlockCheckerEngine.this._bluePoints += this._numOfBoxes / 2;
            int timeLeft = (int)((BlockCheckerEngine.this.getStarterTime() - System.currentTimeMillis()) / 1000L);
            ExCubeGameChangePoints changePoints = new ExCubeGameChangePoints(timeLeft, BlockCheckerEngine.this.getBluePoints(), BlockCheckerEngine.this.getRedPoints());
            BlockCheckerEngine.this.getHolder().broadCastPacketToTeam(changePoints);
        }
    }

    public class StartEvent
    implements Runnable {
        private final Skill _freeze;
        private final Skill _transformationRed;
        private final Skill _transformationBlue;
        private final ExCubeGameCloseUI _closeUserInterface = new ExCubeGameCloseUI();

        public StartEvent() {
            this._freeze = SkillData.getInstance().getSkill(6034, 1);
            this._transformationRed = SkillData.getInstance().getSkill(6035, 1);
            this._transformationBlue = SkillData.getInstance().getSkill(6036, 1);
        }

        private void setUpPlayers() {
            HandysBlockCheckerManager.getInstance().setArenaBeingUsed(BlockCheckerEngine.this._arena);
            BlockCheckerEngine.this._redPoints = BlockCheckerEngine.this._spawns.size() / 2;
            BlockCheckerEngine.this._bluePoints = BlockCheckerEngine.this._spawns.size() / 2;
            ExCubeGameChangePoints initialPoints = new ExCubeGameChangePoints(300, BlockCheckerEngine.this._bluePoints, BlockCheckerEngine.this._redPoints);
            for (L2PcInstance player : BlockCheckerEngine.this._holder.getAllPlayers()) {
                if (player == null) continue;
                int team = BlockCheckerEngine.this._holder.getRedPlayers().contains(player) ? 1 : 0;
                player.sendPacket(new ExCubeGameExtendedChangePoints(300, BlockCheckerEngine.this._bluePoints, BlockCheckerEngine.this._redPoints, team, player, 0));
                player.sendPacket(ActionFailed.STATIC_PACKET);
                int tc = BlockCheckerEngine.this._holder.getPlayerTeam(player) * 2;
                int x = _arenaCoordinates[BlockCheckerEngine.this._arena][tc];
                int y = _arenaCoordinates[BlockCheckerEngine.this._arena][tc + 1];
                player.teleToLocation(x + Rnd.get(-100, 100), y + Rnd.get(-100, 100), -2405);
                if (team == 1) {
                    BlockCheckerEngine.this._redTeamPoints.put((Object)player, (Object)new PlayerPoint());
                    player.setTeam(Team.RED);
                } else {
                    BlockCheckerEngine.this._blueTeamPoints.put((Object)player, (Object)new PlayerPoint());
                    player.setTeam(Team.BLUE);
                }
                player.stopAllEffects();
                if (player.hasSummon()) {
                    player.getSummon().unSummon(player);
                }
                if (player.isSitting()) {
                    player.standUp();
                }
                if (player.isTransformed() || player.isInStance()) {
                    player.untransform();
                }
                this._freeze.applyEffects(player, player);
                if (team == 1) {
                    this._transformationRed.applyEffects(player, player);
                } else {
                    this._transformationBlue.applyEffects(player, player);
                }
                player.setBlockCheckerArena((byte)BlockCheckerEngine.this._arena);
                player.setInsideZone(ZoneId.PVP, true);
                player.sendPacket(initialPoints);
                player.sendPacket(this._closeUserInterface);
                player.sendPacket(ExBasicActionList.STATIC_PACKET);
                BlockCheckerEngine.this.broadcastRelationChanged(player);
            }
            for (L2PcInstance player : BlockCheckerEngine.this._holder.getAllPlayers()) {
                if (player.getEffectList().getBuffInfoBySkillId(6035) != null || player.getEffectList().getBuffInfoBySkillId(6036) != null) continue;
                HandysBlockCheckerManager.getInstance().onDisconnect(player);
            }
        }

        @Override
        public void run() {
            if (BlockCheckerEngine.this._arena == -1) {
                _log.severe("Couldnt set up the arena Id for the Block Checker event, cancelling event...");
                return;
            }
            BlockCheckerEngine.this._isStarted = true;
            BlockCheckerEngine.this._startedTime = System.currentTimeMillis() + 300000L;
            new SpawnRound(16, 1).run();
            this.setUpPlayers();
        }
    }

    protected static class PlayerPoint {
        int points;

        protected PlayerPoint() {
        }
    }
}

