/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.entity;

import com.l2jserver.Config;
import com.l2jserver.gameserver.Announcements;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.datatables.NpcData;
import com.l2jserver.gameserver.model.entity.TvTEvent;
import java.util.Calendar;
import java.util.concurrent.ScheduledFuture;
import java.util.logging.Logger;

public class TvTManager {
    protected static final Logger _log = Logger.getLogger(TvTManager.class.getName());
    private TvTStartTask _task;

    protected TvTManager() {
        if (Config.TVT_EVENT_ENABLED) {
            if (NpcData.getInstance().getTemplate(Config.TVT_EVENT_PARTICIPATION_NPC_ID) == null) {
                Config.TVT_EVENT_ENABLED = false;
                _log.warning("TvTEventEngine[TvTManager.TvTManager()]: L2NpcTemplate is a NullPointer -> Invalid npc id(" + Config.TVT_EVENT_PARTICIPATION_NPC_ID + ") in configs?");
                _log.info("TvTEventEngine[TvTManager.TvTManager()]: Engine is disabled.");
                return;
            }
            TvTEvent.init();
            this.scheduleEventStart();
            _log.info("TvTEventEngine[TvTManager.TvTManager()]: Started.");
        } else {
            _log.info("TvTEventEngine[TvTManager.TvTManager()]: Engine is disabled.");
        }
    }

    public static TvTManager getInstance() {
        return SingletonHolder._instance;
    }

    public void scheduleEventStart() {
        try {
            Calendar currentTime = Calendar.getInstance();
            Calendar nextStartTime = null;
            for (String timeOfDay : Config.TVT_EVENT_INTERVAL) {
                Calendar testStartTime = (Calendar)currentTime.clone();
                testStartTime.setLenient(true);
                String[] splitTimeOfDay = timeOfDay.split(":");
                testStartTime.set(11, Integer.parseInt(splitTimeOfDay[0]));
                testStartTime.set(12, Integer.parseInt(splitTimeOfDay[1]));
                testStartTime.set(13, 0);
                testStartTime.set(14, 0);
                if (testStartTime.getTimeInMillis() < currentTime.getTimeInMillis()) {
                    testStartTime.add(5, 1);
                }
                if (nextStartTime != null && testStartTime.getTimeInMillis() >= nextStartTime.getTimeInMillis()) continue;
                nextStartTime = testStartTime;
            }
            if (nextStartTime != null) {
                this._task = new TvTStartTask(nextStartTime.getTimeInMillis());
                ThreadPoolManager.getInstance().executeTask(this._task);
            }
        }
        catch (Exception e) {
            _log.warning("TvTEventEngine[TvTManager.scheduleEventStart()]: Error figuring out a start time. Check TvTEventInterval in config file.");
        }
    }

    public void startReg() {
        if (!TvTEvent.startParticipation()) {
            Announcements.getInstance().announceToAll("TvT Event: \u30a4\u30d9\u30f3\u30c8\u3092\u4e2d\u6b62\u3057\u307e\u3057\u305f\u3002");
            _log.warning("TvTEventEngine[TvTManager.run()]: Error spawning event npc for participation.");
            this.scheduleEventStart();
        } else {
            Announcements.getInstance().announceToAll("TvT Event: \u53c2\u52a0\u8005\u52df\u96c6\u3092\u958b\u59cb\u3057\u307e\u3057\u305f\u3002\u7de0\u3081\u5207\u308a\u306f " + Config.TVT_EVENT_PARTICIPATION_TIME + "\u5206\u5f8c\u3067\u3059\u3002");
            this._task.setStartTime(System.currentTimeMillis() + 60000L * (long)Config.TVT_EVENT_PARTICIPATION_TIME);
            ThreadPoolManager.getInstance().executeTask(this._task);
        }
    }

    public void startEvent() {
        if (!TvTEvent.startFight()) {
            Announcements.getInstance().announceToAll("TvT Event: \u53c2\u52a0\u8005\u304c\u4e0d\u8db3\u3057\u3066\u3044\u308b\u305f\u3081\u30a4\u30d9\u30f3\u30c8\u3092\u4e2d\u6b62\u3057\u307e\u3057\u305f\u3002");
            _log.info("TvTEventEngine[TvTManager.run()]: Lack of registration, abort event.");
            this.scheduleEventStart();
        } else {
            TvTEvent.sysMsgToAllParticipants("TvT Event: Teleporting participants to an arena in " + Config.TVT_EVENT_START_LEAVE_TELEPORT_DELAY + " second(s).");
            this._task.setStartTime(System.currentTimeMillis() + 60000L * (long)Config.TVT_EVENT_RUNNING_TIME);
            ThreadPoolManager.getInstance().executeTask(this._task);
        }
    }

    public void endEvent() {
        Announcements.getInstance().announceToAll(TvTEvent.calculateRewards());
        TvTEvent.sysMsgToAllParticipants("TvT Event: " + Config.TVT_EVENT_START_LEAVE_TELEPORT_DELAY + " \u79d2\u5f8c\u306b\u767b\u9332\u53d7\u4ed8NPC\u306e\u5143\u3078\u30c6\u30ec\u30dd\u30fc\u30c8\u3057\u307e\u3059\u3002");
        TvTEvent.stopFight();
        this.scheduleEventStart();
    }

    public void skipDelay() {
        if (this._task.nextRun.cancel(false)) {
            this._task.setStartTime(System.currentTimeMillis());
            ThreadPoolManager.getInstance().executeTask(this._task);
        }
    }

    private static class SingletonHolder {
        protected static final TvTManager _instance = new TvTManager();

        private SingletonHolder() {
        }
    }

    class TvTStartTask
    implements Runnable {
        private long _startTime;
        public ScheduledFuture<?> nextRun;

        public TvTStartTask(long startTime) {
            this._startTime = startTime;
        }

        public void setStartTime(long startTime) {
            this._startTime = startTime;
        }

        @Override
        public void run() {
            int delay = (int)Math.round((double)(this._startTime - System.currentTimeMillis()) / 1000.0);
            if (delay > 0) {
                this.announce(delay);
            }
            int nextMsg = 0;
            if (delay > 3600) {
                nextMsg = delay - 3600;
            } else if (delay > 1800) {
                nextMsg = delay - 1800;
            } else if (delay > 900) {
                nextMsg = delay - 900;
            } else if (delay > 600) {
                nextMsg = delay - 600;
            } else if (delay > 300) {
                nextMsg = delay - 300;
            } else if (delay > 60) {
                nextMsg = delay - 60;
            } else if (delay > 5) {
                nextMsg = delay - 5;
            } else if (delay > 0) {
                nextMsg = delay;
            } else if (TvTEvent.isInactive()) {
                TvTManager.this.startReg();
            } else if (TvTEvent.isParticipating()) {
                TvTManager.this.startEvent();
            } else {
                TvTManager.this.endEvent();
            }
            if (delay > 0) {
                this.nextRun = ThreadPoolManager.getInstance().scheduleGeneral(this, nextMsg * 1000);
            }
        }

        private void announce(long time) {
            if (time >= 3600L && time % 3600L == 0L) {
                if (TvTEvent.isParticipating()) {
                    Announcements.getInstance().announceToAll("TvT Event: \u53c2\u52a0\u52df\u96c6\u306e\u7de0\u5207\u307e\u3067\u3042\u3068 " + time / 60L / 60L + " \u6642\u9593\uff01");
                } else if (TvTEvent.isStarted()) {
                    TvTEvent.sysMsgToAllParticipants("TvT Event: \u30a4\u30d9\u30f3\u30c8\u7d42\u4e86\u307e\u3067\u3042\u3068 " + time / 60L / 60L + " \u6642\u9593\uff01");
                }
            } else if (time >= 60L) {
                if (TvTEvent.isParticipating()) {
                    Announcements.getInstance().announceToAll("TvT Event: \u53c2\u52a0\u52df\u96c6\u306e\u7de0\u5207\u307e\u3067\u3042\u3068 " + time / 60L + " \u5206\uff01");
                } else if (TvTEvent.isStarted()) {
                    TvTEvent.sysMsgToAllParticipants("TvT Event: \u30a4\u30d9\u30f3\u30c8\u7d42\u4e86\u307e\u3067\u3042\u3068 " + time / 60L + " \u5206\uff01");
                }
            } else if (TvTEvent.isParticipating()) {
                Announcements.getInstance().announceToAll("TvT Event: \u53c2\u52a0\u52df\u96c6\u306e\u7de0\u5207\u307e\u3067\u3042\u3068 " + time + " \u79d2\uff01");
            } else if (TvTEvent.isStarted()) {
                TvTEvent.sysMsgToAllParticipants("TvT Event: \u30a4\u30d9\u30f3\u30c8\u7d42\u4e86\u307e\u3067\u3042\u3068 " + time + " \u79d2\uff01");
            }
        }
    }
}

