/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.itemcontainer;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.enums.ItemLocation;
import com.l2jserver.gameserver.model.TradeItem;
import com.l2jserver.gameserver.model.TradeList;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.itemcontainer.Inventory;
import com.l2jserver.gameserver.model.itemcontainer.ItemContainer;
import com.l2jserver.gameserver.model.items.L2Item;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.InventoryUpdate;
import com.l2jserver.gameserver.network.serverpackets.ItemList;
import com.l2jserver.gameserver.network.serverpackets.StatusUpdate;
import com.l2jserver.gameserver.scripting.scriptengine.events.AddToInventoryEvent;
import com.l2jserver.gameserver.scripting.scriptengine.events.ItemDestroyEvent;
import com.l2jserver.gameserver.scripting.scriptengine.events.ItemDropEvent;
import com.l2jserver.gameserver.scripting.scriptengine.events.ItemTransferEvent;
import com.l2jserver.gameserver.scripting.scriptengine.listeners.player.ItemTracker;
import com.l2jserver.gameserver.util.Util;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastList;

public class PcInventory
extends Inventory {
    private static final Logger _log = Logger.getLogger(PcInventory.class.getName());
    private final L2PcInstance _owner;
    private L2ItemInstance _adena;
    private L2ItemInstance _ancientAdena;
    private int[] _blockItems = null;
    private int _questSlots;
    private final Object _lock;
    private int _blockMode = -1;
    private static FastList<ItemTracker> itemTrackers = new FastList().shared();

    public PcInventory(L2PcInstance owner) {
        this._owner = owner;
        this._lock = new Object();
    }

    @Override
    public L2PcInstance getOwner() {
        return this._owner;
    }

    @Override
    protected ItemLocation getBaseLocation() {
        return ItemLocation.INVENTORY;
    }

    @Override
    protected ItemLocation getEquipLocation() {
        return ItemLocation.PAPERDOLL;
    }

    public L2ItemInstance getAdenaInstance() {
        return this._adena;
    }

    @Override
    public long getAdena() {
        return this._adena != null ? this._adena.getCount() : 0L;
    }

    public L2ItemInstance getAncientAdenaInstance() {
        return this._ancientAdena;
    }

    public long getAncientAdena() {
        return this._ancientAdena != null ? this._ancientAdena.getCount() : 0L;
    }

    public L2ItemInstance[] getUniqueItems(boolean allowAdena, boolean allowAncientAdena) {
        return this.getUniqueItems(allowAdena, allowAncientAdena, true);
    }

    public L2ItemInstance[] getUniqueItems(boolean allowAdena, boolean allowAncientAdena, boolean onlyAvailable) {
        FastList list = FastList.newInstance();
        for (L2ItemInstance item : this._items) {
            if (item == null || !allowAdena && item.getId() == 57 || !allowAncientAdena && item.getId() == 5575) continue;
            boolean isDuplicate = false;
            for (L2ItemInstance litem : list) {
                if (litem.getId() != item.getId()) continue;
                isDuplicate = true;
                break;
            }
            if (isDuplicate || onlyAvailable && (!item.isSellable() || !item.isAvailable(this.getOwner(), false, false))) continue;
            list.add((Object)item);
        }
        L2ItemInstance[] result = (L2ItemInstance[])list.toArray((Object[])new L2ItemInstance[list.size()]);
        FastList.recycle((FastList)list);
        return result;
    }

    public L2ItemInstance[] getUniqueItemsByEnchantLevel(boolean allowAdena, boolean allowAncientAdena) {
        return this.getUniqueItemsByEnchantLevel(allowAdena, allowAncientAdena, true);
    }

    public L2ItemInstance[] getUniqueItemsByEnchantLevel(boolean allowAdena, boolean allowAncientAdena, boolean onlyAvailable) {
        FastList list = FastList.newInstance();
        for (L2ItemInstance item : this._items) {
            if (item == null || !allowAdena && item.getId() == 57 || !allowAncientAdena && item.getId() == 5575) continue;
            boolean isDuplicate = false;
            for (L2ItemInstance litem : list) {
                if (litem.getId() != item.getId() || litem.getEnchantLevel() != item.getEnchantLevel()) continue;
                isDuplicate = true;
                break;
            }
            if (isDuplicate || onlyAvailable && (!item.isSellable() || !item.isAvailable(this.getOwner(), false, false))) continue;
            list.add((Object)item);
        }
        L2ItemInstance[] result = (L2ItemInstance[])list.toArray((Object[])new L2ItemInstance[list.size()]);
        FastList.recycle((FastList)list);
        return result;
    }

    public L2ItemInstance[] getAllItemsByItemId(int itemId) {
        return this.getAllItemsByItemId(itemId, true);
    }

    public L2ItemInstance[] getAllItemsByItemId(int itemId, boolean includeEquipped) {
        FastList list = FastList.newInstance();
        for (L2ItemInstance item : this._items) {
            if (item == null || item.getId() != itemId || !includeEquipped && item.isEquipped()) continue;
            list.add((Object)item);
        }
        L2ItemInstance[] result = (L2ItemInstance[])list.toArray((Object[])new L2ItemInstance[list.size()]);
        FastList.recycle((FastList)list);
        return result;
    }

    public L2ItemInstance[] getAllItemsByItemId(int itemId, int enchantment) {
        return this.getAllItemsByItemId(itemId, enchantment, true);
    }

    public L2ItemInstance[] getAllItemsByItemId(int itemId, int enchantment, boolean includeEquipped) {
        FastList list = FastList.newInstance();
        for (L2ItemInstance item : this._items) {
            if (item == null || item.getId() != itemId || item.getEnchantLevel() != enchantment || !includeEquipped && item.isEquipped()) continue;
            list.add((Object)item);
        }
        L2ItemInstance[] result = (L2ItemInstance[])list.toArray((Object[])new L2ItemInstance[list.size()]);
        FastList.recycle((FastList)list);
        return result;
    }

    public L2ItemInstance[] getAvailableItems(boolean allowAdena, boolean allowNonTradeable, boolean feightable) {
        FastList list = FastList.newInstance();
        for (L2ItemInstance item : this._items) {
            if (item == null || !item.isAvailable(this.getOwner(), allowAdena, allowNonTradeable) || !this.canManipulateWithItemId(item.getId())) continue;
            if (feightable) {
                if (item.getItemLocation() != ItemLocation.INVENTORY || !item.isFreightable()) continue;
                list.add((Object)item);
                continue;
            }
            list.add((Object)item);
        }
        L2ItemInstance[] result = (L2ItemInstance[])list.toArray((Object[])new L2ItemInstance[list.size()]);
        FastList.recycle((FastList)list);
        return result;
    }

    public L2ItemInstance[] getAugmentedItems() {
        FastList list = FastList.newInstance();
        for (L2ItemInstance item : this._items) {
            if (item == null || !item.isAugmented()) continue;
            list.add((Object)item);
        }
        L2ItemInstance[] result = (L2ItemInstance[])list.toArray((Object[])new L2ItemInstance[list.size()]);
        FastList.recycle((FastList)list);
        return result;
    }

    public L2ItemInstance[] getElementItems() {
        FastList list = FastList.newInstance();
        for (L2ItemInstance item : this._items) {
            if (item == null || item.getElementals() == null) continue;
            list.add((Object)item);
        }
        L2ItemInstance[] result = (L2ItemInstance[])list.toArray((Object[])new L2ItemInstance[list.size()]);
        FastList.recycle((FastList)list);
        return result;
    }

    public TradeItem[] getAvailableItems(TradeList tradeList) {
        FastList list = FastList.newInstance();
        for (L2ItemInstance item : this._items) {
            TradeItem adjItem;
            if (item == null || !item.isAvailable(this.getOwner(), false, false) || (adjItem = tradeList.adjustAvailableItem(item)) == null) continue;
            list.add((Object)adjItem);
        }
        TradeItem[] result = (TradeItem[])list.toArray((Object[])new TradeItem[list.size()]);
        FastList.recycle((FastList)list);
        return result;
    }

    public void adjustAvailableItem(TradeItem item) {
        boolean notAllEquipped = false;
        for (L2ItemInstance adjItem : this.getItemsByItemId(item.getItem().getId())) {
            if (adjItem.isEquipable()) {
                if (adjItem.isEquipped()) continue;
                notAllEquipped |= true;
                continue;
            }
            notAllEquipped |= true;
            break;
        }
        if (notAllEquipped) {
            L2ItemInstance adjItem = this.getItemByItemId(item.getItem().getId());
            item.setObjectId(adjItem.getObjectId());
            item.setEnchant(adjItem.getEnchantLevel());
            if (adjItem.getCount() < item.getCount()) {
                item.setCount(adjItem.getCount());
            }
            return;
        }
        item.setCount(0L);
    }

    public void addAdena(String process, long count, L2PcInstance actor, Object reference) {
        if (count > 0L) {
            this.addItem(process, 57, count, actor, reference);
        }
    }

    public boolean reduceAdena(String process, long count, L2PcInstance actor, Object reference) {
        if (count > 0L) {
            return this.destroyItemByItemId(process, 57, count, actor, reference) != null;
        }
        return false;
    }

    public void addAncientAdena(String process, long count, L2PcInstance actor, Object reference) {
        if (count > 0L) {
            this.addItem(process, 5575, count, actor, reference);
        }
    }

    public boolean reduceAncientAdena(String process, long count, L2PcInstance actor, Object reference) {
        if (count > 0L) {
            return this.destroyItemByItemId(process, 5575, count, actor, reference) != null;
        }
        return false;
    }

    @Override
    public L2ItemInstance addItem(String process, L2ItemInstance item, L2PcInstance actor, Object reference) {
        if ((item = super.addItem(process, item, actor, reference)) != null && item.getId() == 57 && !item.equals(this._adena)) {
            this._adena = item;
        }
        if (item != null && item.getId() == 5575 && !item.equals(this._ancientAdena)) {
            this._ancientAdena = item;
        }
        this.fireTrackerEvents(TrackerEvent.ADD_TO_INVENTORY, actor, item, null);
        return item;
    }

    @Override
    public L2ItemInstance addItem(String process, int itemId, long count, L2PcInstance actor, Object reference) {
        L2ItemInstance item = super.addItem(process, itemId, count, actor, reference);
        if (item != null && item.getId() == 57 && !item.equals(this._adena)) {
            this._adena = item;
        }
        if (item != null && item.getId() == 5575 && !item.equals(this._ancientAdena)) {
            this._ancientAdena = item;
        }
        if (item != null && actor != null) {
            if (!Config.FORCE_INVENTORY_UPDATE) {
                InventoryUpdate playerIU = new InventoryUpdate();
                playerIU.addItem(item);
                actor.sendPacket(playerIU);
            } else {
                actor.sendPacket(new ItemList(actor, false));
            }
            StatusUpdate su = new StatusUpdate(actor);
            su.addAttribute(14, actor.getCurrentLoad());
            actor.sendPacket(su);
            this.fireTrackerEvents(TrackerEvent.ADD_TO_INVENTORY, actor, item, null);
        }
        return item;
    }

    @Override
    public L2ItemInstance transferItem(String process, int objectId, long count, ItemContainer target, L2PcInstance actor, Object reference) {
        L2ItemInstance item = super.transferItem(process, objectId, count, target, actor, reference);
        if (this._adena != null && (this._adena.getCount() <= 0L || this._adena.getOwnerId() != this.getOwnerId())) {
            this._adena = null;
        }
        if (this._ancientAdena != null && (this._ancientAdena.getCount() <= 0L || this._ancientAdena.getOwnerId() != this.getOwnerId())) {
            this._ancientAdena = null;
        }
        this.fireTrackerEvents(TrackerEvent.TRANSFER, actor, item, target);
        return item;
    }

    @Override
    public L2ItemInstance destroyItem(String process, L2ItemInstance item, L2PcInstance actor, Object reference) {
        return this.destroyItem(process, item, item.getCount(), actor, reference);
    }

    @Override
    public L2ItemInstance destroyItem(String process, L2ItemInstance item, long count, L2PcInstance actor, Object reference) {
        item = super.destroyItem(process, item, count, actor, reference);
        if (this._adena != null && this._adena.getCount() <= 0L) {
            this._adena = null;
        }
        if (this._ancientAdena != null && this._ancientAdena.getCount() <= 0L) {
            this._ancientAdena = null;
        }
        this.fireTrackerEvents(TrackerEvent.DESTROY, actor, item, null);
        return item;
    }

    @Override
    public L2ItemInstance destroyItem(String process, int objectId, long count, L2PcInstance actor, Object reference) {
        L2ItemInstance item = this.getItemByObjectId(objectId);
        if (item == null) {
            return null;
        }
        return this.destroyItem(process, item, count, actor, reference);
    }

    @Override
    public L2ItemInstance destroyItemByItemId(String process, int itemId, long count, L2PcInstance actor, Object reference) {
        L2ItemInstance item = this.getItemByItemId(itemId);
        if (item == null) {
            return null;
        }
        return this.destroyItem(process, item, count, actor, reference);
    }

    @Override
    public L2ItemInstance dropItem(String process, L2ItemInstance item, L2PcInstance actor, Object reference) {
        item = super.dropItem(process, item, actor, reference);
        if (this._adena != null && (this._adena.getCount() <= 0L || this._adena.getOwnerId() != this.getOwnerId())) {
            this._adena = null;
        }
        if (this._ancientAdena != null && (this._ancientAdena.getCount() <= 0L || this._ancientAdena.getOwnerId() != this.getOwnerId())) {
            this._ancientAdena = null;
        }
        this.fireTrackerEvents(TrackerEvent.DROP, actor, item, null);
        return item;
    }

    @Override
    public L2ItemInstance dropItem(String process, int objectId, long count, L2PcInstance actor, Object reference) {
        L2ItemInstance item = super.dropItem(process, objectId, count, actor, reference);
        if (this._adena != null && (this._adena.getCount() <= 0L || this._adena.getOwnerId() != this.getOwnerId())) {
            this._adena = null;
        }
        if (this._ancientAdena != null && (this._ancientAdena.getCount() <= 0L || this._ancientAdena.getOwnerId() != this.getOwnerId())) {
            this._ancientAdena = null;
        }
        this.fireTrackerEvents(TrackerEvent.DROP, actor, item, null);
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean removeItem(L2ItemInstance item) {
        this.getOwner().removeItemFromShortCut(item.getObjectId());
        if (item.getObjectId() == this.getOwner().getActiveEnchantItemId()) {
            this.getOwner().setActiveEnchantItemId(-1);
        }
        if (item.getId() == 57) {
            this._adena = null;
        } else if (item.getId() == 5575) {
            this._ancientAdena = null;
        }
        if (item.isQuestItem()) {
            Object object = this._lock;
            synchronized (object) {
                --this._questSlots;
                if (this._questSlots < 0) {
                    this._questSlots = 0;
                    _log.warning(this + ": QuestInventory size < 0!");
                }
            }
        }
        return super.removeItem(item);
    }

    @Override
    public void refreshWeight() {
        super.refreshWeight();
        this.getOwner().refreshOverloaded();
    }

    @Override
    public void restore() {
        super.restore();
        this._adena = this.getItemByItemId(57);
        this._ancientAdena = this.getItemByItemId(5575);
    }

    public static int[][] restoreVisibleInventory(int objectId) {
        int[][] paperdoll = new int[31][3];
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement statement2 = con.prepareStatement("SELECT object_id,item_id,loc_data,enchant_level FROM items WHERE owner_id=? AND loc='PAPERDOLL'");){
            statement2.setInt(1, objectId);
            try (ResultSet invdata = statement2.executeQuery();){
                while (invdata.next()) {
                    int slot = invdata.getInt("loc_data");
                    paperdoll[slot][0] = invdata.getInt("object_id");
                    paperdoll[slot][1] = invdata.getInt("item_id");
                    paperdoll[slot][2] = invdata.getInt("enchant_level");
                }
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Could not restore inventory: " + e.getMessage(), e);
        }
        return paperdoll;
    }

    public boolean checkInventorySlotsAndWeight(List<L2Item> itemList, boolean sendMessage, boolean sendSkillMessage) {
        boolean inventoryStatusOK;
        int lootWeight = 0;
        int requiredSlots = 0;
        if (itemList != null) {
            for (L2Item item : itemList) {
                if (!item.isStackable() || this.getInventoryItemCount(item.getId(), -1) <= 0L) {
                    ++requiredSlots;
                }
                lootWeight += item.getWeight();
            }
        }
        boolean bl = inventoryStatusOK = this.validateCapacity(requiredSlots) && this.validateWeight(lootWeight);
        if (!inventoryStatusOK && sendMessage) {
            this._owner.sendPacket(SystemMessageId.SLOTS_FULL);
            if (sendSkillMessage) {
                this._owner.sendPacket(SystemMessageId.WEIGHT_EXCEEDED_SKILL_UNAVAILABLE);
            }
        }
        return inventoryStatusOK;
    }

    public boolean validateCapacity(L2ItemInstance item) {
        int slots = 0;
        if (!item.isStackable() || this.getInventoryItemCount(item.getId(), -1) <= 0L || !item.getItem().hasExImmediateEffect()) {
            ++slots;
        }
        return this.validateCapacity(slots, item.isQuestItem());
    }

    public boolean validateCapacityByItemId(int itemId) {
        int slots = 0;
        L2ItemInstance invItem = this.getItemByItemId(itemId);
        if (invItem == null || !invItem.isStackable()) {
            ++slots;
        }
        return this.validateCapacity(slots, ItemTable.getInstance().getTemplate(itemId).isQuestItem());
    }

    @Override
    public boolean validateCapacity(long slots) {
        return this.validateCapacity(slots, false);
    }

    public boolean validateCapacity(long slots, boolean questItem) {
        if (!questItem) {
            return (long)(this._items.size() - this._questSlots) + slots <= (long)this._owner.getInventoryLimit();
        }
        return (long)this._questSlots + slots <= (long)this._owner.getQuestInventoryLimit();
    }

    @Override
    public boolean validateWeight(long weight) {
        if (this._owner.isGM() && this._owner.getDietMode() && this._owner.getAccessLevel().allowTransaction()) {
            return true;
        }
        return (long)this._totalWeight + weight <= (long)this._owner.getMaxLoad();
    }

    public void setInventoryBlock(int[] items, int mode) {
        this._blockMode = mode;
        this._blockItems = items;
        this._owner.sendPacket(new ItemList(this._owner, false));
    }

    public void unblock() {
        this._blockMode = -1;
        this._blockItems = null;
        this._owner.sendPacket(new ItemList(this._owner, false));
    }

    public boolean hasInventoryBlock() {
        return this._blockMode > -1 && this._blockItems != null && this._blockItems.length > 0;
    }

    public void blockAllItems() {
        this.setInventoryBlock(new int[]{ItemTable.getInstance().getArraySize() + 2}, 1);
    }

    public int getBlockMode() {
        return this._blockMode;
    }

    public int[] getBlockItems() {
        return this._blockItems;
    }

    public boolean canManipulateWithItemId(int itemId) {
        return (this._blockMode != 0 || !Util.contains(this._blockItems, itemId)) && (this._blockMode != 1 || Util.contains(this._blockItems, itemId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addItem(L2ItemInstance item) {
        if (item.isQuestItem()) {
            Object object = this._lock;
            synchronized (object) {
                ++this._questSlots;
            }
        }
        super.addItem(item);
    }

    public int getSize(boolean quest) {
        if (quest) {
            return this._questSlots;
        }
        return this.getSize() - this._questSlots;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._owner + "]";
    }

    public void applyItemSkills() {
        for (L2ItemInstance item : this._items) {
            item.giveSkillsToOwner();
            item.applyEnchantStats();
        }
    }

    private void fireTrackerEvents(TrackerEvent tEvent, L2PcInstance actor, L2ItemInstance item, ItemContainer target) {
        if (item != null && actor != null && !itemTrackers.isEmpty()) {
            switch (tEvent) {
                case ADD_TO_INVENTORY: {
                    AddToInventoryEvent event = new AddToInventoryEvent();
                    event.setItem(item);
                    event.setPlayer(actor);
                    for (ItemTracker tracker : itemTrackers) {
                        if (!tracker.containsItemId(item.getId())) continue;
                        tracker.onAddToInventory(event);
                    }
                    return;
                }
                case DROP: {
                    ItemDropEvent event = new ItemDropEvent();
                    event.setItem(item);
                    event.setDropper(actor);
                    event.setLocation(actor.getLocation());
                    for (ItemTracker tracker : itemTrackers) {
                        if (!tracker.containsItemId(item.getId())) continue;
                        tracker.onDrop(event);
                    }
                    return;
                }
                case DESTROY: {
                    ItemDestroyEvent event = new ItemDestroyEvent();
                    event.setItem(item);
                    event.setPlayer(actor);
                    for (ItemTracker tracker : itemTrackers) {
                        if (!tracker.containsItemId(item.getId())) continue;
                        tracker.onDestroy(event);
                    }
                    return;
                }
                case TRANSFER: {
                    if (target != null) {
                        ItemTransferEvent event = new ItemTransferEvent();
                        event.setItem(item);
                        event.setPlayer(actor);
                        event.setTarget(target);
                        for (ItemTracker tracker : itemTrackers) {
                            if (!tracker.containsItemId(item.getId())) continue;
                            tracker.onTransfer(event);
                        }
                    }
                    return;
                }
            }
        }
    }

    public static void addItemTracker(ItemTracker tracker) {
        if (!itemTrackers.contains((Object)tracker)) {
            itemTrackers.add((Object)tracker);
        }
    }

    public static void removeItemTracker(ItemTracker tracker) {
        itemTrackers.remove((Object)tracker);
    }

    private static enum TrackerEvent {
        DROP,
        ADD_TO_INVENTORY,
        DESTROY,
        TRANSFER;

    }
}

