/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.items;

import com.l2jserver.gameserver.datatables.StringIntern;
import com.l2jserver.gameserver.model.L2ExtractableProduct;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.items.L2Item;
import com.l2jserver.gameserver.model.items.type.L2EtcItemType;
import com.l2jserver.util.StringUtil;
import java.util.ArrayList;
import java.util.List;

public final class L2EtcItem
extends L2Item {
    private String _handler;
    private L2EtcItemType _type;
    private final boolean _isBlessed;
    private final List<L2ExtractableProduct> _extractableItems;

    public L2EtcItem(StatsSet set) {
        super(set);
        this._type = L2EtcItemType.valueOf(set.getString("etcitem_type", "none").toUpperCase());
        switch (this.getDefaultAction()) {
            case soulshot: 
            case summon_soulshot: 
            case summon_spiritshot: 
            case spiritshot: {
                this._type = L2EtcItemType.SHOT;
            }
        }
        this._type1 = 4;
        this._type2 = 5;
        if (this.isQuestItem()) {
            this._type2 = 3;
        } else if (this.getId() == 57 || this.getId() == 5575) {
            this._type2 = 4;
        }
        this._handler = StringIntern.intern(set.getString("handler", null));
        this._isBlessed = set.getBoolean("blessed", false);
        String capsuled_items = set.getString("capsuled_items", null);
        if (capsuled_items != null) {
            String[] split = capsuled_items.split(";");
            this._extractableItems = new ArrayList<L2ExtractableProduct>(split.length);
            for (String part : split) {
                if (part.trim().isEmpty()) continue;
                String[] data = part.split(",");
                if (data.length != 4) {
                    _log.info(StringUtil.concat("> Couldnt parse ", part, " in capsuled_items! item ", this.toString()));
                    continue;
                }
                int itemId = Integer.parseInt(data[0]);
                int min = Integer.parseInt(data[1]);
                int max = Integer.parseInt(data[2]);
                double chance = Double.parseDouble(data[3]);
                if (max < min) {
                    _log.info(StringUtil.concat("> Max amount < Min amount in ", part, ", item ", this.toString()));
                    continue;
                }
                L2ExtractableProduct product = new L2ExtractableProduct(itemId, min, max, chance);
                this._extractableItems.add(product);
            }
            ((ArrayList)this._extractableItems).trimToSize();
            if (this._handler == null) {
                _log.warning("Item " + this + " define capsuled_items but missing handler.");
                this._handler = "ExtractableItems";
            }
        } else {
            this._extractableItems = null;
        }
    }

    @Override
    public L2EtcItemType getItemType() {
        return this._type;
    }

    @Override
    public int getItemMask() {
        return this.getItemType().mask();
    }

    public String getHandlerName() {
        return this._handler;
    }

    public final boolean isBlessed() {
        return this._isBlessed;
    }

    public List<L2ExtractableProduct> getExtractableItems() {
        return this._extractableItems;
    }
}

