/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.items;

import com.l2jserver.gameserver.enums.QuestEventType;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.conditions.Condition;
import com.l2jserver.gameserver.model.conditions.ConditionGameChance;
import com.l2jserver.gameserver.model.holders.SkillHolder;
import com.l2jserver.gameserver.model.items.L2Item;
import com.l2jserver.gameserver.model.items.type.L2WeaponType;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.model.stats.Env;
import com.l2jserver.gameserver.model.stats.Formulas;
import com.l2jserver.gameserver.util.Util;
import com.l2jserver.util.StringUtil;
import java.util.Collection;
import java.util.List;

public final class L2Weapon
extends L2Item {
    private final L2WeaponType _type;
    private final boolean _isMagicWeapon;
    private final int _rndDam;
    private final int _soulShotCount;
    private final int _spiritShotCount;
    private final int _mpConsume;
    private final int _baseAttackRange;
    private final int _baseAttackAngle;
    private SkillHolder _enchant4Skill = null;
    private final int _changeWeaponId;
    private SkillHolder _skillsOnMagic;
    private Condition _skillsOnMagicCondition = null;
    private SkillHolder _skillsOnCrit;
    private Condition _skillsOnCritCondition = null;
    private final int _reducedSoulshot;
    private final int _reducedSoulshotChance;
    private final int _reducedMpConsume;
    private final int _reducedMpConsumeChance;
    private final boolean _isForceEquip;
    private final boolean _isAttackWeapon;
    private final boolean _useWeaponSkillsOnly;

    public L2Weapon(StatsSet set) {
        super(set);
        int id;
        int chance;
        String[] info;
        this._type = L2WeaponType.valueOf(set.getString("weapon_type", "none").toUpperCase());
        this._type1 = 0;
        this._type2 = 0;
        this._isMagicWeapon = set.getBoolean("is_magic_weapon", false);
        this._soulShotCount = set.getInt("soulshots", 0);
        this._spiritShotCount = set.getInt("spiritshots", 0);
        this._rndDam = set.getInt("random_damage", 0);
        this._mpConsume = set.getInt("mp_consume", 0);
        this._baseAttackRange = set.getInt("attack_range", 40);
        String[] damgeRange = set.getString("damage_range", "").split(";");
        this._baseAttackAngle = damgeRange.length > 1 && Util.isDigit(damgeRange[3]) ? Integer.parseInt(damgeRange[3]) : 120;
        String[] reduced_soulshots = set.getString("reduced_soulshot", "").split(",");
        this._reducedSoulshotChance = reduced_soulshots.length == 2 ? Integer.parseInt(reduced_soulshots[0]) : 0;
        this._reducedSoulshot = reduced_soulshots.length == 2 ? Integer.parseInt(reduced_soulshots[1]) : 0;
        String[] reduced_mpconsume = set.getString("reduced_mp_consume", "").split(",");
        this._reducedMpConsumeChance = reduced_mpconsume.length == 2 ? Integer.parseInt(reduced_mpconsume[0]) : 0;
        this._reducedMpConsume = reduced_mpconsume.length == 2 ? Integer.parseInt(reduced_mpconsume[1]) : 0;
        String skill = set.getString("enchant4_skill", null);
        if (skill != null && (info = skill.split("-")) != null && info.length == 2) {
            int id2 = 0;
            int level = 0;
            try {
                id2 = Integer.parseInt(info[0]);
                level = Integer.parseInt(info[1]);
            }
            catch (Exception nfe) {
                _log.info(StringUtil.concat("> Couldnt parse ", skill, " in weapon enchant skills! item ", this.toString()));
            }
            if (id2 > 0 && level > 0) {
                this._enchant4Skill = new SkillHolder(id2, level);
            }
        }
        if ((skill = set.getString("onmagic_skill", null)) != null) {
            info = skill.split("-");
            chance = set.getInt("onmagic_chance", 100);
            if (info != null && info.length == 2) {
                id = 0;
                int level = 0;
                try {
                    id = Integer.parseInt(info[0]);
                    level = Integer.parseInt(info[1]);
                }
                catch (Exception nfe) {
                    _log.info(StringUtil.concat("> Couldnt parse ", skill, " in weapon onmagic skills! item ", this.toString()));
                }
                if (id > 0 && level > 0 && chance > 0) {
                    this._skillsOnMagic = new SkillHolder(id, level);
                    this._skillsOnMagicCondition = new ConditionGameChance(chance);
                }
            }
        }
        if ((skill = set.getString("oncrit_skill", null)) != null) {
            info = skill.split("-");
            chance = set.getInt("oncrit_chance", 100);
            if (info != null && info.length == 2) {
                id = 0;
                int level = 0;
                try {
                    id = Integer.parseInt(info[0]);
                    level = Integer.parseInt(info[1]);
                }
                catch (Exception nfe) {
                    _log.info(StringUtil.concat("> Couldnt parse ", skill, " in weapon oncrit skills! item ", this.toString()));
                }
                if (id > 0 && level > 0 && chance > 0) {
                    this._skillsOnCrit = new SkillHolder(id, level);
                    this._skillsOnCritCondition = new ConditionGameChance(chance);
                }
            }
        }
        this._changeWeaponId = set.getInt("change_weaponId", 0);
        this._isForceEquip = set.getBoolean("isForceEquip", false);
        this._isAttackWeapon = set.getBoolean("isAttackWeapon", true);
        this._useWeaponSkillsOnly = set.getBoolean("useWeaponSkillsOnly", false);
    }

    @Override
    public L2WeaponType getItemType() {
        return this._type;
    }

    @Override
    public int getItemMask() {
        return this.getItemType().mask();
    }

    @Override
    public boolean isMagicWeapon() {
        return this._isMagicWeapon;
    }

    public int getSoulShotCount() {
        return this._soulShotCount;
    }

    public int getSpiritShotCount() {
        return this._spiritShotCount;
    }

    public int getReducedSoulShot() {
        return this._reducedSoulshot;
    }

    public int getReducedSoulShotChance() {
        return this._reducedSoulshotChance;
    }

    public int getRandomDamage() {
        return this._rndDam;
    }

    public int getMpConsume() {
        return this._mpConsume;
    }

    public int getBaseAttackRange() {
        return this._baseAttackRange;
    }

    public int getBaseAttackAngle() {
        return this._baseAttackAngle;
    }

    public int getReducedMpConsume() {
        return this._reducedMpConsume;
    }

    public int getReducedMpConsumeChance() {
        return this._reducedMpConsumeChance;
    }

    @Override
    public Skill getEnchant4Skill() {
        if (this._enchant4Skill == null) {
            return null;
        }
        return this._enchant4Skill.getSkill();
    }

    public int getChangeWeaponId() {
        return this._changeWeaponId;
    }

    public boolean isForceEquip() {
        return this._isForceEquip;
    }

    public boolean isAttackWeapon() {
        return this._isAttackWeapon;
    }

    public boolean useWeaponSkillsOnly() {
        return this._useWeaponSkillsOnly;
    }

    public void getSkillEffects(L2Character caster, L2Character target, boolean crit) {
        if (this._skillsOnCrit == null || !crit) {
            return;
        }
        Skill onCritSkill = this._skillsOnCrit.getSkill();
        if (this._skillsOnCritCondition != null) {
            Env env = new Env();
            env.setCharacter(caster);
            env.setTarget(target);
            env.setSkill(onCritSkill);
            if (!this._skillsOnCritCondition.test(env)) {
                return;
            }
        }
        if (!onCritSkill.checkCondition(caster, target, false)) {
            return;
        }
        L2Object[] targets = new L2Character[]{target};
        onCritSkill.activateSkill(caster, targets);
    }

    public boolean getSkillEffects(L2Character caster, L2Character target, Skill trigger) {
        if (this._skillsOnMagic == null) {
            return false;
        }
        Skill onMagicSkill = this._skillsOnMagic.getSkill();
        if (trigger.isBad() != onMagicSkill.isBad()) {
            return false;
        }
        if (!trigger.isMagic() && !onMagicSkill.isMagic()) {
            return false;
        }
        if (this._skillsOnMagicCondition != null) {
            Env env = new Env();
            env.setCharacter(caster);
            env.setTarget(target);
            env.setSkill(onMagicSkill);
            if (!this._skillsOnMagicCondition.test(env)) {
                return false;
            }
        }
        if (!onMagicSkill.checkCondition(caster, target, false)) {
            return false;
        }
        if (onMagicSkill.isBad() && Formulas.calcShldUse(caster, target, onMagicSkill) == 2) {
            return false;
        }
        L2Object[] targets = new L2Character[]{target};
        onMagicSkill.activateSkill(caster, targets);
        if (caster instanceof L2PcInstance) {
            Collection objs = caster.getKnownList().getKnownObjects().values();
            for (L2Object spMob : objs) {
                L2Npc npcMob;
                List<Quest> events;
                if (!(spMob instanceof L2Npc) || (events = (npcMob = (L2Npc)spMob).getTemplate().getEventQuests(QuestEventType.ON_SKILL_SEE)) == null) continue;
                for (Quest quest : events) {
                    quest.notifySkillSee(npcMob, caster.getActingPlayer(), onMagicSkill, targets, false);
                }
            }
        }
        return true;
    }
}

