/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.quest;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.GameTimeController;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.cache.HtmCache;
import com.l2jserver.gameserver.datatables.DoorTable;
import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.datatables.NpcData;
import com.l2jserver.gameserver.enums.QuestEventType;
import com.l2jserver.gameserver.enums.QuestSound;
import com.l2jserver.gameserver.enums.TrapAction;
import com.l2jserver.gameserver.idfactory.IdFactory;
import com.l2jserver.gameserver.instancemanager.InstanceManager;
import com.l2jserver.gameserver.instancemanager.QuestManager;
import com.l2jserver.gameserver.instancemanager.ZoneManager;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Party;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.L2WorldRegion;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.L2Playable;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.actor.instance.L2DoorInstance;
import com.l2jserver.gameserver.model.actor.instance.L2MonsterInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2TrapInstance;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.gameserver.model.base.AcquireSkillType;
import com.l2jserver.gameserver.model.entity.Instance;
import com.l2jserver.gameserver.model.holders.ItemHolder;
import com.l2jserver.gameserver.model.interfaces.IIdentifiable;
import com.l2jserver.gameserver.model.interfaces.ILocational;
import com.l2jserver.gameserver.model.interfaces.IProcedure;
import com.l2jserver.gameserver.model.itemcontainer.PcInventory;
import com.l2jserver.gameserver.model.items.L2Item;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.olympiad.CompetitionType;
import com.l2jserver.gameserver.model.quest.AITasks.AggroRangeEnter;
import com.l2jserver.gameserver.model.quest.AITasks.SeeCreature;
import com.l2jserver.gameserver.model.quest.AITasks.SkillSee;
import com.l2jserver.gameserver.model.quest.QuestState;
import com.l2jserver.gameserver.model.quest.QuestTimer;
import com.l2jserver.gameserver.model.quest.State;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.model.stats.Stats;
import com.l2jserver.gameserver.model.zone.L2ZoneType;
import com.l2jserver.gameserver.network.NpcStringId;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.ExShowScreenMessage;
import com.l2jserver.gameserver.network.serverpackets.InventoryUpdate;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.network.serverpackets.NpcQuestHtmlMessage;
import com.l2jserver.gameserver.network.serverpackets.StatusUpdate;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.scripting.ManagedScript;
import com.l2jserver.gameserver.scripting.ScriptManager;
import com.l2jserver.gameserver.util.MinionList;
import com.l2jserver.util.Rnd;
import com.l2jserver.util.Util;
import gnu.trove.iterator.TIntIterator;
import gnu.trove.set.hash.TIntHashSet;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastMap;

public class Quest
extends ManagedScript
implements IIdentifiable {
    public static final Logger _log = Logger.getLogger(Quest.class.getName());
    private static final boolean CHECK_TAKEITEMS = true;
    private final FastMap<String, List<QuestTimer>> _allEventTimers = new FastMap().shared();
    private final TIntHashSet _questInvolvedNpcs = new TIntHashSet();
    private final ReentrantReadWriteLock _rwLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.WriteLock _writeLock = this._rwLock.writeLock();
    private final ReentrantReadWriteLock.ReadLock _readLock = this._rwLock.readLock();
    private final int _questId;
    private final String _name;
    private final String _descr;
    private final byte _initialState = 0;
    protected boolean _onEnterWorld = false;
    private boolean _isOlympiadUse = false;
    public int[] questItemIds = null;
    private static final String DEFAULT_NO_QUEST_MSG = "<html><body>\u30af\u30a8\u30b9\u30c8\u3092\u9042\u884c\u3057\u3066\u3044\u306a\u3044\u304b\u6761\u4ef6\u304c\u5408\u3044\u307e\u305b\u3093\u3002</body></html>";
    private static final String DEFAULT_ALREADY_COMPLETED_MSG = "<html><body>\u3059\u3067\u306b\u9042\u884c\u3057\u305f\u30af\u30a8\u30b9\u30c8\u3067\u3059\u3002</body></html>";
    private static final String QUEST_DELETE_FROM_CHAR_QUERY = "DELETE FROM character_quests WHERE charId=? AND name=?";
    private static final String QUEST_DELETE_FROM_CHAR_QUERY_NON_REPEATABLE_QUERY = "DELETE FROM character_quests WHERE charId=? AND name=? AND var!=?";
    private static final int RESET_HOUR = 6;
    private static final int RESET_MINUTES = 30;
    private static String[] COND_CHACHE = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20"};

    public int getResetHour() {
        return 6;
    }

    public int getResetMinutes() {
        return 30;
    }

    public Quest(int questId, String name, String descr) {
        this._questId = questId;
        this._name = name;
        this._descr = descr;
        if (questId > 0) {
            QuestManager.getInstance().addQuest(this);
        } else {
            QuestManager.getInstance().addScript(this);
        }
        this.loadGlobalData();
    }

    protected void loadGlobalData() {
    }

    public void saveGlobalData() {
    }

    @Override
    public int getId() {
        return this._questId;
    }

    public int getQuestIntId() {
        return this.getId();
    }

    public QuestState newQuestState(L2PcInstance player) {
        return new QuestState(this, player, 0);
    }

    public QuestState getQuestState(L2PcInstance player, boolean initIfNone) {
        QuestState qs = player.getQuestState(this._name);
        if (qs != null || !initIfNone) {
            return qs;
        }
        return this.newQuestState(player);
    }

    public byte getInitialState() {
        return 0;
    }

    public String getName() {
        return this._name;
    }

    public String getDescr() {
        return this._descr;
    }

    public String getDescrHtm() {
        int id = this._questId;
        if (id > 0 && id < 20000) {
            if (id > 10000) {
                id -= 5000;
            }
            return "<fstring>" + id + "01</fstring>";
        }
        return this._descr;
    }

    public boolean isQuests() {
        int questId = this._questId;
        return questId > 0 && questId < 20000;
    }

    public void startQuestTimer(String name, long time, L2Npc npc, L2PcInstance player) {
        this.startQuestTimer(name, time, npc, player, false);
    }

    public void startQuestTimer(String name, long time, L2Npc npc, L2PcInstance player, boolean repeating) {
        this.startQuestTimer(name, time, npc, player, repeating, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startQuestTimer(String name, long time, L2Npc npc, L2PcInstance player, boolean repeating, boolean withFixedDelay) {
        ArrayList<QuestTimer> timers = (ArrayList<QuestTimer>)this._allEventTimers.get((Object)name);
        if (timers == null) {
            timers = new ArrayList<QuestTimer>();
            timers.add(new QuestTimer(this, name, time, npc, player, repeating, withFixedDelay));
            this._allEventTimers.put((Object)name, timers);
        } else if (this.getQuestTimer(name, npc, player) == null) {
            this._writeLock.lock();
            try {
                timers.add(new QuestTimer(this, name, time, npc, player, repeating, withFixedDelay));
            }
            finally {
                this._writeLock.unlock();
            }
        }
    }

    public void startQuestTimer(String name, long time, L2Npc npc, L2PcInstance player, Repeating repeating) {
        switch (repeating) {
            default: {
                this.startQuestTimer(name, time, npc, player, false, false);
                break;
            }
            case AtFixedRate: {
                this.startQuestTimer(name, time, npc, player, true, false);
                break;
            }
            case WithFixedDelay: {
                this.startQuestTimer(name, time, npc, player, true, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QuestTimer getQuestTimer(String name, L2Npc npc, L2PcInstance player) {
        List timers = (List)this._allEventTimers.get((Object)name);
        if (timers != null) {
            this._readLock.lock();
            try {
                for (QuestTimer timer : timers) {
                    if (timer == null || !timer.isMatch(this, name, npc, player)) continue;
                    QuestTimer questTimer = timer;
                    return questTimer;
                }
            }
            finally {
                this._readLock.unlock();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelQuestTimers(String name) {
        List timers = (List)this._allEventTimers.get((Object)name);
        if (timers != null) {
            this._writeLock.lock();
            try {
                for (QuestTimer timer : timers) {
                    if (timer == null) continue;
                    timer.cancel();
                }
                timers.clear();
            }
            finally {
                this._writeLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelQuestTimers(String name, int instanceId) {
        List timers = (List)this._allEventTimers.get((Object)name);
        if (timers == null) {
            return;
        }
        this._writeLock.lock();
        try {
            Iterator it = timers.iterator();
            while (it.hasNext()) {
                QuestTimer timer = (QuestTimer)it.next();
                if (timer == null || timer.getInstanceId() != instanceId) continue;
                timer.cancel();
                it.remove();
            }
        }
        finally {
            this._writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelQuestTimers(L2Npc npc) {
        for (List timers : this._allEventTimers.values()) {
            this._writeLock.lock();
            try {
                Iterator it = timers.iterator();
                while (it.hasNext()) {
                    QuestTimer timer = (QuestTimer)it.next();
                    if (timer == null || timer.getNpc() != npc) continue;
                    timer.cancel();
                    it.remove();
                }
            }
            finally {
                this._writeLock.unlock();
            }
        }
    }

    public void cancelQuestTimer(String name, L2Npc npc, L2PcInstance player) {
        QuestTimer timer = this.getQuestTimer(name, npc, player);
        if (timer != null) {
            timer.cancelAndRemove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeQuestTimer(QuestTimer timer) {
        List timers;
        if (timer != null && (timers = (List)this._allEventTimers.get((Object)timer.getName())) != null) {
            this._writeLock.lock();
            try {
                timers.remove(timer);
            }
            finally {
                this._writeLock.unlock();
            }
        }
    }

    public Map<String, List<QuestTimer>> getQuestTimers() {
        return this._allEventTimers;
    }

    public final void notifyAttack(L2Npc npc, L2PcInstance attacker, int damage, boolean isSummon, Skill skill) {
        String res;
        try {
            res = this.onAttack(npc, attacker, damage, isSummon, skill);
        }
        catch (Exception e) {
            this.showError(attacker, e);
            return;
        }
        this.showResult(attacker, res);
    }

    public final void notifyDeath(L2Character killer, L2Character victim, QuestState qs) {
        String res;
        try {
            res = this.onDeath(killer, victim, qs);
        }
        catch (Exception e) {
            this.showError(qs.getPlayer(), e);
            return;
        }
        this.showResult(qs.getPlayer(), res);
    }

    public final void notifyItemUse(L2Item item, L2PcInstance player) {
        String res;
        try {
            res = this.onItemUse(item, player);
        }
        catch (Exception e) {
            this.showError(player, e);
            return;
        }
        this.showResult(player, res);
    }

    public final void notifySpellFinished(L2Npc instance, L2PcInstance player, Skill skill) {
        String res;
        try {
            res = this.onSpellFinished(instance, player, skill);
        }
        catch (Exception e) {
            this.showError(player, e);
            return;
        }
        this.showResult(player, res);
    }

    public final void notifyTrapAction(L2TrapInstance trap, L2Character trigger, TrapAction action) {
        String res;
        try {
            res = this.onTrapAction(trap, trigger, action);
        }
        catch (Exception e) {
            this.showError(trigger.getActingPlayer(), e);
            _log.log(Level.WARNING, "Exception on onTrapAction() in notifyTrapAction(): " + e.getMessage(), e);
            return;
        }
        this.showResult(trigger.getActingPlayer(), res);
    }

    public final void notifySpawn(L2Npc npc) {
        try {
            this.onSpawn(npc);
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Exception on onSpawn() in notifySpawn(): " + e.getMessage(), e);
        }
    }

    public final boolean notifyEvent(String event, L2Npc npc, L2PcInstance player) {
        String res;
        try {
            res = this.onAdvEvent(event, npc, player);
        }
        catch (Exception e) {
            return this.showError(player, e);
        }
        return this.showResult(player, res, npc);
    }

    public final void notifyEnterWorld(L2PcInstance player) {
        String res;
        try {
            res = this.onEnterWorld(player);
        }
        catch (Exception e) {
            this.showError(player, e);
            return;
        }
        this.showResult(player, res);
    }

    public final void notifyKill(L2Npc npc, L2PcInstance killer, boolean isSummon) {
        String res;
        try {
            res = this.onKill(npc, killer, isSummon);
        }
        catch (Exception e) {
            this.showError(killer, e);
            return;
        }
        this.showResult(killer, res);
    }

    public final boolean notifyTalk(L2Npc npc, QuestState qs) {
        String res;
        try {
            res = this.onTalk(npc, qs.getPlayer());
        }
        catch (Exception e) {
            return this.showError(qs.getPlayer(), e);
        }
        qs.getPlayer().setLastQuestNpcObject(npc.getObjectId());
        return this.showResult(qs.getPlayer(), res, npc);
    }

    public final void notifyFirstTalk(L2Npc npc, L2PcInstance player) {
        String res;
        try {
            res = this.onFirstTalk(npc, player);
        }
        catch (Exception e) {
            this.showError(player, e);
            return;
        }
        this.showResult(player, res, npc);
    }

    public final void notifyAcquireSkillList(L2Npc npc, L2PcInstance player) {
        String res;
        try {
            res = this.onAcquireSkillList(npc, player);
        }
        catch (Exception e) {
            this.showError(player, e);
            return;
        }
        this.showResult(player, res);
    }

    public final void notifyAcquireSkillInfo(L2Npc npc, L2PcInstance player, Skill skill) {
        String res;
        try {
            res = this.onAcquireSkillInfo(npc, player, skill);
        }
        catch (Exception e) {
            this.showError(player, e);
            return;
        }
        this.showResult(player, res);
    }

    public final void notifyAcquireSkill(L2Npc npc, L2PcInstance player, Skill skill, AcquireSkillType type) {
        String res;
        try {
            res = this.onAcquireSkill(npc, player, skill, type);
        }
        catch (Exception e) {
            this.showError(player, e);
            return;
        }
        this.showResult(player, res);
    }

    public final boolean notifyItemTalk(L2ItemInstance item, L2PcInstance player) {
        String res;
        try {
            res = this.onItemTalk(item, player);
            if (res != null) {
                if (res.equalsIgnoreCase("true")) {
                    return true;
                }
                if (res.equalsIgnoreCase("false")) {
                    return false;
                }
            }
        }
        catch (Exception e) {
            return this.showError(player, e);
        }
        return this.showResult(player, res);
    }

    public String onItemTalk(L2ItemInstance item, L2PcInstance player) {
        return null;
    }

    public final boolean notifyItemEvent(L2ItemInstance item, L2PcInstance player, String event) {
        String res;
        try {
            res = this.onItemEvent(item, player, event);
            if (res != null) {
                if (res.equalsIgnoreCase("true")) {
                    return true;
                }
                if (res.equalsIgnoreCase("false")) {
                    return false;
                }
            }
        }
        catch (Exception e) {
            return this.showError(player, e);
        }
        return this.showResult(player, res);
    }

    public final void notifySkillSee(L2Npc npc, L2PcInstance caster, Skill skill, L2Object[] targets, boolean isSummon) {
        ThreadPoolManager.getInstance().executeAi(new SkillSee(this, npc, caster, skill, targets, isSummon));
    }

    public final void notifyFactionCall(L2Npc npc, L2Npc caller, L2PcInstance attacker, boolean isSummon) {
        String res;
        try {
            res = this.onFactionCall(npc, caller, attacker, isSummon);
        }
        catch (Exception e) {
            this.showError(attacker, e);
            return;
        }
        this.showResult(attacker, res);
    }

    public final void notifyAggroRangeEnter(L2Npc npc, L2PcInstance player, boolean isSummon) {
        ThreadPoolManager.getInstance().executeAi(new AggroRangeEnter(this, npc, player, isSummon));
    }

    public final void notifySeeCreature(L2Npc npc, L2Character creature, boolean isSummon) {
        ThreadPoolManager.getInstance().executeAi(new SeeCreature(this, npc, creature, isSummon));
    }

    public final void notifyEventReceived(String eventName, L2Npc sender, L2Npc receiver, L2Object reference) {
        try {
            this.onEventReceived(eventName, sender, receiver, reference);
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Exception on onEventReceived() in notifyEventReceived(): " + e.getMessage(), e);
        }
    }

    public void broadcastEvent(String eventName, L2Npc sender, int radius, L2Object reference) {
        int sqRadius = radius * radius;
        for (L2WorldRegion regi : sender.getWorldRegion().getSurroundingRegions()) {
            for (L2Object obj : regi.getVisibleObjects().values()) {
                List<Quest> eventQuests;
                if (obj == null || !obj.isNpc() || obj.equals(sender) || !(sender.calculateDistance(obj, false, true) <= (double)sqRadius) || (eventQuests = ((L2Npc)obj).getTemplate().getEventQuests(QuestEventType.ON_EVENT_RECEIVED)) == null) continue;
                for (Quest quest : eventQuests) {
                    if (quest != this) continue;
                    this.notifyEventReceived(eventName, sender, (L2Npc)obj, reference);
                }
            }
        }
    }

    public final void notifyEnterZone(L2Character character, L2ZoneType zone) {
        String res;
        L2PcInstance player = character.getActingPlayer();
        try {
            res = this.onEnterZone(character, zone);
        }
        catch (Exception e) {
            this.showError(player, e);
            return;
        }
        this.showResult(player, res);
    }

    public final void notifyExitZone(L2Character character, L2ZoneType zone) {
        String res;
        L2PcInstance player = character.getActingPlayer();
        try {
            res = this.onExitZone(character, zone);
        }
        catch (Exception e) {
            this.showError(player, e);
            return;
        }
        this.showResult(player, res);
    }

    public final void notifyOlympiadWin(L2PcInstance winner, CompetitionType type) {
        try {
            this.onOlympiadWin(winner, type);
        }
        catch (Exception e) {
            this.showError(winner, e);
            return;
        }
    }

    public final void notifyOlympiadLose(L2PcInstance loser, CompetitionType type) {
        try {
            this.onOlympiadLose(loser, type);
        }
        catch (Exception e) {
            this.showError(loser, e);
            return;
        }
    }

    public final boolean notifyMoveFinished(L2Npc npc) {
        try {
            return this.onMoveFinished(npc);
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Exception on onMoveFinished() in notifyMoveFinished(): " + e.getMessage(), e);
            return false;
        }
    }

    public final boolean notifyNodeArrived(L2Npc npc) {
        try {
            return this.onNodeArrived(npc);
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Exception on onNodeArrived() in notifyNodeArrived(): " + e.getMessage(), e);
            return false;
        }
    }

    public final void notifyRouteFinished(L2Npc npc) {
        try {
            this.onRouteFinished(npc);
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Exception on onRouteFinished() in notifyRouteFinished(): " + e.getMessage(), e);
        }
    }

    public String onAttack(L2Npc npc, L2PcInstance attacker, int damage, boolean isSummon) {
        return null;
    }

    public String onAttack(L2Npc npc, L2PcInstance attacker, int damage, boolean isSummon, Skill skill) {
        return this.onAttack(npc, attacker, damage, isSummon);
    }

    public String onDeath(L2Character killer, L2Character victim, QuestState qs) {
        return this.onAdvEvent("", killer instanceof L2Npc ? (L2Npc)killer : null, qs.getPlayer());
    }

    public String onAdvEvent(String event, L2Npc npc, L2PcInstance player) {
        QuestState qs;
        if (player != null && (qs = player.getQuestState(this.getName())) != null) {
            return this.onEvent(event, qs);
        }
        return null;
    }

    public String onEvent(String event, QuestState qs) {
        return null;
    }

    public String onKill(L2Npc npc, L2PcInstance killer, boolean isSummon) {
        return null;
    }

    public String onTalk(L2Npc npc, L2PcInstance talker) {
        return null;
    }

    public String onFirstTalk(L2Npc npc, L2PcInstance player) {
        return null;
    }

    public String onItemEvent(L2ItemInstance item, L2PcInstance player, String event) {
        return null;
    }

    public String onAcquireSkillList(L2Npc npc, L2PcInstance player) {
        return null;
    }

    public String onAcquireSkillInfo(L2Npc npc, L2PcInstance player, Skill skill) {
        return null;
    }

    public String onAcquireSkill(L2Npc npc, L2PcInstance player, Skill skill, AcquireSkillType type) {
        return null;
    }

    public String onItemUse(L2Item item, L2PcInstance player) {
        return null;
    }

    public String onSkillSee(L2Npc npc, L2PcInstance caster, Skill skill, L2Object[] targets, boolean isSummon) {
        return null;
    }

    public String onSpellFinished(L2Npc npc, L2PcInstance player, Skill skill) {
        return null;
    }

    public String onTrapAction(L2TrapInstance trap, L2Character trigger, TrapAction action) {
        return null;
    }

    public String onSpawn(L2Npc npc) {
        return null;
    }

    public String onFactionCall(L2Npc npc, L2Npc caller, L2PcInstance attacker, boolean isSummon) {
        return null;
    }

    public String onAggroRangeEnter(L2Npc npc, L2PcInstance player, boolean isSummon) {
        return null;
    }

    public String onSeeCreature(L2Npc npc, L2Character creature, boolean isSummon) {
        return null;
    }

    public String onEnterWorld(L2PcInstance player) {
        return null;
    }

    public String onEnterZone(L2Character character, L2ZoneType zone) {
        return null;
    }

    public String onExitZone(L2Character character, L2ZoneType zone) {
        return null;
    }

    public String onEventReceived(String eventName, L2Npc sender, L2Npc receiver, L2Object reference) {
        return null;
    }

    public void onOlympiadWin(L2PcInstance winner, CompetitionType type) {
    }

    public void onOlympiadLose(L2PcInstance loser, CompetitionType type) {
    }

    public boolean onMoveFinished(L2Npc npc) {
        return false;
    }

    public boolean onNodeArrived(L2Npc npc) {
        return false;
    }

    public void onRouteFinished(L2Npc npc) {
    }

    public void addRegenerateId(int npcId) {
        this.addEventId(QuestEventType.ON_REGENERATE, npcId);
    }

    public void addRegenerateId(int ... npcIds) {
        this.addEventId(QuestEventType.ON_REGENERATE, npcIds);
    }

    public void addRegenerateId(Collection<Integer> npcIds) {
        this.addEventId(QuestEventType.ON_REGENERATE, npcIds);
    }

    public final void notifyRegenerate(L2Npc npc) {
        this.onRegenerate(npc);
    }

    public String onRegenerate(L2Npc npc) {
        return null;
    }

    public boolean onNpcHate(L2Attackable mob, L2Playable playable) {
        return true;
    }

    public void onSummon(L2Summon summon) {
    }

    public boolean showError(L2PcInstance player, Throwable t) {
        _log.log(Level.WARNING, this.getScriptFile().getAbsolutePath(), t);
        if (t.getMessage() == null) {
            _log.warning(this.getClass().getSimpleName() + ": " + t.getMessage());
        }
        if (player != null && player.getAccessLevel().isGm()) {
            String res = "<html><body><title>Script error</title>" + Util.getStackTrace(t) + "</body></html>";
            return this.showResult(player, res);
        }
        t.printStackTrace();
        return false;
    }

    public boolean showResult(L2PcInstance player, String res) {
        return this.showResult(player, res, null);
    }

    public boolean showResult(L2PcInstance player, String res, L2Npc npc) {
        if (res == null || res.isEmpty() || player == null) {
            return true;
        }
        if (res.endsWith(".htm") || res.endsWith(".html")) {
            this.showHtmlFile(player, res, npc);
        } else if (res.startsWith("<html>")) {
            NpcHtmlMessage npcReply = new NpcHtmlMessage(npc != null ? npc.getObjectId() : 0, res);
            npcReply.replace((CharSequence)"%playername%", player.getName());
            player.sendPacket(npcReply);
            player.sendPacket(ActionFailed.STATIC_PACKET);
        } else {
            player.sendMessage(res);
        }
        return false;
    }

    public static final void playerEnter(L2PcInstance player) {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement invalidQuestData = con.prepareStatement("DELETE FROM character_quests WHERE charId = ? AND name = ?");
             PreparedStatement invalidQuestDataVar = con.prepareStatement("DELETE FROM character_quests WHERE charId = ? AND name = ? AND var = ?");
             PreparedStatement ps1 = con.prepareStatement("SELECT name, value FROM character_quests WHERE charId = ? AND var = ?");){
            ps1.setInt(1, player.getObjectId());
            ps1.setString(2, "<state>");
            try (ResultSet rs = ps1.executeQuery();){
                while (rs.next()) {
                    String questId = rs.getString("name");
                    String statename = rs.getString("value");
                    Quest q = QuestManager.getInstance().getQuest(questId);
                    if (q == null) {
                        _log.finer("Unknown quest " + questId + " for player " + player.getName());
                        if (!Config.AUTODELETE_INVALID_QUEST_DATA) continue;
                        invalidQuestData.setInt(1, player.getObjectId());
                        invalidQuestData.setString(2, questId);
                        invalidQuestData.executeUpdate();
                        continue;
                    }
                    new QuestState(q, player, State.getStateId(statename));
                }
            }
            var10_19 = null;
            try (PreparedStatement ps2 = con.prepareStatement("SELECT name, var, value FROM character_quests WHERE charId = ? AND var <> ?");){
                ps2.setInt(1, player.getObjectId());
                ps2.setString(2, "<state>");
                try (ResultSet rs = ps2.executeQuery();){
                    while (rs.next()) {
                        String questId = rs.getString("name");
                        String var = rs.getString("var");
                        String value = rs.getString("value");
                        QuestState qs = player.getQuestState(questId);
                        if (qs == null) {
                            _log.finer("Lost variable " + var + " in quest " + questId + " for player " + player.getName());
                            if (!Config.AUTODELETE_INVALID_QUEST_DATA) continue;
                            invalidQuestDataVar.setInt(1, player.getObjectId());
                            invalidQuestDataVar.setString(2, questId);
                            invalidQuestDataVar.setString(3, var);
                            invalidQuestDataVar.executeUpdate();
                            continue;
                        }
                        qs.setInternal(var, value);
                    }
                }
            }
            catch (Throwable throwable) {
                var10_19 = throwable;
                throw throwable;
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "could not insert char quest:", e);
        }
        for (String name : QuestManager.getInstance().getScripts().keySet()) {
            player.processQuestEvent(name, "enter");
        }
    }

    public final void saveGlobalQuestVar(String var, String value) {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement statement = con.prepareStatement("REPLACE INTO quest_global_data (quest_name,var,value) VALUES (?,?,?)");){
            statement.setString(1, this.getName());
            statement.setString(2, var);
            statement.setString(3, value);
            statement.executeUpdate();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "could not insert global quest variable:", e);
        }
    }

    public final String loadGlobalQuestVar(String var) {
        String result = "";
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement statement = con.prepareStatement("SELECT value FROM quest_global_data WHERE quest_name = ? AND var = ?");){
            statement.setString(1, this.getName());
            statement.setString(2, var);
            try (ResultSet rs = statement.executeQuery();){
                if (rs.first()) {
                    result = rs.getString(1);
                }
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "could not load global quest variable:", e);
        }
        return result;
    }

    public final void deleteGlobalQuestVar(String var) {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement statement = con.prepareStatement("DELETE FROM quest_global_data WHERE quest_name = ? AND var = ?");){
            statement.setString(1, this.getName());
            statement.setString(2, var);
            statement.executeUpdate();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "could not delete global quest variable:", e);
        }
    }

    public final void deleteAllGlobalQuestVars() {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement statement = con.prepareStatement("DELETE FROM quest_global_data WHERE quest_name = ?");){
            statement.setString(1, this.getName());
            statement.executeUpdate();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "could not delete global quest variables:", e);
        }
    }

    public static void createQuestVarInDb(QuestState qs, String var, String value) {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement statement = con.prepareStatement("INSERT INTO character_quests (charId,name,var,value) VALUES (?,?,?,?) ON DUPLICATE KEY UPDATE value=?");){
            statement.setInt(1, qs.getPlayer().getObjectId());
            statement.setString(2, qs.getQuestName());
            statement.setString(3, var);
            statement.setString(4, value);
            statement.setString(5, value);
            statement.executeUpdate();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "could not insert char quest:", e);
        }
    }

    public static void updateQuestVarInDb(QuestState qs, String var, String value) {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement statement = con.prepareStatement("UPDATE character_quests SET value=? WHERE charId=? AND name=? AND var = ?");){
            statement.setString(1, value);
            statement.setInt(2, qs.getPlayer().getObjectId());
            statement.setString(3, qs.getQuestName());
            statement.setString(4, var);
            statement.executeUpdate();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "could not update char quest:", e);
        }
    }

    public static void deleteQuestVarInDb(QuestState qs, String var) {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement statement = con.prepareStatement("DELETE FROM character_quests WHERE charId=? AND name=? AND var=?");){
            statement.setInt(1, qs.getPlayer().getObjectId());
            statement.setString(2, qs.getQuestName());
            statement.setString(3, var);
            statement.executeUpdate();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "could not delete char quest:", e);
        }
    }

    public static void deleteQuestInDb(QuestState qs, boolean repeatable) {
        Quest.deleteQuestInDb(qs.getPlayer().getObjectId(), qs.getQuestName(), repeatable);
    }

    public static void deleteQuestInDb(int playerObjectId, String questName, boolean repeatable) {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement ps = con.prepareStatement(repeatable ? QUEST_DELETE_FROM_CHAR_QUERY : QUEST_DELETE_FROM_CHAR_QUERY_NON_REPEATABLE_QUERY);){
            ps.setInt(1, playerObjectId);
            ps.setString(2, questName);
            if (!repeatable) {
                ps.setString(3, "<state>");
            }
            ps.executeUpdate();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "could not delete char quest:", e);
        }
    }

    public static void createQuestInDb(QuestState qs) {
        Quest.createQuestVarInDb(qs, "<state>", State.getStateName(qs.getState()));
    }

    public static void updateQuestInDb(QuestState qs) {
        Quest.updateQuestVarInDb(qs, "<state>", State.getStateName(qs.getState()));
    }

    public static String getNoQuestMsg(L2PcInstance player) {
        String result = HtmCache.getInstance().getHtm(player.getHtmlPrefix(), "data/html/noquest.htm");
        if (result != null && result.length() > 0) {
            return result;
        }
        return DEFAULT_NO_QUEST_MSG;
    }

    public static String getAlreadyCompletedMsg(L2PcInstance player) {
        String result = HtmCache.getInstance().getHtm(player.getHtmlPrefix(), "data/html/alreadycompleted.htm");
        if (result != null && result.length() > 0) {
            return result;
        }
        return DEFAULT_ALREADY_COMPLETED_MSG;
    }

    public void addEventId(QuestEventType eventType, int npcId) {
        if (npcId == -1) {
            return;
        }
        try {
            L2NpcTemplate t = NpcData.getInstance().getTemplate(npcId);
            if (t != null) {
                if (eventType == QuestEventType.ON_AGGRO_RANGE_ENTER && t.getAggroRange() == 0) {
                    return;
                }
                t.addQuestEvent(eventType, this);
                this._questInvolvedNpcs.add(npcId);
            } else {
                _log.warning(this.getName() + ": Exception on addEventId(" + npcId + "," + eventType.name() + "): Unknown NPC");
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, this.getName() + ": Exception on addEventId(" + npcId + "," + eventType.name() + "): " + e.getMessage(), e);
        }
    }

    public void addEventId(QuestEventType eventType, int ... npcIds) {
        for (int npcId : npcIds) {
            this.addEventId(eventType, npcId);
        }
    }

    public void addEventId(QuestEventType eventType, Collection<Integer> npcIds) {
        for (int npcId : npcIds) {
            this.addEventId(eventType, npcId);
        }
    }

    public void addStartNpc(int npcId) {
        this.addEventId(QuestEventType.QUEST_START, npcId);
    }

    public void addStartNpc(int ... npcIds) {
        this.addEventId(QuestEventType.QUEST_START, npcIds);
    }

    public void addStartNpc(Collection<Integer> npcIds) {
        this.addEventId(QuestEventType.QUEST_START, npcIds);
    }

    public void addFirstTalkId(int npcId) {
        this.addEventId(QuestEventType.ON_FIRST_TALK, npcId);
    }

    public void addFirstTalkId(int ... npcIds) {
        this.addEventId(QuestEventType.ON_FIRST_TALK, npcIds);
    }

    public void addFirstTalkId(Collection<Integer> npcIds) {
        this.addEventId(QuestEventType.ON_FIRST_TALK, npcIds);
    }

    public void addAcquireSkillId(int npcId) {
        this.addEventId(QuestEventType.ON_SKILL_LEARN, npcId);
    }

    public void addAcquireSkillId(int ... npcIds) {
        this.addEventId(QuestEventType.ON_SKILL_LEARN, npcIds);
    }

    public void addAcquireSkillId(Collection<Integer> npcIds) {
        this.addEventId(QuestEventType.ON_SKILL_LEARN, npcIds);
    }

    public void addAttackId(int npcId) {
        this.addEventId(QuestEventType.ON_ATTACK, npcId);
    }

    public void addAttackId(int ... npcIds) {
        this.addEventId(QuestEventType.ON_ATTACK, npcIds);
    }

    public void addAttackId(Collection<Integer> npcIds) {
        this.addEventId(QuestEventType.ON_ATTACK, npcIds);
    }

    public void addKillId(int killId) {
        this.addEventId(QuestEventType.ON_KILL, killId);
    }

    public void addKillId(int ... killIds) {
        this.addEventId(QuestEventType.ON_KILL, killIds);
    }

    public void addKillId(Collection<Integer> killIds) {
        this.addEventId(QuestEventType.ON_KILL, killIds);
    }

    public void addTalkId(int npcId) {
        this.addEventId(QuestEventType.ON_TALK, npcId);
    }

    public void addTalkId(int ... npcIds) {
        this.addEventId(QuestEventType.ON_TALK, npcIds);
    }

    public void addTalkId(Collection<Integer> npcIds) {
        this.addEventId(QuestEventType.ON_TALK, npcIds);
    }

    public void addSpawnId(int npcId) {
        this.addEventId(QuestEventType.ON_SPAWN, npcId);
    }

    public void addSpawnId(int ... npcIds) {
        this.addEventId(QuestEventType.ON_SPAWN, npcIds);
    }

    public void addSpawnId(Collection<Integer> npcIds) {
        this.addEventId(QuestEventType.ON_SPAWN, npcIds);
    }

    public void addSkillSeeId(int npcId) {
        this.addEventId(QuestEventType.ON_SKILL_SEE, npcId);
    }

    public void addSkillSeeId(int ... npcIds) {
        this.addEventId(QuestEventType.ON_SKILL_SEE, npcIds);
    }

    public void addSkillSeeId(Collection<Integer> npcIds) {
        this.addEventId(QuestEventType.ON_SKILL_SEE, npcIds);
    }

    public void addSpellFinishedId(int npcId) {
        this.addEventId(QuestEventType.ON_SPELL_FINISHED, npcId);
    }

    public void addSpellFinishedId(int ... npcIds) {
        this.addEventId(QuestEventType.ON_SPELL_FINISHED, npcIds);
    }

    public void addSpellFinishedId(Collection<Integer> npcIds) {
        this.addEventId(QuestEventType.ON_SPELL_FINISHED, npcIds);
    }

    public void addTrapActionId(int npcId) {
        this.addEventId(QuestEventType.ON_TRAP_ACTION, npcId);
    }

    public void addTrapActionId(int ... npcIds) {
        this.addEventId(QuestEventType.ON_TRAP_ACTION, npcIds);
    }

    public void addTrapActionId(Collection<Integer> npcIds) {
        this.addEventId(QuestEventType.ON_TRAP_ACTION, npcIds);
    }

    public void addFactionCallId(int npcId) {
        this.addEventId(QuestEventType.ON_FACTION_CALL, npcId);
    }

    public void addFactionCallId(int ... npcIds) {
        this.addEventId(QuestEventType.ON_FACTION_CALL, npcIds);
    }

    public void addFactionCallId(Collection<Integer> npcIds) {
        this.addEventId(QuestEventType.ON_FACTION_CALL, npcIds);
    }

    public void addAggroRangeEnterId(int npcId) {
        this.addEventId(QuestEventType.ON_AGGRO_RANGE_ENTER, npcId);
    }

    public void addAggroRangeEnterId(int ... npcIds) {
        this.addEventId(QuestEventType.ON_AGGRO_RANGE_ENTER, npcIds);
    }

    public void addAggroRangeEnterId(Collection<Integer> npcIds) {
        this.addEventId(QuestEventType.ON_AGGRO_RANGE_ENTER, npcIds);
    }

    public void addSeeCreatureId(int npcId) {
        this.addEventId(QuestEventType.ON_SEE_CREATURE, npcId);
    }

    public void addSeeCreatureId(int ... npcIds) {
        this.addEventId(QuestEventType.ON_SEE_CREATURE, npcIds);
    }

    public void addSeeCreatureId(Collection<Integer> npcIds) {
        this.addEventId(QuestEventType.ON_SEE_CREATURE, npcIds);
    }

    public void addEnterZoneId(int zoneId) {
        L2ZoneType zone = ZoneManager.getInstance().getZoneById(zoneId);
        if (zone != null) {
            zone.addQuestEvent(QuestEventType.ON_ENTER_ZONE, this);
        }
    }

    public void addEnterZoneId(int ... zoneIds) {
        for (int zoneId : zoneIds) {
            this.addEnterZoneId(zoneId);
        }
    }

    public void addEnterZoneId(Collection<Integer> zoneIds) {
        for (int zoneId : zoneIds) {
            this.addEnterZoneId(zoneId);
        }
    }

    public void addExitZoneId(int zoneId) {
        L2ZoneType zone = ZoneManager.getInstance().getZoneById(zoneId);
        if (zone != null) {
            zone.addQuestEvent(QuestEventType.ON_EXIT_ZONE, this);
        }
    }

    public void addExitZoneId(int ... zoneIds) {
        for (int zoneId : zoneIds) {
            this.addExitZoneId(zoneId);
        }
    }

    public void addExitZoneId(Collection<Integer> zoneIds) {
        for (int zoneId : zoneIds) {
            this.addExitZoneId(zoneId);
        }
    }

    public void addEventReceivedId(int npcId) {
        this.addEventId(QuestEventType.ON_EVENT_RECEIVED, npcId);
    }

    public void addEventReceivedId(int ... npcIds) {
        this.addEventId(QuestEventType.ON_EVENT_RECEIVED, npcIds);
    }

    public void addEventReceivedId(Collection<Integer> npcIds) {
        this.addEventId(QuestEventType.ON_EVENT_RECEIVED, npcIds);
    }

    public void addMoveFinishedId(int npcId) {
        this.addEventId(QuestEventType.ON_MOVE_FINISHED, npcId);
    }

    public void addMoveFinishedId(int ... npcIds) {
        this.addEventId(QuestEventType.ON_MOVE_FINISHED, npcIds);
    }

    public void addMoveFinishedId(Collection<Integer> npcIds) {
        this.addEventId(QuestEventType.ON_MOVE_FINISHED, npcIds);
    }

    public void addNodeArrivedId(int npcId) {
        this.addEventId(QuestEventType.ON_NODE_ARRIVED, npcId);
    }

    public void addNodeArrivedId(int ... npcIds) {
        this.addEventId(QuestEventType.ON_NODE_ARRIVED, npcIds);
    }

    public void addNodeArrivedId(Collection<Integer> npcIds) {
        this.addEventId(QuestEventType.ON_NODE_ARRIVED, npcIds);
    }

    public void addRouteFinishedId(int npcId) {
        this.addEventId(QuestEventType.ON_ROUTE_FINISHED, npcId);
    }

    public void addRouteFinishedId(int ... npcIds) {
        this.addEventId(QuestEventType.ON_ROUTE_FINISHED, npcIds);
    }

    public void addRouteFinishedId(Collection<Integer> npcIds) {
        this.addEventId(QuestEventType.ON_ROUTE_FINISHED, npcIds);
    }

    public void addNpcHateId(int npcId) {
        this.addEventId(QuestEventType.ON_NPC_HATE, npcId);
    }

    public void addNpcHateId(int ... npcIds) {
        this.addEventId(QuestEventType.ON_NPC_HATE, npcIds);
    }

    public void addNpcHateId(Collection<Integer> npcIds) {
        this.addEventId(QuestEventType.ON_NPC_HATE, npcIds);
    }

    public void addSummonId(int ... npcIds) {
        this.addEventId(QuestEventType.ON_SUMMON, npcIds);
    }

    public void addSummonId(Collection<Integer> npcIds) {
        this.addEventId(QuestEventType.ON_SUMMON, npcIds);
    }

    public L2PcInstance getRandomPartyMember(L2PcInstance player) {
        if (player == null) {
            return null;
        }
        L2Party party = player.getParty();
        if (party == null || party.getMembers().isEmpty()) {
            return player;
        }
        return party.getMembers().get(Rnd.get(party.getMembers().size()));
    }

    public L2PcInstance getRandomPartyMember(L2PcInstance player, String cond) {
        return this.getRandomPartyMember(player, "cond", cond);
    }

    public L2PcInstance getRandomPartyMember(L2PcInstance player, int cond) {
        return this.getRandomPartyMember(player, cond >= 0 && cond <= 20 ? COND_CHACHE[cond] : String.valueOf(cond));
    }

    public L2PcInstance getRandomPartyMember(L2PcInstance player, String var, String value) {
        if (player == null) {
            return null;
        }
        if (var == null) {
            return this.getRandomPartyMember(player);
        }
        QuestState temp = null;
        L2Party party = player.getParty();
        if (party == null || party.getMembers().isEmpty()) {
            temp = player.getQuestState(this.getName());
            if (temp != null && value.equalsIgnoreCase(temp.get(var))) {
                return player;
            }
            return null;
        }
        ArrayList<L2PcInstance> candidates = new ArrayList<L2PcInstance>();
        L2Object target = player.getTarget();
        if (target == null) {
            target = player;
        }
        for (L2PcInstance partyMember : party.getMembers()) {
            if (partyMember == null || (temp = partyMember.getQuestState(this.getName())) == null || !value.equalsIgnoreCase(temp.get(var)) || !partyMember.isInsideRadius(target, 1500, true, false)) continue;
            candidates.add(partyMember);
        }
        if (candidates.isEmpty()) {
            return null;
        }
        return (L2PcInstance)candidates.get(Rnd.get(candidates.size()));
    }

    public L2PcInstance getRandomPartyMemberState(L2PcInstance player, byte state) {
        if (player == null) {
            return null;
        }
        QuestState temp = null;
        L2Party party = player.getParty();
        if (party == null || party.getMembers().isEmpty()) {
            temp = player.getQuestState(this.getName());
            if (temp != null && temp.getState() == state) {
                return player;
            }
            return null;
        }
        ArrayList<L2PcInstance> candidates = new ArrayList<L2PcInstance>();
        L2Object target = player.getTarget();
        if (target == null) {
            target = player;
        }
        for (L2PcInstance partyMember : party.getMembers()) {
            if (partyMember == null || (temp = partyMember.getQuestState(this.getName())) == null || temp.getState() != state || !partyMember.isInsideRadius(target, 1500, true, false)) continue;
            candidates.add(partyMember);
        }
        if (candidates.isEmpty()) {
            return null;
        }
        return (L2PcInstance)candidates.get(Rnd.get(candidates.size()));
    }

    public L2PcInstance getRandomPartyMember(L2PcInstance player, L2Npc npc) {
        if (player == null || !Quest.checkDistanceToTarget(player, npc)) {
            return null;
        }
        L2Party party = player.getParty();
        L2PcInstance luckyPlayer = null;
        if (party == null) {
            if (this.checkPartyMember(player, npc)) {
                luckyPlayer = player;
            }
        } else {
            int highestRoll = 0;
            for (L2PcInstance member : party.getMembers()) {
                int rnd = Quest.getRandom(1000);
                if (rnd <= highestRoll || !this.checkPartyMember(member, npc)) continue;
                highestRoll = rnd;
                luckyPlayer = member;
            }
        }
        if (luckyPlayer != null && Quest.checkDistanceToTarget(luckyPlayer, npc)) {
            return luckyPlayer;
        }
        return null;
    }

    public boolean checkPartyMember(L2PcInstance player, L2Npc npc) {
        return true;
    }

    public QuestState getRandomPartyMemberState(L2PcInstance player, int condition, int playerChance, L2Npc target) {
        if (player == null || playerChance < 1) {
            return null;
        }
        QuestState qs = player.getQuestState(this.getName());
        if (!player.isInParty()) {
            if (!this.checkPartyMemberConditions(qs, condition, target)) {
                return null;
            }
            if (!Quest.checkDistanceToTarget(player, target)) {
                return null;
            }
            return qs;
        }
        ArrayList<QuestState> candidates = new ArrayList<QuestState>();
        if (this.checkPartyMemberConditions(qs, condition, target) && playerChance > 0) {
            for (int i = 0; i < playerChance; ++i) {
                candidates.add(qs);
            }
        }
        for (L2PcInstance member : player.getParty().getMembers()) {
            if (member == player || !this.checkPartyMemberConditions(qs = member.getQuestState(this.getName()), condition, target)) continue;
            candidates.add(qs);
        }
        if (candidates.isEmpty()) {
            return null;
        }
        qs = (QuestState)candidates.get(Quest.getRandom(candidates.size()));
        if (!Quest.checkDistanceToTarget(qs.getPlayer(), target)) {
            return null;
        }
        return qs;
    }

    private boolean checkPartyMemberConditions(QuestState qs, int condition, L2Npc npc) {
        return qs != null && (condition == -1 ? qs.isStarted() : qs.isCond(condition)) && this.checkPartyMember(qs, npc);
    }

    private static boolean checkDistanceToTarget(L2PcInstance player, L2Npc target) {
        return target == null || com.l2jserver.gameserver.util.Util.checkIfInRange(1500, player, target, true);
    }

    public boolean checkPartyMember(QuestState qs, L2Npc npc) {
        return true;
    }

    public static void showOnScreenMsg(L2PcInstance player, String text, int time) {
        player.sendPacket(new ExShowScreenMessage(text, time));
    }

    public static void showOnScreenMsg(L2PcInstance player, NpcStringId npcString, int position, int time, String ... params) {
        player.sendPacket(new ExShowScreenMessage(npcString, position, time, params));
    }

    public static void showOnScreenMsg(L2PcInstance player, SystemMessageId systemMsg, int position, int time, String ... params) {
        player.sendPacket(new ExShowScreenMessage(systemMsg, position, time, params));
    }

    public String showHtmlFile(L2PcInstance player, String filename) {
        return this.showHtmlFile(player, filename, null, !filename.endsWith(".html"));
    }

    public String showHtmlFile(L2PcInstance player, String filename, L2Npc npc) {
        return this.showHtmlFile(player, filename, npc, !filename.endsWith(".html"));
    }

    public String showHtmlFile(L2PcInstance player, String filename, L2Npc npc, boolean questwindow) {
        int questId = this.getId();
        String content = this.getHtm(player.getHtmlPrefix(), filename);
        if (content != null) {
            if (npc != null) {
                content = content.replaceAll("%objectId%", Integer.toString(npc.getObjectId()));
            }
            if (questwindow && this.isQuests() && questId != 999) {
                NpcQuestHtmlMessage npcReply = new NpcQuestHtmlMessage(npc != null ? npc.getObjectId() : 0, questId);
                npcReply.setHtml(content);
                npcReply.replace((CharSequence)"%playername%", player.getName());
                player.sendPacket(npcReply);
            } else {
                NpcHtmlMessage npcReply = new NpcHtmlMessage(npc != null ? npc.getObjectId() : 0, content);
                npcReply.replace((CharSequence)"%playername%", player.getName());
                player.sendPacket(npcReply);
            }
            player.sendPacket(ActionFailed.STATIC_PACKET);
        }
        return content;
    }

    public String getHtm(String prefix, String fileName) {
        HtmCache hc = HtmCache.getInstance();
        String content = hc.getHtm(prefix, fileName.startsWith("data/") ? fileName : "data/scripts/" + this.getDescr().toLowerCase() + "/" + this.getName() + "/" + fileName);
        if (content == null && (content = hc.getHtm(prefix, "data/scripts/" + this.getDescr() + "/" + this.getName() + "/" + fileName)) == null) {
            content = hc.getHtmForce(prefix, "data/scripts/quests/" + this.getName() + "/" + fileName);
        }
        return content;
    }

    public static L2Npc addSpawn(int npcId, ILocational pos) {
        return Quest.addSpawn(npcId, pos.getX(), pos.getY(), pos.getZ(), pos.getHeading(), false, 0L, false, 0);
    }

    public static L2Npc addSpawn(int npcId, ILocational pos, boolean isSummonSpawn) {
        return Quest.addSpawn(npcId, pos.getX(), pos.getY(), pos.getZ(), pos.getHeading(), false, 0L, isSummonSpawn, 0);
    }

    public static L2Npc addSpawn(int npcId, ILocational pos, boolean randomOffset, long despawnDelay) {
        return Quest.addSpawn(npcId, pos.getX(), pos.getY(), pos.getZ(), pos.getHeading(), randomOffset, despawnDelay, false, 0);
    }

    public static L2Npc addSpawn(int npcId, ILocational pos, boolean randomOffset, long despawnDelay, boolean isSummonSpawn) {
        return Quest.addSpawn(npcId, pos.getX(), pos.getY(), pos.getZ(), pos.getHeading(), randomOffset, despawnDelay, isSummonSpawn, 0);
    }

    public static L2Npc addSpawn(int npcId, ILocational pos, boolean randomOffset, long despawnDelay, boolean isSummonSpawn, int instanceId) {
        return Quest.addSpawn(npcId, pos.getX(), pos.getY(), pos.getZ(), pos.getHeading(), randomOffset, despawnDelay, isSummonSpawn, instanceId);
    }

    public static L2Npc addSpawn(int npcId, int x, int y, int z, int heading, boolean randomOffset, long despawnDelay) {
        return Quest.addSpawn(npcId, x, y, z, heading, randomOffset, despawnDelay, false, 0);
    }

    public static L2Npc addSpawn(int npcId, int x, int y, int z, int heading, boolean randomOffset, long despawnDelay, boolean isSummonSpawn) {
        return Quest.addSpawn(npcId, x, y, z, heading, randomOffset, despawnDelay, isSummonSpawn, 0);
    }

    public static L2Npc addSpawn(int npcId, int x, int y, int z, int heading, boolean randomOffset, long despawnDelay, boolean isSummonSpawn, int instanceId) {
        block6: {
            try {
                L2NpcTemplate template = NpcData.getInstance().getTemplate(npcId);
                if (template == null) {
                    _log.log(Level.SEVERE, "addSpawn(): no NPC template found for NPC #" + npcId + "!");
                    break block6;
                }
                if (x == 0 && y == 0) {
                    _log.log(Level.SEVERE, "addSpawn(): invalid spawn coordinates for NPC #" + npcId + "!");
                    break block6;
                }
                if (randomOffset) {
                    double radius = 50.0 + 50.0 * Rnd.nextDouble();
                    double angle = Math.PI * 2 * Rnd.nextDouble();
                    x = (int)((double)x + radius * Math.cos(angle));
                    y = (int)((double)y + radius * Math.sin(angle));
                }
                L2Spawn spawn = new L2Spawn(template);
                spawn.setInstanceId(instanceId);
                spawn.setHeading(heading);
                spawn.setX(x);
                spawn.setY(y);
                spawn.setZ(z);
                spawn.stopRespawn();
                L2Npc result = spawn.spawnOne(isSummonSpawn);
                if (despawnDelay > 0L) {
                    result.scheduleDespawn(despawnDelay);
                }
                return result;
            }
            catch (Exception e1) {
                _log.warning("Could not spawn NPC #" + npcId + "; error: " + e1.getMessage());
            }
        }
        return null;
    }

    public L2TrapInstance addTrap(int trapId, int x, int y, int z, int heading, Skill skill, int instanceId) {
        L2NpcTemplate npcTemplate = NpcData.getInstance().getTemplate(trapId);
        L2TrapInstance trap = new L2TrapInstance(IdFactory.getInstance().getNextId(), npcTemplate, instanceId, -1);
        trap.setCurrentHp(trap.getMaxHp());
        trap.setCurrentMp(trap.getMaxMp());
        trap.setIsInvul(true);
        trap.setHeading(heading);
        trap.spawnMe(x, y, z);
        return trap;
    }

    public L2Npc addMinion(L2MonsterInstance master, int minionId) {
        return MinionList.spawnMinion(master, minionId);
    }

    public int[] getRegisteredItemIds() {
        return this.questItemIds;
    }

    public void registerQuestItems(int ... items) {
        this.questItemIds = items;
    }

    @Override
    public String getScriptName() {
        return this.getName();
    }

    @Override
    public void setActive(boolean status) {
    }

    @Override
    public boolean reload() {
        this.unload();
        return super.reload();
    }

    @Override
    public boolean unload() {
        return this.unload(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancelAllQuestTimers() {
        for (List timers : this._allEventTimers.values()) {
            this._readLock.lock();
            try {
                for (QuestTimer timer : timers) {
                    timer.cancel();
                }
            }
            finally {
                this._readLock.unlock();
            }
            timers.clear();
        }
        this._allEventTimers.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unload(boolean removeFromList) {
        this.saveGlobalData();
        for (List timers : this._allEventTimers.values()) {
            this._readLock.lock();
            try {
                for (QuestTimer timer : timers) {
                    timer.cancel();
                }
            }
            finally {
                this._readLock.unlock();
            }
            timers.clear();
        }
        this._allEventTimers.clear();
        TIntIterator npcId = this._questInvolvedNpcs.iterator();
        while (npcId.hasNext()) {
            L2NpcTemplate template = NpcData.getInstance().getTemplate(npcId.next());
            if (template == null) continue;
            template.removeQuest(this);
        }
        this._questInvolvedNpcs.clear();
        if (removeFromList) {
            return QuestManager.getInstance().removeScript(this);
        }
        return true;
    }

    public int[] getQuestInvolvedNpcs() {
        return this._questInvolvedNpcs.toArray();
    }

    @Override
    public ScriptManager<?> getScriptManager() {
        return QuestManager.getInstance();
    }

    public void setOnEnterWorld(boolean val) {
        this._onEnterWorld = val;
    }

    public boolean getOnEnterWorld() {
        return this._onEnterWorld;
    }

    public void setOlympiadUse(boolean val) {
        this._isOlympiadUse = val;
    }

    public boolean isOlympiadUse() {
        return this._isOlympiadUse;
    }

    public static long getQuestItemsCount(L2PcInstance player, int itemId) {
        return player.getInventory().getInventoryItemCount(itemId, -1);
    }

    public long getQuestItemsCount(L2PcInstance player, int ... itemIds) {
        long count = 0L;
        for (L2ItemInstance item : player.getInventory().getItems()) {
            if (item == null) continue;
            for (int itemId : itemIds) {
                if (item.getId() != itemId) continue;
                if (count + item.getCount() > Long.MAX_VALUE) {
                    return Long.MAX_VALUE;
                }
                count += item.getCount();
            }
        }
        return count;
    }

    protected static boolean hasItem(L2PcInstance player, ItemHolder item) {
        return Quest.hasItem(player, item, true);
    }

    protected static boolean hasItem(L2PcInstance player, ItemHolder item, boolean checkCount) {
        if (item == null) {
            return false;
        }
        if (checkCount) {
            return Quest.getQuestItemsCount(player, item.getId()) >= item.getCount();
        }
        return Quest.hasQuestItems(player, item.getId());
    }

    protected static boolean hasAllItems(L2PcInstance player, boolean checkCount, ItemHolder ... itemList) {
        if (itemList == null || itemList.length == 0) {
            return false;
        }
        for (ItemHolder item : itemList) {
            if (Quest.hasItem(player, item, checkCount)) continue;
            return false;
        }
        return true;
    }

    public static boolean hasQuestItems(L2PcInstance player, int itemId) {
        return player.getInventory().getItemByItemId(itemId) != null;
    }

    public static boolean hasQuestItems(L2PcInstance player, int ... itemIds) {
        if (itemIds == null || itemIds.length == 0) {
            return false;
        }
        PcInventory inv = player.getInventory();
        for (int itemId : itemIds) {
            if (inv.getItemByItemId(itemId) != null) continue;
            return false;
        }
        return true;
    }

    public boolean hasAtLeastOneQuestItem(L2PcInstance player, int ... itemIds) {
        PcInventory inv = player.getInventory();
        for (int itemId : itemIds) {
            if (inv.getItemByItemId(itemId) == null) continue;
            return true;
        }
        return false;
    }

    public static int getEnchantLevel(L2PcInstance player, int itemId) {
        L2ItemInstance enchantedItem = player.getInventory().getItemByItemId(itemId);
        if (enchantedItem == null) {
            return 0;
        }
        return enchantedItem.getEnchantLevel();
    }

    public void giveAdena(L2PcInstance player, long count, boolean applyRates) {
        if (applyRates) {
            Quest.rewardItems(player, 57, count);
        } else {
            Quest.giveItems(player, 57, count);
        }
    }

    public static void rewardItems(L2PcInstance player, ItemHolder holder) {
        Quest.rewardItems(player, holder.getId(), holder.getCount());
    }

    public static void rewardItems(L2PcInstance player, int itemId, long count) {
        if (count <= 0L) {
            return;
        }
        L2ItemInstance _tmpItem = ItemTable.getInstance().createDummyItem(itemId);
        if (_tmpItem == null) {
            return;
        }
        try {
            if (itemId == 57) {
                count = (long)((float)count * Config.RATE_QUEST_REWARD_ADENA);
            } else if (Config.RATE_QUEST_REWARD_USE_MULTIPLIERS) {
                if (_tmpItem.isEtcItem()) {
                    switch (_tmpItem.getEtcItem().getItemType()) {
                        case POTION: {
                            count = (long)((float)count * Config.RATE_QUEST_REWARD_POTION);
                            break;
                        }
                        case SCRL_ENCHANT_WP: 
                        case SCRL_ENCHANT_AM: 
                        case SCROLL: {
                            count = (long)((float)count * Config.RATE_QUEST_REWARD_SCROLL);
                            break;
                        }
                        case RECIPE: {
                            count = (long)((float)count * Config.RATE_QUEST_REWARD_RECIPE);
                            break;
                        }
                        case MATERIAL: {
                            count = (long)((float)count * Config.RATE_QUEST_REWARD_MATERIAL);
                            break;
                        }
                        default: {
                            count = (long)((float)count * Config.RATE_QUEST_REWARD);
                            break;
                        }
                    }
                }
            } else {
                count = (long)((float)count * Config.RATE_QUEST_REWARD);
            }
        }
        catch (Exception e) {
            count = Long.MAX_VALUE;
        }
        L2ItemInstance item = player.getInventory().addItem("Quest", itemId, count, player, player.getTarget());
        if (item == null) {
            return;
        }
        Quest.sendItemGetMessage(player, item, count);
    }

    private static void sendItemGetMessage(L2PcInstance player, L2ItemInstance item, long count) {
        SystemMessage smsg;
        if (item.getId() == 57) {
            smsg = SystemMessage.getSystemMessage(SystemMessageId.EARNED_S1_ADENA);
            smsg.addItemNumber(count);
            player.sendPacket(smsg);
        } else if (count > 1L) {
            smsg = SystemMessage.getSystemMessage(SystemMessageId.EARNED_S2_S1_S);
            smsg.addItemName(item);
            smsg.addItemNumber(count);
            player.sendPacket(smsg);
        } else {
            smsg = SystemMessage.getSystemMessage(SystemMessageId.EARNED_ITEM_S1);
            smsg.addItemName(item);
            player.sendPacket(smsg);
        }
        StatusUpdate su = new StatusUpdate(player);
        su.addAttribute(14, player.getCurrentLoad());
        player.sendPacket(su);
    }

    public static void giveItems(L2PcInstance player, int itemId, long count) {
        Quest.giveItems(player, itemId, count, 0);
    }

    protected static void giveItems(L2PcInstance player, ItemHolder holder) {
        Quest.giveItems(player, holder.getId(), holder.getCount());
    }

    public static void giveItems(L2PcInstance player, int itemId, long count, int enchantlevel) {
        if (count <= 0L) {
            return;
        }
        L2ItemInstance item = player.getInventory().addItem("Quest", itemId, count, player, player.getTarget());
        if (item == null) {
            return;
        }
        if (enchantlevel > 0 && itemId != 57) {
            item.setEnchantLevel(enchantlevel);
        }
        Quest.sendItemGetMessage(player, item, count);
    }

    public static void giveItems(L2PcInstance player, int itemId, long count, byte attributeId, int attributeLevel) {
        if (count <= 0L) {
            return;
        }
        L2ItemInstance item = player.getInventory().addItem("Quest", itemId, count, player, player.getTarget());
        if (item == null) {
            return;
        }
        if (attributeId >= 0 && attributeLevel > 0) {
            item.setElementAttr(attributeId, attributeLevel);
            if (item.isEquipped()) {
                item.updateElementAttrBonus(player);
            }
            InventoryUpdate iu = new InventoryUpdate();
            iu.addModifiedItem(item);
            player.sendPacket(iu);
        }
        Quest.sendItemGetMessage(player, item, count);
    }

    public static boolean giveItemRandomly(L2PcInstance player, int itemId, long amountToGive, long limit, double dropChance, boolean playSound) {
        return Quest.giveItemRandomly(player, null, itemId, amountToGive, amountToGive, limit, dropChance, playSound);
    }

    public static boolean giveItemRandomly(L2PcInstance player, L2Npc npc, int itemId, long amountToGive, long limit, double dropChance, boolean playSound) {
        return Quest.giveItemRandomly(player, npc, itemId, amountToGive, amountToGive, limit, dropChance, playSound);
    }

    public static boolean giveItemRandomly(L2PcInstance player, L2Npc npc, int itemId, long minAmount, long maxAmount, long limit, double dropChance, boolean playSound) {
        long currentCount = Quest.getQuestItemsCount(player, itemId);
        if (limit > 0L && currentCount >= limit) {
            return true;
        }
        minAmount = (long)((float)minAmount * Config.RATE_QUEST_DROP);
        maxAmount = (long)((float)maxAmount * Config.RATE_QUEST_DROP);
        dropChance *= (double)Config.RATE_QUEST_DROP;
        if (npc != null && Config.L2JMOD_CHAMPION_ENABLE && npc.isChampion()) {
            dropChance *= (double)Config.L2JMOD_CHAMPION_REWARDS;
            if (itemId == 57 || itemId == 5575) {
                minAmount = (long)((float)minAmount * Config.L2JMOD_CHAMPION_ADENAS_REWARDS);
                maxAmount = (long)((float)maxAmount * Config.L2JMOD_CHAMPION_ADENAS_REWARDS);
            } else {
                minAmount *= (long)Config.L2JMOD_CHAMPION_REWARDS;
                maxAmount *= (long)Config.L2JMOD_CHAMPION_REWARDS;
            }
        }
        long amountToGive = minAmount == maxAmount ? minAmount : Rnd.get(minAmount, maxAmount);
        double random = Rnd.nextDouble();
        if (dropChance >= random && amountToGive > 0L && player.getInventory().validateCapacityByItemId(itemId)) {
            L2ItemInstance item;
            if (limit > 0L && currentCount + amountToGive > limit) {
                amountToGive = limit - currentCount;
            }
            if ((item = player.addItem("Quest", itemId, amountToGive, npc, true)) != null) {
                if (currentCount + amountToGive == limit) {
                    if (playSound) {
                        Quest.playSound(player, QuestSound.ITEMSOUND_QUEST_MIDDLE);
                    }
                    return true;
                }
                if (playSound) {
                    Quest.playSound(player, QuestSound.ITEMSOUND_QUEST_ITEMGET);
                }
                if (limit <= 0L) {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean takeItems(L2PcInstance player, int itemId, long amount) {
        L2ItemInstance item = player.getInventory().getItemByItemId(itemId);
        if (item == null) {
            if (itemId == -1) {
                _log.log(Level.WARNING, "takeItems(player," + itemId + "," + amount + ")");
            }
            return false;
        }
        if (amount < 0L || amount > item.getCount()) {
            amount = item.getCount();
        }
        if (item.isEquipped()) {
            L2ItemInstance[] unequiped = player.getInventory().unEquipItemInBodySlotAndRecord(item.getItem().getBodyPart());
            InventoryUpdate iu = new InventoryUpdate();
            for (L2ItemInstance itm : unequiped) {
                iu.addModifiedItem(itm);
            }
            player.sendPacket(iu);
            player.broadcastUserInfo();
        }
        return player.destroyItemByItemId("Quest", itemId, amount, player, true);
    }

    protected static boolean takeItem(L2PcInstance player, ItemHolder holder) {
        if (holder == null) {
            return false;
        }
        return Quest.takeItems(player, holder.getId(), holder.getCount());
    }

    protected static boolean takeAllItems(L2PcInstance player, ItemHolder ... itemList) {
        if (itemList == null || itemList.length == 0) {
            return false;
        }
        if (!Quest.hasAllItems(player, true, itemList)) {
            return false;
        }
        for (ItemHolder item : itemList) {
            if (Quest.takeItem(player, item)) continue;
            return false;
        }
        return true;
    }

    public static boolean takeItems(L2PcInstance player, int amount, int ... itemIds) {
        if (amount != -1) {
            StringBuilder sb = new StringBuilder(256).append("takeItems(player,").append(amount);
            if (itemIds == null) {
                sb.append("NULL");
            } else {
                for (int item : itemIds) {
                    sb.append(',').append(item);
                }
            }
            sb.append(')');
            _log.log(Level.WARNING, sb.toString());
        }
        boolean check = true;
        if (itemIds != null) {
            for (int item : itemIds) {
                check &= Quest.takeItems(player, item, (long)amount);
            }
        }
        return check;
    }

    public void removeRegisteredQuestItems(L2PcInstance player) {
        Quest.takeItems(player, -1, this.questItemIds);
    }

    public static void playSound(L2PcInstance player, String sound) {
        player.sendPacket(QuestSound.getSound(sound));
    }

    public static void playSound(L2PcInstance player, QuestSound sound) {
        player.sendPacket(sound.getPacket());
    }

    public static void addExpAndSp(L2PcInstance player, long exp, int sp) {
        player.addExpAndSp((long)player.calcStat(Stats.EXPSP_RATE, (float)exp * Config.RATE_QUEST_REWARD_XP, null, null), (int)player.calcStat(Stats.EXPSP_RATE, (float)sp * Config.RATE_QUEST_REWARD_SP, null, null));
    }

    public static int getRandom(int max) {
        return Rnd.get(max);
    }

    public static int getRandom(int min, int max) {
        return Rnd.get(min, max);
    }

    public static boolean getRandomBoolean() {
        return Rnd.nextBoolean();
    }

    public static int getItemEquipped(L2PcInstance player, int slot) {
        return player.getInventory().getPaperdollItemId(slot);
    }

    public static int getGameTicks() {
        return GameTimeController.getInstance().getGameTicks();
    }

    public final void executeForEachPlayer(L2PcInstance player, final L2Npc npc, final boolean isSummon, boolean includeParty, boolean includeCommandChannel) {
        if ((includeParty || includeCommandChannel) && player.isInParty()) {
            if (includeCommandChannel && player.getParty().isInCommandChannel()) {
                player.getParty().getCommandChannel().forEachMember(new IProcedure<L2PcInstance, Boolean>(){

                    public boolean execute(L2PcInstance member) {
                        Quest.this.actionForEachPlayer(member, npc, isSummon);
                        return true;
                    }
                });
            } else if (includeParty) {
                player.getParty().forEachMember(new IProcedure<L2PcInstance, Boolean>(){

                    public boolean execute(L2PcInstance member) {
                        Quest.this.actionForEachPlayer(member, npc, isSummon);
                        return true;
                    }
                });
            }
        } else {
            this.actionForEachPlayer(player, npc, isSummon);
        }
    }

    public void actionForEachPlayer(L2PcInstance player, L2Npc npc, boolean isSummon) {
    }

    public void openDoor(int doorId, int instanceId) {
        L2DoorInstance door = this.getDoor(doorId, instanceId);
        if (door == null) {
            _log.log(Level.WARNING, this.getClass().getSimpleName() + ": called openDoor(" + doorId + ", " + instanceId + "); but door wasnt found!", new NullPointerException());
        } else if (!door.getOpen()) {
            door.openMe();
        }
    }

    public void closeDoor(int doorId, int instanceId) {
        L2DoorInstance door = this.getDoor(doorId, instanceId);
        if (door == null) {
            _log.log(Level.WARNING, this.getClass().getSimpleName() + ": called closeDoor(" + doorId + ", " + instanceId + "); but door wasnt found!", new NullPointerException());
        } else if (door.getOpen()) {
            door.closeMe();
        }
    }

    public L2DoorInstance getDoor(int doorId, int instanceId) {
        L2DoorInstance door = null;
        if (instanceId <= 0) {
            door = DoorTable.getInstance().getDoor(doorId);
        } else {
            Instance inst = InstanceManager.getInstance().getInstance(instanceId);
            if (inst != null) {
                door = inst.getDoor(doorId);
            }
        }
        return door;
    }

    public void teleportPlayer(L2PcInstance player, Location loc, int instanceId) {
        this.teleportPlayer(player, loc, instanceId, true);
    }

    public void teleportPlayer(L2PcInstance player, Location loc, int instanceId, boolean allowRandomOffset) {
        loc.setInstanceId(instanceId);
        player.teleToLocation((ILocational)loc, allowRandomOffset);
    }

    public static enum Repeating {
        None,
        AtFixedRate,
        WithFixedDelay;

    }
}

