/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.stats;

import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2CubicInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.skills.Skill;

public final class Env {
    private double _baseValue;
    private boolean _blessedSpiritShot = false;
    private L2Character _character;
    private L2CubicInstance _cubic;
    private L2ItemInstance _item;
    private byte _shield = 0;
    private Skill _skill;
    private boolean _skillMastery = false;
    private boolean _soulShot = false;
    private boolean _spiritShot = false;
    private L2Character _target;
    private double _value;

    public Env() {
    }

    public Env(byte shield, boolean soulShot, boolean spiritShot, boolean blessedSpiritShot) {
        this._shield = shield;
        this._soulShot = soulShot;
        this._spiritShot = spiritShot;
        this._blessedSpiritShot = blessedSpiritShot;
    }

    public double getBaseValue() {
        return this._baseValue;
    }

    public L2Character getCharacter() {
        return this._character;
    }

    public L2CubicInstance getCubic() {
        return this._cubic;
    }

    public L2ItemInstance getItem() {
        return this._item;
    }

    public L2PcInstance getPlayer() {
        return this._character == null ? null : this._character.getActingPlayer();
    }

    public byte getShield() {
        return this._shield;
    }

    public Skill getSkill() {
        return this._skill;
    }

    public L2Character getTarget() {
        return this._target;
    }

    public double getValue() {
        return this._value;
    }

    public boolean isBlessedSpiritShot() {
        return this._blessedSpiritShot;
    }

    public boolean isSkillMastery() {
        return this._skillMastery;
    }

    public boolean isSoulShot() {
        return this._soulShot;
    }

    public boolean isSpiritShot() {
        return this._spiritShot;
    }

    public void setBaseValue(double baseValue) {
        this._baseValue = baseValue;
    }

    public void setBlessedSpiritShot(boolean blessedSpiritShot) {
        this._blessedSpiritShot = blessedSpiritShot;
    }

    public void setCharacter(L2Character character) {
        this._character = character;
    }

    public void setCubic(L2CubicInstance cubic) {
        this._cubic = cubic;
    }

    public void setItem(L2ItemInstance item) {
        this._item = item;
    }

    public void setShield(byte shield) {
        this._shield = shield;
    }

    public void setSkill(Skill skill) {
        this._skill = skill;
    }

    public void setSkillMastery(boolean skillMastery) {
        this._skillMastery = skillMastery;
    }

    public void setSoulShot(boolean soulShot) {
        this._soulShot = soulShot;
    }

    public void setSpiritShot(boolean spiritShot) {
        this._spiritShot = spiritShot;
    }

    public void setTarget(L2Character target) {
        this._target = target;
    }

    public void setValue(double value) {
        this._value = value;
    }

    public void addValue(double value) {
        this._value += value;
    }

    public void subValue(double value) {
        this._value -= value;
    }

    public void mulValue(double value) {
        this._value *= value;
    }

    public void divValue(double value) {
        this._value /= value;
    }
}

