/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.CharNameTable;
import com.l2jserver.gameserver.datatables.CharTemplateTable;
import com.l2jserver.gameserver.datatables.InitialShortcutData;
import com.l2jserver.gameserver.datatables.SkillData;
import com.l2jserver.gameserver.datatables.SkillTreesData;
import com.l2jserver.gameserver.instancemanager.QuestManager;
import com.l2jserver.gameserver.model.L2SkillLearn;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.actor.appearance.PcAppearance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.stat.PcStat;
import com.l2jserver.gameserver.model.actor.templates.L2PcTemplate;
import com.l2jserver.gameserver.model.base.ClassId;
import com.l2jserver.gameserver.model.items.PcItemTemplate;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.model.quest.QuestState;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.CharCreateFail;
import com.l2jserver.gameserver.network.serverpackets.CharCreateOk;
import com.l2jserver.gameserver.network.serverpackets.CharSelectionInfo;
import com.l2jserver.gameserver.scripting.scriptengine.events.PlayerEvent;
import com.l2jserver.gameserver.scripting.scriptengine.listeners.player.PlayerListener;
import com.l2jserver.gameserver.util.Util;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javolution.util.FastList;

public final class CharacterCreate
extends L2GameClientPacket {
    private static final String _C__0C_CHARACTERCREATE = "[C] 0C CharacterCreate";
    protected static final Logger _logAccounting = Logger.getLogger("accounting");
    private static final List<PlayerListener> _listeners = new FastList().shared();
    private String _name;
    private int _race;
    private byte _sex;
    private int _classId;
    private int _int;
    private int _str;
    private int _con;
    private int _men;
    private int _dex;
    private int _wit;
    private byte _hairStyle;
    private byte _hairColor;
    private byte _face;

    @Override
    protected void readImpl() {
        this._name = this.readS();
        this._race = this.readD();
        this._sex = (byte)this.readD();
        this._classId = this.readD();
        this._int = this.readD();
        this._str = this.readD();
        this._con = this.readD();
        this._men = this.readD();
        this._dex = this.readD();
        this._wit = this.readD();
        this._hairStyle = (byte)this.readD();
        this._hairColor = (byte)this.readD();
        this._face = (byte)this.readD();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void runImpl() {
        if (this._name.length() < 1 || this._name.length() > 16) {
            if (Config.DEBUG) {
                _log.fine("Character Creation Failure: Character name " + this._name + " is invalid. Message generated: Your title cannot exceed 16 characters in length. Please try again.");
            }
            this.sendPacket(new CharCreateFail(3));
            return;
        }
        if (Config.FORBIDDEN_NAMES.length > 1) {
            for (String st : Config.FORBIDDEN_NAMES) {
                if (!this._name.toLowerCase().contains(st.toLowerCase())) continue;
                this.sendPacket(new CharCreateFail(4));
                return;
            }
        }
        if (!Util.isAlphaNumeric(this._name) || !this.isValidName(this._name)) {
            if (Config.DEBUG) {
                _log.fine("Character Creation Failure: Character name " + this._name + " is invalid. Message generated: Incorrect name. Please try again.");
            }
            this.sendPacket(new CharCreateFail(4));
            return;
        }
        if (this._face > 2 || this._face < 0) {
            _log.warning("Character Creation Failure: Character face " + this._face + " is invalid. Possible client hack. " + this.getClient());
            this.sendPacket(new CharCreateFail(0));
            return;
        }
        if (this._hairStyle < 0 || this._sex == 0 && this._hairStyle > 4 || this._sex != 0 && this._hairStyle > 6) {
            _log.warning("Character Creation Failure: Character hair style " + this._hairStyle + " is invalid. Possible client hack. " + this.getClient());
            this.sendPacket(new CharCreateFail(0));
            return;
        }
        if (this._hairColor > 3 || this._hairColor < 0) {
            _log.warning("Character Creation Failure: Character hair color " + this._hairColor + " is invalid. Possible client hack. " + this.getClient());
            this.sendPacket(new CharCreateFail(0));
            return;
        }
        L2PcInstance newChar = null;
        L2PcTemplate template = null;
        CharNameTable i$ = CharNameTable.getInstance();
        synchronized (i$) {
            if (CharNameTable.getInstance().accountCharNumber(((L2GameClient)this.getClient()).getAccountName()) >= Config.MAX_CHARACTERS_NUMBER_PER_ACCOUNT && Config.MAX_CHARACTERS_NUMBER_PER_ACCOUNT != 0) {
                if (Config.DEBUG) {
                    _log.fine("Max number of characters reached. Creation failed.");
                }
                this.sendPacket(new CharCreateFail(1));
                return;
            }
            if (CharNameTable.getInstance().doesCharNameExist(this._name)) {
                if (Config.DEBUG) {
                    _log.fine("Character Creation Failure: Message generated: You cannot create another character. Please delete the existing character and try again.");
                }
                this.sendPacket(new CharCreateFail(2));
                return;
            }
            template = CharTemplateTable.getInstance().getTemplate(this._classId);
            if (template == null || ClassId.getClassId(this._classId).level() > 0) {
                if (Config.DEBUG) {
                    _log.fine("Character Creation Failure: " + this._name + " classId: " + this._classId + " Template: " + template + " Message generated: Your character creation has failed.");
                }
                this.sendPacket(new CharCreateFail(0));
                return;
            }
            PcAppearance app = new PcAppearance(this._face, this._hairColor, this._hairStyle, this._sex != 0);
            newChar = L2PcInstance.create(template, ((L2GameClient)this.getClient()).getAccountName(), this._name, app);
        }
        newChar.setCurrentHp(newChar.getMaxHp());
        newChar.setCurrentMp(newChar.getMaxMp());
        this.sendPacket(new CharCreateOk());
        this.initNewChar((L2GameClient)this.getClient(), newChar);
        LogRecord record = new LogRecord(Level.INFO, "Created new character");
        record.setParameters(new Object[]{newChar, this.getClient()});
        _logAccounting.log(record);
    }

    private boolean isValidName(String text) {
        Pattern pattern;
        boolean result = true;
        String test = text;
        try {
            pattern = Pattern.compile(Config.CNAME_TEMPLATE);
        }
        catch (PatternSyntaxException e) {
            _log.warning("ERROR : Character name pattern of config is wrong!");
            pattern = Pattern.compile(".*");
        }
        Matcher regexp = pattern.matcher(test);
        if (!regexp.matches()) {
            result = false;
        }
        return result;
    }

    private void initNewChar(L2GameClient client, L2PcInstance newChar) {
        if (Config.DEBUG) {
            _log.fine("Character init start");
        }
        L2World.getInstance().storeObject(newChar);
        if (Config.STARTING_ADENA > 0L) {
            newChar.addAdena("Init", Config.STARTING_ADENA, null, false);
        }
        L2PcTemplate template = newChar.getTemplate();
        Location createLoc = template.getCreationPoint();
        newChar.setXYZInvisible(createLoc.getX(), createLoc.getY(), createLoc.getZ());
        newChar.setTitle("");
        if (Config.ENABLE_VITALITY) {
            newChar.setVitalityPoints(Math.min(Config.STARTING_VITALITY_POINTS, PcStat.MAX_VITALITY_POINTS), true);
        }
        if (Config.STARTING_LEVEL > 1) {
            newChar.getStat().addLevel((byte)(Config.STARTING_LEVEL - 1));
        }
        if (Config.STARTING_SP > 0) {
            newChar.getStat().addSp(Config.STARTING_SP);
        }
        if (template.hasInitialEquipment()) {
            for (PcItemTemplate ie : template.getInitialEquipment()) {
                L2ItemInstance item = newChar.getInventory().addItem("Init", ie.getId(), ie.getCount(), newChar, null);
                if (item == null) {
                    _log.warning("Could not create item during char creation: itemId " + ie.getId() + ", amount " + ie.getCount() + ".");
                    continue;
                }
                if (!item.isEquipable() || !ie.isEquipped()) continue;
                newChar.getInventory().equipItem(item);
            }
        }
        for (L2SkillLearn skill : SkillTreesData.getInstance().getAvailableSkills(newChar, newChar.getClassId(), false, true)) {
            if (Config.DEBUG) {
                _log.fine("Adding starter skill:" + skill.getSkillId() + " / " + skill.getSkillLevel());
            }
            newChar.addSkill(SkillData.getInstance().getSkill(skill.getSkillId(), skill.getSkillLevel()), true);
        }
        InitialShortcutData.getInstance().registerAllShortcuts(newChar);
        if (!Config.DISABLE_TUTORIAL) {
            this.startTutorialQuest(newChar);
        }
        PlayerEvent event = new PlayerEvent();
        event.setObjectId(newChar.getObjectId());
        event.setName(newChar.getName());
        event.setClient(client);
        this.firePlayerListener(event);
        newChar.setOnlineStatus(true, false);
        newChar.deleteMe();
        CharSelectionInfo cl = new CharSelectionInfo(client.getAccountName(), client.getSessionId().playOkID1);
        client.setCharSelection(cl.getCharInfo());
        if (Config.DEBUG) {
            _log.fine("Character init end");
        }
    }

    public void startTutorialQuest(L2PcInstance player) {
        QuestState qs = player.getQuestState("255_Tutorial");
        Quest q = null;
        if (qs == null) {
            q = QuestManager.getInstance().getQuest("255_Tutorial");
        }
        if (q != null) {
            q.newQuestState(player).setState((byte)1);
        }
    }

    private void firePlayerListener(PlayerEvent event) {
        for (PlayerListener listener : _listeners) {
            listener.onCharCreate(event);
        }
    }

    public static void addPlayerListener(PlayerListener listener) {
        if (!_listeners.contains(listener)) {
            _listeners.add(listener);
        }
    }

    public static void removePlayerListener(PlayerListener listener) {
        _listeners.remove(listener);
    }

    @Override
    public String getType() {
        return _C__0C_CHARACTERCREATE;
    }
}

