/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.datatables.CharNameTable;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.FriendPacket;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.logging.Level;

public final class RequestFriendDel
extends L2GameClientPacket {
    private static final String _C__7A_REQUESTFRIENDDEL = "[C] 7A RequestFriendDel";
    private String _name;

    @Override
    protected void readImpl() {
        this._name = this.readS();
    }

    @Override
    protected void runImpl() {
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null) {
            return;
        }
        int id = CharNameTable.getInstance().getIdByName(this._name);
        if (id == -1) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.C1_NOT_ON_YOUR_FRIENDS_LIST);
            sm.addString(this._name);
            activeChar.sendPacket(sm);
            return;
        }
        if (!activeChar.getFriendList().contains(id)) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.C1_NOT_ON_YOUR_FRIENDS_LIST);
            sm.addString(this._name);
            activeChar.sendPacket(sm);
            return;
        }
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement statement = con.prepareStatement("DELETE FROM character_friends WHERE (charId=? AND friendId=?) OR (charId=? AND friendId=?)");){
            statement.setInt(1, activeChar.getObjectId());
            statement.setInt(2, id);
            statement.setInt(3, id);
            statement.setInt(4, activeChar.getObjectId());
            statement.execute();
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_HAS_BEEN_DELETED_FROM_YOUR_FRIENDS_LIST);
            sm.addString(this._name);
            activeChar.sendPacket(sm);
            activeChar.getFriendList().remove((Object)id);
            activeChar.sendPacket(new FriendPacket(false, id));
            L2PcInstance player = L2World.getInstance().getPlayer(this._name);
            if (player != null) {
                player.getFriendList().remove((Object)activeChar.getObjectId());
                player.sendPacket(new FriendPacket(false, activeChar.getObjectId()));
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "could not del friend objectid: ", e);
        }
    }

    @Override
    public String getType() {
        return _C__7A_REQUESTFRIENDDEL;
    }
}

