/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.util.Util;

public final class RequestLinkHtml
extends L2GameClientPacket {
    private static final String _C__22_REQUESTLINKHTML = "[C] 22 RequestLinkHtml";
    private String _link;

    @Override
    protected void readImpl() {
        this._link = this.readS();
    }

    @Override
    public void runImpl() {
        L2PcInstance actor = ((L2GameClient)this.getClient()).getActiveChar();
        if (actor == null) {
            return;
        }
        if (this._link.isEmpty()) {
            _log.warning("Player " + actor.getName() + " sent empty html link!");
            return;
        }
        if (this._link.contains("..")) {
            _log.warning("Player " + actor.getName() + " sent invalid html link: link " + this._link);
            return;
        }
        int htmlObjectId = actor.validateHtmlAction("link " + this._link);
        if (htmlObjectId == -1) {
            _log.warning("Player " + actor.getName() + " sent non cached  html link: link " + this._link);
            return;
        }
        if (htmlObjectId > 0 && !Util.isInsideRangeOfObjectId(actor, htmlObjectId, 150)) {
            return;
        }
        String filename = "data/html/" + this._link;
        NpcHtmlMessage msg = new NpcHtmlMessage(htmlObjectId);
        msg.setFile(actor.getHtmlPrefix(), filename);
        this.sendPacket(msg);
    }

    @Override
    public String getType() {
        return _C__22_REQUESTLINKHTML;
    }
}

