/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.model.PartyMatchRoom;
import com.l2jserver.gameserver.model.PartyMatchRoomList;
import com.l2jserver.gameserver.model.PartyMatchWaitingList;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.ExPartyRoomMember;
import com.l2jserver.gameserver.network.serverpackets.ListPartyWating;
import com.l2jserver.gameserver.network.serverpackets.PartyMatchDetail;

public final class RequestPartyMatchConfig
extends L2GameClientPacket {
    private static final String _C__7F_REQUESTPARTYMATCHCONFIG = "[C] 7F RequestPartyMatchConfig";
    private int _auto;
    private int _loc;
    private int _lvl;

    @Override
    protected void readImpl() {
        this._auto = this.readD();
        this._loc = this.readD();
        this._lvl = this.readD();
    }

    @Override
    protected void runImpl() {
        L2PcInstance _activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (_activeChar == null) {
            return;
        }
        if (!_activeChar.isInPartyMatchRoom() && _activeChar.getParty() != null && _activeChar.getParty().getLeader() != _activeChar) {
            _activeChar.sendPacket(SystemMessageId.CANT_VIEW_PARTY_ROOMS);
            _activeChar.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (_activeChar.isInPartyMatchRoom()) {
            PartyMatchRoomList _list = PartyMatchRoomList.getInstance();
            if (_list == null) {
                return;
            }
            PartyMatchRoom _room = _list.getPlayerRoom(_activeChar);
            if (_room == null) {
                return;
            }
            _activeChar.sendPacket(new PartyMatchDetail(_activeChar, _room));
            _activeChar.sendPacket(new ExPartyRoomMember(_activeChar, _room, 2));
            _activeChar.setPartyRoom(_room.getId());
            _activeChar.broadcastUserInfo();
        } else {
            PartyMatchWaitingList.getInstance().addPlayer(_activeChar);
            ListPartyWating matchList = new ListPartyWating(_activeChar, this._auto, this._loc, this._lvl);
            _activeChar.sendPacket(matchList);
        }
    }

    @Override
    public String getType() {
        return _C__7F_REQUESTPARTYMATCHCONFIG;
    }
}

