/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.datatables.RecipeData;
import com.l2jserver.gameserver.model.L2RecipeList;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.RecipeBookItemList;

public final class RequestRecipeBookDestroy
extends L2GameClientPacket {
    private static final String _C__B6_REQUESTRECIPEBOOKDESTROY = "[C] B6 RequestRecipeBookDestroy";
    private int _recipeID;

    @Override
    protected void readImpl() {
        this._recipeID = this.readD();
    }

    @Override
    protected void runImpl() {
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null) {
            return;
        }
        if (!((L2GameClient)this.getClient()).getFloodProtectors().getTransaction().tryPerformAction("RecipeDestroy")) {
            return;
        }
        L2RecipeList rp = RecipeData.getInstance().getRecipeList(this._recipeID);
        if (rp == null) {
            return;
        }
        activeChar.unregisterRecipeList(this._recipeID);
        RecipeBookItemList response = new RecipeBookItemList(rp.isDwarvenRecipe(), activeChar.getMaxMp());
        if (rp.isDwarvenRecipe()) {
            response.addRecipes(activeChar.getDwarvenRecipeBook());
        } else {
            response.addRecipes(activeChar.getCommonRecipeBook());
        }
        activeChar.sendPacket(response);
    }

    @Override
    public String getType() {
        return _C__B6_REQUESTRECIPEBOOKDESTROY;
    }
}

