/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.RecipeData;
import com.l2jserver.gameserver.enums.PrivateStoreType;
import com.l2jserver.gameserver.model.L2ManufactureItem;
import com.l2jserver.gameserver.model.L2RecipeList;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.itemcontainer.Inventory;
import com.l2jserver.gameserver.model.zone.ZoneId;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.RecipeShopMsg;
import com.l2jserver.gameserver.taskmanager.AttackStanceTaskManager;
import com.l2jserver.gameserver.util.Broadcast;
import com.l2jserver.gameserver.util.Util;
import java.util.Arrays;
import java.util.List;

public final class RequestRecipeShopListSet
extends L2GameClientPacket {
    private static final String _C__BB_RequestRecipeShopListSet = "[C] BB RequestRecipeShopListSet";
    private static final int BATCH_LENGTH = 12;
    private L2ManufactureItem[] _items = null;

    @Override
    protected void readImpl() {
        int count = this.readD();
        if (count <= 0 || count > Config.MAX_ITEM_IN_PACKET || count * 12 != this._buf.remaining()) {
            return;
        }
        this._items = new L2ManufactureItem[count];
        for (int i = 0; i < count; ++i) {
            int id = this.readD();
            long cost = this.readQ();
            if (cost < 0L) {
                this._items = null;
                return;
            }
            this._items[i] = new L2ManufactureItem(id, cost);
        }
    }

    @Override
    protected void runImpl() {
        L2PcInstance player = ((L2GameClient)this.getClient()).getActiveChar();
        if (player == null) {
            return;
        }
        if (this._items == null) {
            player.setPrivateStoreType(PrivateStoreType.NONE);
            player.broadcastUserInfo();
            return;
        }
        if (AttackStanceTaskManager.getInstance().hasAttackStanceTask(player) || player.isInDuel()) {
            player.sendPacket(SystemMessageId.CANT_OPERATE_PRIVATE_STORE_DURING_COMBAT);
            player.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (player.isInsideZone(ZoneId.NO_STORE)) {
            player.sendPacket(SystemMessageId.NO_PRIVATE_WORKSHOP_HERE);
            player.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        List<L2RecipeList> dwarfRecipes = Arrays.asList(player.getDwarvenRecipeBook());
        List<L2RecipeList> commonRecipes = Arrays.asList(player.getCommonRecipeBook());
        for (L2ManufactureItem i : this._items) {
            L2RecipeList list = RecipeData.getInstance().getRecipeList(i.getRecipeId());
            if (!dwarfRecipes.contains(list) && !commonRecipes.contains(list)) {
                Util.handleIllegalPlayerAction(player, "Warning!! Player " + player.getName() + " of account " + player.getAccountName() + " tried to set recipe which he dont have.", Config.DEFAULT_PUNISH);
                return;
            }
            if (i.getCost() > Inventory.MAX_ADENA) {
                Util.handleIllegalPlayerAction(player, "Warning!! Character " + player.getName() + " of account " + player.getAccountName() + " tried to set price more than " + Inventory.MAX_ADENA + " adena in Private Manufacture.", Config.DEFAULT_PUNISH);
                return;
            }
            player.getManufactureItems().put(i.getRecipeId(), i);
        }
        player.setStoreName(!player.hasManufactureShop() ? "" : player.getStoreName());
        player.setPrivateStoreType(PrivateStoreType.MANUFACTURE);
        player.sitDown();
        player.broadcastUserInfo();
        Broadcast.toSelfAndKnownPlayers(player, new RecipeShopMsg(player));
    }

    @Override
    public String getType() {
        return _C__BB_RequestRecipeShopListSet;
    }
}

