/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.cache.HtmCache;
import com.l2jserver.gameserver.enums.HtmlActionScope;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import com.l2jserver.gameserver.util.Util;
import java.util.logging.Level;

public abstract class AbstractHtmlPacket
extends L2GameServerPacket {
    public static final char VAR_PARAM_START_CHAR = '$';
    private final int _npcObjId;
    private String _html = null;
    private boolean _disabledValidation = false;
    private char[] _ca = null;
    private int _count;

    protected AbstractHtmlPacket() {
        this._npcObjId = 0;
    }

    protected AbstractHtmlPacket(int npcObjId) {
        if (npcObjId < 0) {
            throw new IllegalArgumentException();
        }
        this._npcObjId = npcObjId;
    }

    protected AbstractHtmlPacket(String html) {
        this._npcObjId = 0;
        this.setHtml(html);
    }

    protected AbstractHtmlPacket(int npcObjId, String html) {
        if (npcObjId < 0) {
            throw new IllegalArgumentException();
        }
        this._npcObjId = npcObjId;
        this.setHtml(html);
    }

    public final void disableValidation() {
        this._disabledValidation = true;
    }

    public final void setHtml(String html) {
        if (html.length() > 17200) {
            _log.log(Level.WARNING, "Html is too long! this will crash the client!", new Throwable());
            this._html = html.substring(0, 17200);
        }
        if (!html.contains("<html")) {
            html = "<html><body>" + html + "</body></html>";
        }
        this._html = html;
    }

    public boolean setFile(L2PcInstance pc, String path) {
        return this.setFile(pc.getHtmlPrefix(), path);
    }

    public final boolean setFile(String prefix, String path) {
        String content = HtmCache.getInstance().getHtm(prefix, path);
        if (content == null) {
            this.setHtml("<html><body>My Text is missing:<br>" + path + "</body></html>");
            _log.warning("missing html page " + path);
            return false;
        }
        this.setHtml(content);
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public final int replace(CharSequence pattern, CharSequence value) {
        if (value == null) {
            value = "null";
        }
        result = 0;
        if (this._ca == null) {
            this._count = this._html.length();
            this._ca = new char[this._count * 2];
            this._html.getChars(0, this._count, this._ca, 0);
        }
        first = pattern.charAt(0);
        token_length = pattern.length();
        value_length = value.length();
        start = 0;
        while (true) {
            block12: {
                max = this._count - token_length;
                block1: while (start < max) {
                    if (this._ca[start] != first) ** GOTO lbl20
                    end = start + 1;
                    i = 1;
                    while (i < token_length) {
                        if (this._ca[end++] == pattern.charAt(i++)) continue;
lbl20:
                        // 2 sources

                        ++start;
                        continue block1;
                    }
                    break block12;
                }
                return result;
            }
            newLen = this._count - token_length + value_length;
            if (newLen > this._ca.length) {
                copy = new char[newLen * 2];
                System.arraycopy(this._ca, 0, copy, 0, this._count);
                this._ca = copy;
            }
            if ((d = 0 - token_length + value_length) < 0) {
                for (i = end; i <= this._count - 1; ++i) {
                    this._ca[i + d] = this._ca[i];
                }
            } else if (d > 0) {
                for (i = this._count - 1; i >= end; --i) {
                    this._ca[i + d] = this._ca[i];
                }
            }
            this._count = newLen;
            for (i = 0; i < value_length; ++i) {
                this._ca[start + i] = value.charAt(i);
            }
            ++result;
            start += value_length;
        }
    }

    public String toString() {
        return this.getHtml();
    }

    public final int replace(CharSequence pattern, boolean val) {
        return this.replace(pattern, Boolean.toString(val));
    }

    public final int replace(CharSequence pattern, int val) {
        return this.replace(pattern, Integer.toString(val));
    }

    public final int replace(CharSequence pattern, long val) {
        return this.replace(pattern, Long.toString(val));
    }

    public final int replace(CharSequence pattern, float val) {
        return this.replace(pattern, Float.toString(val));
    }

    public final int replace(CharSequence pattern, double val) {
        return this.replace(pattern, Double.toString(val));
    }

    public final AbstractHtmlPacket replaceAll(String regex, String replacement) {
        this._html = this.getHtml().replaceAll(regex, replacement);
        return this;
    }

    public final AbstractHtmlPacket replaceFirst(String regex, String replacement) {
        this._html = this.getHtml().replaceFirst(regex, replacement);
        return this;
    }

    @Override
    public final void runImpl() {
        L2PcInstance player = ((L2GameClient)this.getClient()).getActiveChar();
        player.clearHtmlActions(this.getScope());
        if (this._disabledValidation) {
            return;
        }
        Util.buildHtmlActionCache(player, this.getScope(), this._npcObjId, this.getHtml());
    }

    public final int getNpcObjId() {
        return this._npcObjId;
    }

    public final String getHtml() {
        if (this._ca != null) {
            this._html = new String(this._ca, 0, this._count);
            this._ca = null;
        }
        return this._html;
    }

    public abstract HtmlActionScope getScope();
}

