/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.model.Hit;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import java.util.ArrayList;

public class Attack
extends L2GameServerPacket {
    private final int _attackerObjId;
    private final boolean _soulshot;
    private final int _ssGrade;
    private final int _x;
    private final int _y;
    private final int _z;
    private final int _tx;
    private final int _ty;
    private final int _tz;
    private ArrayList<Hit> _hits;

    public Attack(L2Character attacker, L2Character target, boolean useShots, int ssGrade) {
        this._attackerObjId = attacker.getObjectId();
        this._soulshot = useShots;
        this._ssGrade = ssGrade;
        this._x = attacker.getX();
        this._y = attacker.getY();
        this._z = attacker.getZ();
        this._tx = target.getX();
        this._ty = target.getY();
        this._tz = target.getZ();
    }

    public void addHit(L2Character target, int damage, boolean miss, boolean crit, byte shld) {
        if (this._hits == null) {
            this._hits = new ArrayList();
        }
        this._hits.add(new Hit(target, damage, miss, crit, shld, this._soulshot, this._ssGrade));
    }

    public boolean hasHits() {
        return this._hits != null;
    }

    public boolean hasSoulshot() {
        return this._soulshot;
    }

    private void writeHit(Hit hit) {
        this.writeD(hit.getTargetId());
        this.writeD(hit.getDamage());
        this.writeC(hit.getFlags());
    }

    @Override
    protected final void writeImpl() {
        this.writeC(51);
        this.writeD(this._attackerObjId);
        this.writeHit(this._hits.get(0));
        this.writeD(this._x);
        this.writeD(this._y);
        this.writeD(this._z);
        this.writeH(this._hits.size() - 1);
        for (int i = 1; i < this._hits.size(); ++i) {
            this.writeHit(this._hits.get(i));
        }
        this.writeD(this._tx);
        this.writeD(this._ty);
        this.writeD(this._tz);
    }
}

