/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.model.PartyMatchWaitingList;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import java.util.ArrayList;
import java.util.List;

public class ExListPartyMatchingWaitingRoom
extends L2GameServerPacket {
    private final L2PcInstance _activeChar;
    private final int _minlvl;
    private final int _maxlvl;
    private final int _mode;
    private final List<L2PcInstance> _members;

    public ExListPartyMatchingWaitingRoom(L2PcInstance player, int page, int minlvl, int maxlvl, int mode) {
        this._activeChar = player;
        this._minlvl = minlvl;
        this._maxlvl = maxlvl;
        this._mode = mode;
        this._members = new ArrayList<L2PcInstance>();
    }

    @Override
    protected void writeImpl() {
        this.writeC(254);
        this.writeH(54);
        if (this._mode == 0) {
            this.writeD(0);
            this.writeD(0);
            return;
        }
        for (L2PcInstance cha : PartyMatchWaitingList.getInstance().getPlayers()) {
            if (cha == null || cha == this._activeChar) continue;
            if (!cha.isPartyWaiting()) {
                PartyMatchWaitingList.getInstance().removePlayer(cha);
                continue;
            }
            if (cha.getLevel() < this._minlvl || cha.getLevel() > this._maxlvl) continue;
            this._members.add(cha);
        }
        this.writeD(1);
        this.writeD(this._members.size());
        for (L2PcInstance member : this._members) {
            this.writeS(member.getName());
            this.writeD(member.getActiveClass());
            this.writeD(member.getLevel());
        }
    }
}

