/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.model.entity.Message;
import com.l2jserver.gameserver.model.itemcontainer.Mail;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.network.serverpackets.AbstractItemPacket;

public class ExReplySentPost
extends AbstractItemPacket {
    private final Message _msg;
    private L2ItemInstance[] _items = null;

    public ExReplySentPost(Message msg) {
        this._msg = msg;
        if (msg.hasAttachments()) {
            Mail attachments = msg.getAttachments();
            if (attachments != null && attachments.getSize() > 0) {
                this._items = attachments.getItems();
            } else {
                _log.warning("Message " + msg.getId() + " has attachments but itemcontainer is empty.");
            }
        }
    }

    @Override
    protected void writeImpl() {
        this.writeC(254);
        this.writeH(173);
        this.writeD(this._msg.getId());
        this.writeD(this._msg.isLocked() ? 1 : 0);
        this.writeS(this._msg.getReceiverName());
        this.writeS(this._msg.getSubject());
        this.writeS(this._msg.getContent());
        if (this._items != null && this._items.length > 0) {
            this.writeD(this._items.length);
            for (L2ItemInstance item : this._items) {
                this.writeItem(item);
                this.writeD(item.getObjectId());
            }
            this.writeQ(this._msg.getReqAdena());
            this.writeD(this._msg.getSendBySystem());
        } else {
            this.writeD(0);
        }
    }
}

