/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.serverpackets.AbstractItemPacket;
import com.l2jserver.gameserver.network.serverpackets.ExQuestItemList;

public final class ItemList
extends AbstractItemPacket {
    private final L2PcInstance _activeChar;
    private final L2ItemInstance[] _items;
    private final int _size;
    private final boolean _showWindow;

    public ItemList(L2PcInstance activeChar, boolean showWindow) {
        this._activeChar = activeChar;
        this._showWindow = showWindow;
        this._items = activeChar.getInventory().getItems();
        int index = 0;
        for (L2ItemInstance item : this._items) {
            if (item.isQuestItem()) continue;
            this._items[index++] = item;
        }
        this._size = index;
    }

    @Override
    protected final void writeImpl() {
        this.writeC(17);
        this.writeH(this._showWindow ? 1 : 0);
        this.writeH(this._size);
        for (int index = 0; index < this._size; ++index) {
            this.writeItem(this._items[index]);
        }
        this.writeInventoryBlock(this._activeChar.getInventory());
    }

    @Override
    public void runImpl() {
        ((L2GameClient)this.getClient()).sendPacket(new ExQuestItemList(this._activeChar));
    }
}

