/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.model.L2ClanMember;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;

public final class PledgeShowMemberListUpdate
extends L2GameServerPacket {
    private final int _pledgeType;
    private int _hasSponsor;
    private final String _name;
    private final int _level;
    private final int _classId;
    private final int _objectId;
    private final boolean _isOnline;
    private final int _race;
    private final int _sex;

    public PledgeShowMemberListUpdate(L2PcInstance player) {
        this._pledgeType = player.getPledgeType();
        this._hasSponsor = this._pledgeType == -1 ? (player.getSponsor() != 0 ? 1 : 0) : 0;
        this._name = player.getName();
        this._level = player.getLevel();
        this._classId = player.getClassId().getId();
        this._race = player.getRace().ordinal();
        this._sex = player.getAppearance().getSex() ? 1 : 0;
        this._objectId = player.getObjectId();
        this._isOnline = player.isOnline();
    }

    public PledgeShowMemberListUpdate(L2ClanMember member) {
        this._name = member.getName();
        this._level = member.getLevel();
        this._classId = member.getClassId();
        this._objectId = member.getObjectId();
        this._isOnline = member.isOnline();
        this._pledgeType = member.getPledgeType();
        this._race = member.getRaceOrdinal();
        int n = this._sex = member.getSex() ? 1 : 0;
        this._hasSponsor = this._pledgeType == -1 ? (member.getSponsor() != 0 ? 1 : 0) : 0;
    }

    @Override
    protected final void writeImpl() {
        this.writeC(91);
        this.writeS(this._name);
        this.writeD(this._level);
        this.writeD(this._classId);
        this.writeD(this._sex);
        this.writeD(this._race);
        if (this._isOnline) {
            this.writeD(this._objectId);
            this.writeD(this._pledgeType);
        } else {
            this.writeD(0);
            this.writeD(0);
        }
        this.writeD(this._hasSponsor);
    }
}

