/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.model.TradeItem;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.network.serverpackets.AbstractItemPacket;

public class PrivateStoreManageListBuy
extends AbstractItemPacket {
    private final int _objId;
    private final long _playerAdena;
    private final L2ItemInstance[] _itemList;
    private final TradeItem[] _buyList;

    public PrivateStoreManageListBuy(L2PcInstance player) {
        this._objId = player.getObjectId();
        this._playerAdena = player.getAdena();
        this._itemList = player.getInventory().getUniqueItems(false, true);
        this._buyList = player.getBuyList().getItems();
    }

    @Override
    protected final void writeImpl() {
        this.writeC(189);
        this.writeD(this._objId);
        this.writeQ(this._playerAdena);
        this.writeD(this._itemList.length);
        for (L2ItemInstance l2ItemInstance : this._itemList) {
            this.writeItem(l2ItemInstance);
            this.writeQ(l2ItemInstance.getItem().getReferencePrice() * 2);
        }
        this.writeD(this._buyList.length);
        for (TradeItem tradeItem : this._buyList) {
            this.writeItem(tradeItem);
            this.writeQ(tradeItem.getPrice());
            this.writeQ(tradeItem.getItem().getReferencePrice() * 2);
            this.writeQ(tradeItem.getCount());
        }
    }
}

