/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.datatables.ClanTable;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.L2SiegeClan;
import com.l2jserver.gameserver.model.entity.Castle;
import com.l2jserver.gameserver.model.entity.clanhall.SiegableHall;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import java.util.List;

public final class SiegeAttackerList
extends L2GameServerPacket {
    private Castle _castle;
    private SiegableHall _hall;

    public SiegeAttackerList(Castle castle) {
        this._castle = castle;
    }

    public SiegeAttackerList(SiegableHall hall) {
        this._hall = hall;
    }

    @Override
    protected final void writeImpl() {
        this.writeC(202);
        if (this._castle != null) {
            this.writeD(this._castle.getResidenceId());
            this.writeD(0);
            this.writeD(1);
            this.writeD(0);
            int size = this._castle.getSiege().getAttackerClans().size();
            if (size > 0) {
                this.writeD(size);
                this.writeD(size);
                for (L2SiegeClan siegeclan : this._castle.getSiege().getAttackerClans()) {
                    L2Clan clan = ClanTable.getInstance().getClan(siegeclan.getClanId());
                    if (clan == null) continue;
                    this.writeD(clan.getId());
                    this.writeS(clan.getName());
                    this.writeS(clan.getLeaderName());
                    this.writeD(clan.getCrestId());
                    this.writeD(0);
                    this.writeD(clan.getAllyId());
                    this.writeS(clan.getAllyName());
                    this.writeS("");
                    this.writeD(clan.getAllyCrestId());
                }
            } else {
                this.writeD(0);
                this.writeD(0);
            }
        } else {
            this.writeD(this._hall.getId());
            this.writeD(0);
            this.writeD(1);
            this.writeD(0);
            List<L2SiegeClan> attackers = this._hall.getSiege().getAttackerClans();
            int size = attackers.size();
            if (size > 0) {
                this.writeD(size);
                this.writeD(size);
                for (L2SiegeClan sClan : attackers) {
                    L2Clan clan = ClanTable.getInstance().getClan(sClan.getClanId());
                    if (clan == null) continue;
                    this.writeD(clan.getId());
                    this.writeS(clan.getName());
                    this.writeS(clan.getLeaderName());
                    this.writeD(clan.getCrestId());
                    this.writeD(0);
                    this.writeD(clan.getAllyId());
                    this.writeS(clan.getAllyName());
                    this.writeS("");
                    this.writeD(clan.getAllyCrestId());
                }
            } else {
                this.writeD(0);
                this.writeD(0);
            }
        }
    }
}

