/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.util.lib;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class SqlBuilder {
    private final Connection _con;
    private final String[] _queries;
    private final String[] _values;
    private PreparedStatement _prepareStatement;

    public SqlBuilder(Connection con, String s) {
        this._con = con;
        this._queries = s.split("\\?", -1);
        this._values = new String[this._queries.length];
    }

    public ResultSet executeQuery() throws SQLException {
        return this.prepare().executeQuery();
    }

    public int executeUpdate() throws SQLException {
        return this.prepare().executeUpdate();
    }

    public void setBoolean(int i, boolean flag) {
        this._values[i] = String.valueOf(flag);
    }

    public void setInt(int i, int j) {
        this._values[i] = String.valueOf(j);
    }

    public void setLong(int i, long l) {
        this._values[i] = String.valueOf(l);
    }

    public void setFloat(int i, float f) {
        this._values[i] = String.valueOf(f);
    }

    public void setDouble(int i, double d) {
        this._values[i] = String.valueOf(d);
    }

    public void setString(int i, String s) {
        this._values[i] = this.mysql_real_escape_string(s);
    }

    public boolean execute() throws SQLException {
        return this.prepare().execute();
    }

    public void close() throws SQLException {
        this._prepareStatement.close();
    }

    public String getQuery() throws SQLException {
        StringBuilder b = new StringBuilder(this._queries[0]);
        for (int i = 1; i < this._queries.length; ++i) {
            if (this._values[i] == null) {
                throw new SQLException();
            }
            b.append(this._values[i]).append(this._queries[i]);
        }
        return b.toString();
    }

    private PreparedStatement prepare() throws SQLException {
        this._prepareStatement = this._con.prepareStatement(this.getQuery());
        return this._prepareStatement;
    }

    private String mysql_real_escape_string(String v) {
        return "'" + v.replace("'", "''").replace("\\", "\\\\") + "'";
    }
}

