/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.python.core.CompilerFlags;
import org.python.core.FixMacReaderBug;
import org.python.core.LiteralMakerForParser;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PySyntaxError;
import org.python.parser.IParserHost;
import org.python.parser.Node;
import org.python.parser.ParseException;
import org.python.parser.PythonGrammar;
import org.python.parser.ReaderCharStream;
import org.python.parser.Token;
import org.python.parser.TokenMgrError;
import org.python.parser.ast.modType;

public class parser {
    private static IParserHost literalMkrForParser = new LiteralMakerForParser();

    private parser() {
    }

    static String getLine(BufferedReader bufferedReader, int n) {
        if (bufferedReader == null) {
            return "";
        }
        try {
            String string = null;
            for (int i = 0; i < n; ++i) {
                string = bufferedReader.readLine();
            }
            return string;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static PyException fixParseError(BufferedReader bufferedReader, Throwable throwable, String string) {
        if (bufferedReader != null) {
            try {
                bufferedReader.reset();
            }
            catch (IOException iOException) {
                bufferedReader = null;
            }
        }
        if (throwable instanceof ParseException) {
            ParseException parseException = (ParseException)throwable;
            Token token = parseException.currentToken;
            int n = 0;
            int n2 = 0;
            if (token != null && token.next != null) {
                n = token.next.beginColumn;
                n2 = token.next.beginLine;
            }
            String string2 = parser.getLine(bufferedReader, n2);
            return new PySyntaxError(parseException.getMessage(), n2, n, string2, string);
        }
        if (throwable instanceof TokenMgrError) {
            TokenMgrError tokenMgrError = (TokenMgrError)throwable;
            boolean bl = tokenMgrError.EOFSeen;
            int n = tokenMgrError.errorColumn;
            int n3 = tokenMgrError.errorLine;
            String string3 = parser.getLine(bufferedReader, n3);
            if (bl) {
                --n;
            }
            return new PySyntaxError(tokenMgrError.getMessage(), n3, n, string3, string);
        }
        return Py.JavaError(throwable);
    }

    public static Node parse(String string, String string2) {
        return parser.parse(new ByteArrayInputStream(string.getBytes()), string2, "<string>", null);
    }

    public static modType parse(InputStream inputStream, String string, String string2, CompilerFlags compilerFlags) {
        BufferedReader bufferedReader = parser.prepBufreader(inputStream, compilerFlags);
        PythonGrammar pythonGrammar = new PythonGrammar(new ReaderCharStream(bufferedReader), literalMkrForParser);
        modType modType2 = null;
        try {
            modType2 = parser.doparse(string, compilerFlags, pythonGrammar);
        }
        catch (Throwable throwable) {
            throw parser.fixParseError(bufferedReader, throwable, string2);
        }
        return modType2;
    }

    public static modType partialParse(String string, String string2, String string3, CompilerFlags compilerFlags, boolean bl) {
        modType modType2 = null;
        BufferedReader bufferedReader = parser.prepBufreader(new ByteArrayInputStream(string.getBytes()), compilerFlags);
        PythonGrammar pythonGrammar = new PythonGrammar(new ReaderCharStream(bufferedReader), literalMkrForParser);
        pythonGrammar.token_source.partial = true;
        pythonGrammar.token_source.stdprompt = bl;
        try {
            modType2 = parser.doparse(string2, compilerFlags, pythonGrammar);
        }
        catch (Throwable throwable) {
            if (pythonGrammar.partial_valid_sentence(throwable)) {
                return null;
            }
            throw parser.fixParseError(bufferedReader, throwable, string3);
        }
        return modType2;
    }

    private static modType doparse(String string, CompilerFlags compilerFlags, PythonGrammar pythonGrammar) throws ParseException {
        modType modType2 = null;
        if (compilerFlags != null) {
            pythonGrammar.token_source.generator_allowed = compilerFlags.generator_allowed;
        }
        if (string.equals("eval")) {
            modType2 = pythonGrammar.eval_input();
        } else if (string.equals("exec")) {
            modType2 = pythonGrammar.file_input();
        } else if (string.equals("single")) {
            modType2 = pythonGrammar.single_input();
        } else {
            throw Py.ValueError("parse kind must be eval, exec, or single");
        }
        return modType2;
    }

    private static BufferedReader prepBufreader(InputStream inputStream, CompilerFlags compilerFlags) {
        int n;
        try {
            n = inputStream.available();
        }
        catch (IOException iOException) {
            n = 10000;
        }
        if (n <= 0) {
            n = 10000;
        }
        if (n > 100000) {
            n = 100000;
        }
        Reader reader = null;
        try {
            if (compilerFlags != null && compilerFlags.encoding != null) {
                reader = new InputStreamReader(inputStream, compilerFlags.encoding);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        if (reader == null) {
            reader = new InputStreamReader(inputStream);
        }
        reader = new FixMacReaderBug(reader);
        BufferedReader bufferedReader = new BufferedReader(reader);
        try {
            bufferedReader.mark(n);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bufferedReader;
    }
}

