/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.util.network;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.logging.Logger;

public abstract class BaseSendablePacket {
    private static final Logger _log = Logger.getLogger(BaseSendablePacket.class.getName());
    private final ByteArrayOutputStream _bao = new ByteArrayOutputStream();

    protected BaseSendablePacket() {
    }

    protected void writeD(int value) {
        this._bao.write(value);
        this._bao.write(value >>> 8);
        this._bao.write(value >>> 16);
        this._bao.write(value >>> 24);
    }

    protected void writeH(int value) {
        this._bao.write(value);
        this._bao.write(value >>> 8);
    }

    protected void writeC(int value) {
        this._bao.write(value);
    }

    protected void writeF(double org) {
        long value = Double.doubleToRawLongBits(org);
        this._bao.write((int)value);
        this._bao.write((int)(value >>> 8));
        this._bao.write((int)(value >>> 16));
        this._bao.write((int)(value >>> 24));
        this._bao.write((int)(value >>> 32));
        this._bao.write((int)(value >>> 40));
        this._bao.write((int)(value >>> 48));
        this._bao.write((int)(value >>> 56));
    }

    protected void writeS(String text) {
        try {
            if (text != null) {
                this._bao.write(text.getBytes(StandardCharsets.UTF_16LE));
            }
        }
        catch (IOException e) {
            _log.warning(this.getClass().getSimpleName() + ": " + e.getMessage());
        }
        this._bao.write(0);
        this._bao.write(0);
    }

    protected void writeB(byte[] array) {
        try {
            this._bao.write(array);
        }
        catch (IOException e) {
            _log.warning(this.getClass().getSimpleName() + ": " + e.getMessage());
        }
    }

    protected void writeQ(long value) {
        this._bao.write((int)value);
        this._bao.write((int)(value >>> 8));
        this._bao.write((int)(value >>> 16));
        this._bao.write((int)(value >>> 24));
        this._bao.write((int)(value >>> 32));
        this._bao.write((int)(value >>> 40));
        this._bao.write((int)(value >>> 48));
        this._bao.write((int)(value >>> 56));
    }

    public int getLength() {
        return this._bao.size() + 2;
    }

    public byte[] getBytes() {
        int padding;
        this.writeD(0);
        if (padding != 0) {
            for (padding = this._bao.size() % 8; padding < 8; ++padding) {
                this.writeC(0);
            }
        }
        return this._bao.toByteArray();
    }

    public abstract byte[] getContent() throws IOException;
}

