/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.util;

import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import com.l2jserver.gameserver.network.serverpackets.ValidateLocation;
import com.l2jserver.gameserver.util.Util;
import com.l2jserver.util.Rnd;
import java.util.List;

public class EventNpcAligner {
    private static final Location[][] SPAWN_DATA = new Location[][]{{new Location(82789, 149377, -3464, 49224)}, {new Location(147049, 25939, -2008, 49151)}, {new Location(148077, -55417, -2728, 32768), new Location(148046, -55328, -2728, 40960)}, {new Location(43566, -47657, -792, 30616), new Location(43546, -47556, -792, 36864)}, {new Location(17119, 144848, -3008, 26624), new Location(17175, 144927, -3008, 21845)}, {new Location(82335, 53283, -1488, 16384)}, {new Location(-13946, 121932, -2984, 21849), new Location(-13880, 122006, -2984, 22248)}, {new Location(-83123, 150918, -3120, 0), new Location(-83123, 150818, -3120, 0)}, {new Location(87102, -141328, -1336, 49296)}, {new Location(111168, 221058, -3544, 0), new Location(111168, 220958, -3544, 0)}, {new Location(116970, 77223, -2688, 40960), new Location(116900, 77293, -2688, 40960)}, {new Location(-84121, 243256, -3728, 9000), new Location(-84043, 243195, -3728, 9000)}, {new Location(115642, -178046, -896, 32768), new Location(115622, -177946, -896, 32768)}, {new Location(-45042, -113648, -192, 32768), new Location(-45042, -113548, -192, 32768)}, {new Location(12099, 16633, -4584, 63240), new Location(12123, 16739, -4584, 63240)}, {new Location(45525, 48363, -3056, 49152), new Location(45425, 48355, -3056, 49152)}, {new Location(-119692, 44454, 360, 33324), new Location(-119692, 44554, 360, 33324)}};

    public static Location[] getSpawns() {
        Location[] spawns = new Location[SPAWN_DATA.length];
        int i = SPAWN_DATA.length;
        while (--i >= 0) {
            spawns[i] = SPAWN_DATA[i][Rnd.get(SPAWN_DATA[i].length)];
        }
        return spawns;
    }

    public static L2Npc align(L2Npc manager) {
        int mX = manager.getX();
        int mY = manager.getY();
        int mZ = manager.getZ();
        L2Npc guide = null;
        List knownObjects = L2World.getInstance().getVisibleObjects((L2Object)manager, 300);
        block0: while (true) {
            for (L2Object o : knownObjects) {
                if (!(o instanceof L2Npc)) continue;
                L2Npc obj = (L2Npc)o;
                double collisionRadius = Math.max(30, manager.getTemplate().getCollisionRadius() * 2 + obj.getTemplate().getCollisionRadius());
                boolean isMove = false;
                while (Util.calculateDistance(mX, mY, obj.getX(), obj.getY()) < collisionRadius) {
                    if (guide == null && (guide = EventNpcAligner.findGuide(manager, knownObjects)) == null) {
                        return manager;
                    }
                    int gx = guide.getX();
                    int gy = guide.getY();
                    double dx = mX - gx;
                    double dy = mY - gy;
                    double angle = Math.atan2(dy, dx);
                    double radius = Math.sqrt(dx * dx + dy * dy) + (double)(manager.getTemplate().getCollisionRadius() * 2);
                    mX = gx + (int)Math.round(Math.cos(angle) * radius);
                    mY = gy + (int)Math.round(Math.sin(angle) * radius);
                    isMove = true;
                }
                if (!isMove) continue;
                continue block0;
            }
            break;
        }
        if (mX != manager.getX() || mY != manager.getY()) {
            manager.setXYZ(mX, mY, mZ);
            manager.broadcastPacket((L2GameServerPacket)new ValidateLocation((L2Object)manager));
            L2Spawn spawn = manager.getSpawn();
            spawn.setXYZ(mX, mY, mZ);
        }
        return manager;
    }

    private static L2Npc findGuide(L2Npc npc, List<L2Object> knownObjects) {
        L2Npc nearestGuide = null;
        double distance = Double.MAX_VALUE;
        for (L2Object o : knownObjects) {
            if (!(o instanceof L2Npc)) continue;
            L2Npc obj = (L2Npc)o;
            switch (obj.getId()) {
                case 30598: 
                case 30599: 
                case 30600: 
                case 30601: 
                case 30602: 
                case 31076: 
                case 31077: 
                case 32135: 
                case 32327: {
                    double d = Util.calculateDistance((L2Object)npc, (L2Object)obj, true);
                    if (!(distance > d)) break;
                    distance = d;
                    nearestGuide = obj;
                }
            }
        }
        return nearestGuide;
    }

    public static L2Npc alignRight(L2Npc manager) {
        int gx = manager.getX();
        int gy = manager.getY();
        int mX = manager.getX();
        int mY = manager.getY();
        int mZ = manager.getZ();
        int h = (manager.getHeading() + 16384) % 65536;
        double angle = (double)h * 9.587379924285257E-5;
        double radius = 0.0;
        List knownObjects = L2World.getInstance().getVisibleObjects((L2Object)manager, 300);
        block0: while (true) {
            for (L2Object o : knownObjects) {
                if (!(o instanceof L2Npc)) continue;
                L2Npc obj = (L2Npc)o;
                double collisionRadius = Math.max(30, manager.getTemplate().getCollisionRadius() * 2 + obj.getTemplate().getCollisionRadius());
                boolean isMove = false;
                while (Util.calculateDistance(mX, mY, obj.getX(), obj.getY()) < collisionRadius) {
                    mX = gx + (int)Math.round(Math.cos(angle) * (radius += (double)(manager.getTemplate().getCollisionRadius() * 2)));
                    mY = gy + (int)Math.round(Math.sin(angle) * radius);
                    isMove = true;
                }
                if (!isMove) continue;
                continue block0;
            }
            break;
        }
        if (mX != manager.getX() || mY != manager.getY()) {
            manager.setXYZ(mX, mY, mZ);
            manager.broadcastPacket((L2GameServerPacket)new ValidateLocation((L2Object)manager));
            L2Spawn spawn = manager.getSpawn();
            spawn.setXYZ(mX, mY, mZ);
        }
        return manager;
    }
}

