//@formatter:off
/*
 * Auther: tukune
 * 
 * DON'T CODE FORMAT!
 * DON'T CONVERT TAB <---> SPACE
 * DON'T STRIP TRAILING BLANKS FROM END OF LINE
 */
package jp.sf.l2j.arrayMaps;

import static jp.sf.l2j.arrayMaps.SortedArrayMap.*;

import java.util.Arrays;
import java.util.Map;
import java.util.Map.Entry;

/*
 * @auther JOJO
 */
public class SortedLongIntArrayMap
{
	private long[] _keys;
	private int[] _values;
	public final int NULL;
	
	public SortedLongIntArrayMap()
	{
		this(INT_NULL);
	}
	
	public SortedLongIntArrayMap(int nullValue)
	{
		this(nullValue, LONG_EMPTY, INT_EMPTY);
	}
	
	public SortedLongIntArrayMap(long[] keys, int[] values)
	{
		this(INT_NULL, keys, values);
	}
	
	public SortedLongIntArrayMap(int nullValue, long[] keys, int[] values)
	{
		NULL = nullValue;
		_keys = keys;
		_values = values;
		sort();
	}
	
	public SortedLongIntArrayMap(Map<Long, Integer> t)
	{
		this(INT_NULL, t);
	}
	
	public SortedLongIntArrayMap(int nullValue, Map<Long, Integer> t)
	{
		NULL = nullValue;
		int length = t.size();
		long[] tmpKeys = new long[length];
		int[] tmpValues = new int[length];
		
		Integer w;
		int index = 0;
		for (Entry<Long, Integer> e : t.entrySet())
		{
			tmpKeys[index] = e.getKey();
			tmpValues[index] = (w = e.getValue()) == null ? NULL : w;
			++index;
		}
		_keys = tmpKeys;
		_values = tmpValues;
		sort();
	}
	
	public void clear()
	{
		_keys = LONG_EMPTY;
		_values = INT_EMPTY;
	}
	
	public boolean containsKey(long key)
	{
		return Arrays.binarySearch(_keys, key) >= 0;
	}
	
	public boolean containsValue(int value)
	{
		for (int index = _values.length; --index >= 0;)
			if (_values[index] == value)
				return true;
		return false;
	}
	
	public int get(long key)
	{
		return getOrDefault(key, NULL);
	}
	
	public int getOrDefault(long key, int defaultValue)
	{
		int index = Arrays.binarySearch(_keys, key);
		if (index >= 0)
			return _values[index];
		else
			return defaultValue;
	}
	
	public boolean isEmpty()
	{
		return _keys.length == 0;
	}
	
	public long[] keySet()
	{
		return _keys;
	}
	
	public long[] keys()
	{
		return _keys;
	}
	
	public int put(long key, int value)
	{
		int index = Arrays.binarySearch(_keys, key);
		if (index >= 0) {
			int prev = _values[index];
			_values[index] = value;
			return prev;
		} else {
			return insertEntry(-(index + 1), key, value);
		}
	}
	
	public int putIfAbsent(long key, int value)
	{
		int index = Arrays.binarySearch(_keys, key);
		if (index >= 0)
			return _values[index];
		else
			return insertEntry(-(index + 1), key, value);
	}
	
	public void putAll(Map<Long, Integer> t)
	{
		for (Entry<Long, Integer> e : t.entrySet())
			put(e.getKey(), e.getValue());
	}
	
	public int remove(long key)
	{
		int index = Arrays.binarySearch(_keys, key);
		if (index >= 0)
			return deleteEntry(index);
		else
			return NULL;
	}
	
	public int size()
	{
		return _keys.length;
	}
	
	public int[] values()
	{
		return _values;
	}
	
	public SortedLongIntArrayMap append(long key, int value)
	{
		int prev = put(key, value);
		if (prev != NULL) throw new RuntimeException("Duplicate key:" + key + " value:" + value + " previus:" + prev);
		return this;
	}
	
	private int deleteEntry(int index)
	{
		final int length = _keys.length - 1;
		if (length < 0)
			return NULL;
		long[] tmpKeys = new long[length];
		int[] tmpValues = new int[length];
		if (index > 0) {
			System.arraycopy(_keys, 0, tmpKeys, 0, index);
			System.arraycopy(_values, 0, tmpValues, 0, index);
		}
		int n;
		if ((n = length - index) > 0) {
			System.arraycopy(_keys, index + 1, tmpKeys, index, n);
			System.arraycopy(_values, index + 1, tmpValues, index, n);
		}
		int prev = _values[index];
		_keys = tmpKeys;
		_values = tmpValues;
		return prev;
	}
	
	public int indexOf(long key)
	{
		return Arrays.binarySearch(_keys, key);
	}
	
	private int insertEntry(int index, long key, int value)
	{
		final int length = _keys.length;
		long[] tmpKeys = new long[length + 1];
		int[] tmpValues = new int[length + 1];
		if (index > 0) {
			System.arraycopy(_keys, 0, tmpKeys, 0, index);
			System.arraycopy(_values, 0, tmpValues, 0, index);
		}
		tmpKeys[index] = key;
		tmpValues[index] = value;
		int n;
		if ((n = length - index) > 0) {
			System.arraycopy(_keys, index, tmpKeys, index + 1, n);
			System.arraycopy(_values, index, tmpValues, index + 1, n);
		}
		_keys = tmpKeys;
		_values = tmpValues;
		return NULL;
	}
	
	public long keyAt(int index)
	{
		return _keys[index];
	}
	
	public int valueAt(int index)
	{
		return _values[index];
	}
	
	public long getKey(int index)
	{
		return keyAt(index);
	}
	
	public int getValue(int index)
	{
		return valueAt(index);
	}
	
	public int setValue(int index, int value)
	{
		int prev = _values[index];
		_values[index] = value;
		return prev;
	}
	
	public void fill(int value)
	{
		Arrays.fill(_values, value);
	}
	
	public void sort()
	{
		sort(0, _keys.length - 1);
	}
	
	private void sort(int left, int right)
	{
		if (left >= right) return;
		long pivot = _keys[(left + right) / 2];
		int i = left;
		int j = right;
		for (;;) {
			while (_keys[i] < pivot) ++i;
			while (pivot < _keys[j]) --j;
			if (i >= j) break;
			long key = _keys[i]; _keys[i] = _keys[j]; _keys[j] = key;
			int value = _values[i]; _values[i] = _values[j]; _values[j] = value;
			++i;
			--j;
		}
		sort(left,  i - 1);
		sort(j + 1, right);
	}
}
