//@formatter:off
/*
 * Auther: tukune
 * 
 * DON'T CODE FORMAT!
 * DON'T CONVERT TAB <---> SPACE
 * DON'T STRIP TRAILING BLANKS FROM END OF LINE
 */
package jp.sf.l2j.boundArrays;

import java.util.Arrays;

/**
 * @author JOJO
 */
public class BoundFloatArray
{
	private static final float[] EMPTY_ELEMENTDATA = new float[0];	//TODO: #VC#_EMPTY
	
	private float[] elementData = EMPTY_ELEMENTDATA;
	private int lbound;
	public static final float NULL = 0;	//TODO: #VC#_NULL
	
	public BoundFloatArray() {}
	
	public BoundFloatArray(int lbound) { this.lbound = lbound; }
	
	public BoundFloatArray to(int ubound) {
		final int s = ubound - lbound + 1;
		if (s != elementData.length)
			elementData = Arrays.copyOf(elementData, s);
		return this;
	}
	
	private void grow(int newSize) { elementData = Arrays.copyOf(elementData, newSize); }
	
	public int size() { return elementData.length; }
	
	public boolean isEmpty() { return elementData.length == 0; }
	
	public int lbound() { return lbound; }
	
	public int ubound() { return lbound + elementData.length - 1; }
	
	public boolean contains(float element) { return indexOf(element) >= 0; }
	
	public boolean containsKey(int index) {
	//	return lbound() <= index && index <= ubound();
		int pos = index - lbound;
		return 0 <= pos && pos < elementData.length;
	}
	
	public int indexOf(float element) {
		for (int pos = 0; pos < elementData.length; ++pos)
			if (element == elementData[pos])
				return pos;
		return -1;
	}
	
	public int lastIndexOf(float element) {
		for (int pos = elementData.length; --pos >= 0;)
			if (element == elementData[pos])
				return pos;
		return -1;
	}
	
	public float[] toArray() { return Arrays.copyOf(elementData, elementData.length); }
	
	public float get(int index) {
		final int pos = index - lbound;
		return pos >= 0 && pos < elementData.length ? (float) elementData[pos] : NULL;
	}
	
	public float set(int index, float element) {
		final int pos = index - lbound;
		final float p = elementData[pos];
		elementData[pos] = element;
		return p;
	}
	
	public float put(int index, float element) {
		final int size = elementData.length;
		if (size == 0 && lbound == 0)
			lbound = index;
		final int pos = index - lbound;
		if (pos == size)
			grow(size + 1);
	//sure! else if (pos < 0 || pos > size) throw new ArrayIndexOutOfBoundsException();
		final float p = elementData[pos];
		elementData[pos] = element;
		return p;
	}
	
	public BoundFloatArray append(int index, float element) {
		final int size = elementData.length;
		if (size == 0 && lbound == 0)
			lbound = index;
		final int pos = index - lbound;
		if (pos == size)
			grow(size + 1);
	//sure! else if (pos < 0 || pos > size) throw new ArrayIndexOutOfBoundsException();
		elementData[pos] = element;
		return this;
	}
	
	public BoundFloatArray append(float element) {
		final int size = elementData.length;
		final int pos = size;
		grow(size + 1);
		elementData[pos] = element;
		return this;
	}
	
	public void clear() { elementData = EMPTY_ELEMENTDATA; }
	
	public boolean addAll(float[] a) {
		final int size = elementData.length;
		final int numNew = a.length;
		grow(size + numNew);
		System.arraycopy(a, 0, elementData, size, numNew);
		return numNew != 0;
	}
	
	public void fill(float element) { Arrays.fill(elementData, element); }
	
	public float[] values() { return elementData; }
}
