## Active Perl 5.8.8 or later

# Add comments to enchantItemData.xml
# Author JOJO

use utf8;
use strict;
use warnings;
use Encode;
use DBI;

binmode STDOUT,':encoding(cp932)'; $|=1;
sub   FS {Encode::encode('cp932',shift)}
sub UTF8 {Encode::decode('cp932',shift)}

my $DEBUG = 0; # 1 or 0

my $vars_txt = '../../../tools/vars.txt';
open FILE,'<',$vars_txt  or do {warn "'$vars_txt' $!";exit 0};
read FILE,my $vars,-s FILE;
close FILE;
my $gsuser = ($vars =~ m/^@*set gsuser=(.+)$/m)[0];
my $gspass = ($vars =~ m/^@*set gspass=(.+)$/m)[0];
my $gsdb   = ($vars =~ m/^@*set gsdb=(.+)$/m)[0];
my $gshost = ($vars =~ m/^@*set gshost=(.+)$/m)[0];

my $db = DBI->connect("DBI:mysql:$gsdb:$gshost", $gsuser, $gspass, {mysql_enable_utf8=>1}) or do{warn DBI::errstr;exit 0};
   $db->do('SET NAMES UTF8');

&start('./enchantItemData.xml');

exit 0;

sub start {
	my ($filePath) = @_;

	print "  $filePath\n" if $DEBUG;
	open FILE, '<:utf8', FS($filePath) or die "'$filePath' $!";
	my $mtime = (stat FILE)[9];
	read FILE,my $text,-s FILE;
	close FILE;

	my $backup = $text;
	my @T = split m/(?<=[\n])/, $text;
	for (my $ii = 0; $ii <= $#T; ++$ii) {
		my $line = \$T[$ii];
		if ($$line =~ m/<!--/ && $$line !~ m/-->/) {	# skip comment
			do {++$ii} while $T[$ii] !~ m/-->/;
			next;
		}
		
		if ($$line =~ m/^[\t ]*<item [^<>]*id="(\d+)"/
		 || $$line =~ m/^[\t ]*<enchant [^<>]*id="(\d+)"/
		 || $$line =~ m/^[\t ]*<support [^<>]*id="(\d+)"/ ) {
			my $itemId = $1;
			my $itemName = getItemName($itemId);
			if ($itemName) {
				   $$line =~ s{<!--(:?[^-]|-[^-]|--[^>])*-->$}{<!-- $itemName -->}
				or $$line =~ s{$}{ <!-- $itemName -->};
				print "\t$itemId $itemName\n" if $DEBUG;
			}
		}
	}
	$text = join '',@T;

	if ($backup ne $text) {
		my $outPath = $filePath;
		   $outPath = $filePath . '.text' if $DEBUG;
		open FILE, '>:utf8', FS($outPath) or die "'$outPath' $!";
		print FILE $text;
		close FILE;
		utime $mtime, $mtime, FS($outPath);
	}
}

sub getItemName {
	my ($id) = @_;

	my $sql = "SELECT name,add_name FROM itemname_ja WHERE id=?";
	my $sth = $db->prepare($sql);
	$sth->execute($id) or die DBI::errstr;
	$sth->bind_columns(undef, \(my($N_name,$N_add_name))) or die DBI::errstr;
	my $rc = $sth->fetch();

	return $N_add_name ? join ' - ', $N_name,$N_add_name : $N_name
}
