/*
 * Copyright (C) 2004-2013 L2J DataPack
 * 
 * This file is part of L2J DataPack.
 * 
 * L2J DataPack is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * L2J DataPack is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package ai.npc.NpcBuffers.impl;

import static ai.npc.NpcBuffers.impl.NpcBuffUtil.*;
import static com.l2jserver.gameserver.datatables.SkillData.*;

import java.util.concurrent.ScheduledFuture;
import java.util.logging.Level;

import ai.npc.AbstractNpcAI;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.datatables.NpcData;
import com.l2jserver.gameserver.instancemanager.QuestManager;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.model.skills.AbnormalType;
import com.l2jserver.gameserver.model.skills.EffectScope;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.model.skills.targets.L2TargetType;
import com.l2jserver.gameserver.model.zone.ZoneId;
import com.l2jserver.gameserver.network.serverpackets.PlaySound;
import com.l2jserver.util.Rnd;

//@formatter:off
/**
 * @author Drunkard, Zabb0x
 * 
 * @author JOJO
 * 
 * NPC          13006   NX}X c[  (type: L2Npc)
 * |ACe    5560    NX}X c[
 * |XL  2137-1  c[
 * 
 * NPC          13007   NX}X c[  (type: L2Npc)
 * |ACe    5561    NX}X c[
 * |XL  2138-1  c[
 * |BUFXL   2139-1  c[̉񕜃{[iX - NX}X Cxg̍c[ʁBHP񕜃{[iXAMP񕜃{[iXサԁB
 */
public class ChristmasTreeBuffer extends AbstractNpcAI
{
	private static final int SPECIAL_CHRISTMAS_TREE = 13007;
	
	static final int RECOVERY_BONUS = getSkillHashCode(2139, 1);	// c[̉񕜃{[iX
	
	static final int[] SUPPORT_MAGICS = {
		getSkillHashCode(4262, 2),	// NX}X EBh EH[N^莞ԁAړxサԁB2B
		getSkillHashCode(4263, 1),	// NX}X wCXg^ꎞIɍUxコB1B
		getSkillHashCode(4264, 1),	// NX}X Gp[^ꎞIɖ͂サԁB1B
		getSkillHashCode(4265, 3),	// NX}X }Cg^ꎞIɍU͂サԁB3B
		getSkillHashCode(4266, 3),	// NX}X V[h^ꎞIɖh͂サԁB3B
	};
	
	private static final String[] XMASS_SONGS = {
		"CC_01", "CC_02", "CC_03", "CC_04", "CC_05", "CC_06"
	};
	
	private ChristmasTreeBuffer()
	{
		super(ChristmasTreeBuffer.class.getSimpleName(), "ai/npc/NpcBuffers/impl");
		
		// game/data/scripts/ai/npc/NpcBuffers/NpcBuffersData.xml
		//	<npc id="13007"> <!-- Special Christmas Tree -->
		//		<skill id="2139" level="1" initialDelay="1" delay="10" affectScope="RANGE" affectObject="FRIEND" /> <!-- Special Tree Recovery Bonus -->
		//	</npc>
		Quest questNpcBuffers = QuestManager.getInstance().getQuest(ai.npc.NpcBuffers.NpcBuffers.class.getSimpleName());
		if (questNpcBuffers == null) _log.log(Level.WARNING, "ai/npc/NpcBuffers/impl/ChristmasTreeBuffer.java:86: Can not find quest '" + ai.npc.NpcBuffers.NpcBuffers.class.getName() + "'");
		L2NpcTemplate npcTemplate = NpcData.getInstance().getTemplate(SPECIAL_CHRISTMAS_TREE);
		npcTemplate.removeQuest(questNpcBuffers);
		
		addFirstTalkId(SPECIAL_CHRISTMAS_TREE);
		addSpawnId(SPECIAL_CHRISTMAS_TREE);
		
		if (NOTDONE(getSkill(RECOVERY_BONUS))) throw new RuntimeException();
	}
	
	private boolean NOTDONE(Skill skill)
	{
		return skill.getTargetType() == L2TargetType.NONE && skill.getAbnormalType() == AbnormalType.NONE && skill.getEffects(EffectScope.GENERAL) == null;
	}
	
	@Override
	public String onFirstTalk(L2Npc npc, L2PcInstance player)
	{
		return null;
	}
	
	@Override
	public String onSpawn(L2Npc npc)
	{
		if (npc.isInsideZone(ZoneId.PEACE)) return null;
		new ChristmasTreeAI(npc);
		npc.broadcastPacket(new PlaySound(XMASS_SONGS[Rnd.get(XMASS_SONGS.length)]));
		return null;
	}
	
	private static class ChristmasTreeAI implements Runnable
	{
		private final L2Npc _npc;
		private int _index = 0;
		private final ScheduledFuture<?> _aiTask;
		
		protected ChristmasTreeAI(L2Npc npc)
		{
			_npc = npc;
			_aiTask = ThreadPoolManager.getInstance().scheduleGeneralWithFixedDelay(this, 3000, 3000);
		}
		
		@Override
		public void run()
		{
			if (!_npc.isVisible())
			{
				_aiTask.cancel(false);
				return;
			}
			
			final Skill recoveryBonus = getSkill(RECOVERY_BONUS);
			final Skill supportMagic = getSkill(SUPPORT_MAGICS[_index]);
			final int skillRadius = recoveryBonus.getAffectRange();
			for (L2PcInstance player : _npc.getKnownList().getKnownPlayers().values())
			{
				if (player == null || !player.isVisible() || player.isInvul() || player.isMovementDisabled())
					continue;
				if (player.getPkKills() > 5)
					continue;
				if (!player.isInsideRadius(_npc, skillRadius, true, true))
					continue;
				if (player.getCurrentHp() < player.getMaxHp()
				 || player.getCurrentMp() < player.getMaxMp())
				{
					handleEffect(player, recoveryBonus);
				}
				else
				{
					handleBuff(_npc, player, supportMagic);
				}
			}
			_index = (_index + 1) % SUPPORT_MAGICS.length;
		}
	}
	
	public static void main(String[] args)
	{
		new ChristmasTreeBuffer();
	}
}
