/**
 * [JOJO]
 *   Copy from  http://www.l2jserver.com/forum/viewtopic.php?f=69&t=13999
 */

package handlers.effecthandlers;

import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.conditions.Condition;
import com.l2jserver.gameserver.model.effects.AbstractEffect;
import com.l2jserver.gameserver.model.effects.EffectFlag;
import com.l2jserver.gameserver.model.effects.L2EffectType;
import com.l2jserver.gameserver.model.skills.AbnormalVisualEffect;
import com.l2jserver.gameserver.model.skills.BuffInfo;

/**
 * @author KKnD
 *
 */
public final class DanceStun extends AbstractEffect
{
	public DanceStun(Condition attachCond, Condition applyCond, StatsSet set, StatsSet params)
	{
		super(attachCond, applyCond, set, params);
	}

	@Override
	public L2EffectType getEffectType()
	{
		return L2EffectType.STUN;
	}

	@Override
	public boolean canStart(BuffInfo info)
	{
		final L2Character effected = info.getEffected();

		if (effected.isStunned() || effected.isImmobilized())
			return false;
		int e = effected.getAbnormalVisualEffects();
		if ((e & AbnormalVisualEffect.FLOATING_ROOT.getMask()) != 0
		  ||(e & AbnormalVisualEffect.DANCE_ROOT.getMask()) != 0)
			return false;
		
		return true;
	}

	/** Notify started */
	@Override
	public void onStart(BuffInfo info)
	{
		final L2Character effected = info.getEffected();

		effected.setTarget(null);
		effected.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
		effected.abortAttack();
		effected.abortCast();

		effected.startAbnormalVisualEffect(true, AbnormalVisualEffect.DANCE_ROOT);
		effected.setIsImmobilized(true);
		effected.disableAllSkills();
	}

	/** Notify exited */
	@Override
	public void onExit(BuffInfo info)
	{
		L2Character effected = info.getEffected();
		effected.stopAbnormalVisualEffect(true, AbnormalVisualEffect.DANCE_ROOT);
		effected.setIsImmobilized(false);
		effected.enableAllSkills();
	}

	@Override
	public boolean onActionTime(BuffInfo info)
	{
		// just stop this effect
		return false;
	}
	
	@Override
	public int getEffectFlags()
	{
		return EffectFlag.STUNNED.getMask();
	}
}