/*
 * Copyright (C) 2004-2014 L2J DataPack
 * 
 * This file is part of L2J DataPack.
 * 
 * L2J DataPack is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * L2J DataPack is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package handlers.effecthandlers;

import static com.l2jserver.gameserver.datatables.SkillData.*;

import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.conditions.Condition;
import com.l2jserver.gameserver.model.effects.AbstractEffect;
import com.l2jserver.gameserver.model.effects.L2EffectType;
import com.l2jserver.gameserver.model.skills.BuffInfo;
import com.l2jserver.util.ExArrays;

/**
 * Resist Skill effect implementaion.
 * @author UnAfraid
 */
public final class ResistSkill extends AbstractEffect
{
	private final int[] _skills;
	
	public ResistSkill(Condition attachCond, Condition applyCond, StatsSet set, StatsSet params)
	{
		super(attachCond, applyCond, set, params);
		
		int[] skills = null;
		for (int i = 1;; i++)
		{
			int skillId = params.getInt("skillId" + i, 0);
			int skillLvl = params.getInt("skillLvl" + i, 0);
			if (skillId == 0)
			{
				break;
			}
			skills = ExArrays.push(skills, getSkillHashCode(skillId, skillLvl));
		}
		
		if (skills == null)
		{
			throw new IllegalArgumentException(getClass().getSimpleName() + ": Without parameters!");
		}
		_skills = skills;
	}
	
	@Override
	public void onStart(BuffInfo info)
	{
		final L2Character effected = info.getEffected();
		for (int skillHashCode : _skills)
		{
			effected.addInvulAgainst(getSkillId(skillHashCode), getSkillLevel(skillHashCode));
			effected.sendDebugMessage("Applying invul against " + getSkill(skillHashCode));
		}
	}
	
	@Override
	public void onExit(BuffInfo info)
	{
		final L2Character effected = info.getEffected();
		for (int skillHashCode : _skills)
		{
			effected.removeInvulAgainst(getSkillId(skillHashCode), getSkillLevel(skillHashCode));
			effected.sendDebugMessage("Removing invul against " + getSkill(skillHashCode));
		}
	}
	
	@Override
	public L2EffectType getEffectType()
	{
		return L2EffectType.BUFF;
	}
}
